/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.schema.api;

import io.weaviate.client.Config;
import io.weaviate.client.base.BaseClient;
import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.base.util.DbVersionSupport;
import io.weaviate.client.base.util.UrlEncoder;
import io.weaviate.client.v1.schema.model.Tenant;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TenantsUpdater
extends BaseClient<Tenant[]>
implements ClientResult<Boolean> {
    private static final int BATCH_SIZE = 100;
    private final DbVersionSupport dbVersionSupport;
    private String className;
    private Tenant[] tenants;

    public TenantsUpdater(HttpClient httpClient, Config config, DbVersionSupport dbVersionSupport) {
        super(httpClient, config);
        this.dbVersionSupport = dbVersionSupport;
    }

    public TenantsUpdater withClassName(String className) {
        this.className = className;
        return this;
    }

    public TenantsUpdater withTenants(Tenant ... tenants) {
        this.tenants = tenants;
        return this;
    }

    @Override
    public Result<Boolean> run() {
        if (this.dbVersionSupport.supportsOnly100TenantsInOneRequest() && this.tenants != null && this.tenants.length > 100) {
            for (List<Tenant> batch : this.chunkTenants(this.tenants, 100)) {
                Result<Boolean> resp = this.updateTenants(batch.toArray(new Tenant[0]));
                if (!resp.hasErrors()) continue;
                return resp;
            }
            return new Result<Boolean>(200, true, null);
        }
        return this.updateTenants(this.tenants);
    }

    private Result<Boolean> updateTenants(Tenant[] tenants) {
        String path = String.format("/schema/%s/tenants", UrlEncoder.encodePathParam(this.className));
        Response<Tenant[]> resp = this.sendPutRequest(path, tenants, Tenant[].class);
        return new Result<Boolean>(resp.getStatusCode(), resp.getStatusCode() == 200, resp.getErrors());
    }

    private Collection<List<Tenant>> chunkTenants(Tenant[] tenants, int chunkSize) {
        AtomicInteger counter = new AtomicInteger();
        return Stream.of(tenants).collect(Collectors.groupingBy(it -> counter.getAndIncrement() / chunkSize)).values();
    }
}

