/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.base.util;

import io.weaviate.client.base.util.DbVersionSupport;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class BeaconPath {
    private final DbVersionSupport support;

    public BeaconPath(DbVersionSupport support) {
        this.support = support;
    }

    public String buildBatchFrom(Params pathParams) {
        return this.build(pathParams, this::addClassName, this::addId, this::addProperty);
    }

    public String buildBatchTo(Params pathParams) {
        return this.build(pathParams, this::addClassNameDeprecatedNotSupportedCheck, this::addId);
    }

    public String buildSingle(Params pathParams) {
        return this.build(pathParams, this::addClassNameDeprecatedNotSupportedCheck, this::addId);
    }

    @SafeVarargs
    private final String build(Params pathParams, BiConsumer<StringBuilder, Params> ... modifiers) {
        Objects.requireNonNull(pathParams);
        StringBuilder path = new StringBuilder("weaviate://localhost");
        Arrays.stream(modifiers).forEach(consumer -> consumer.accept(path, pathParams));
        return path.toString();
    }

    private void addClassNameDeprecatedNotSupportedCheck(StringBuilder path, Params pathParams) {
        if (this.support.supportsClassNameNamespacedEndpoints()) {
            if (StringUtils.isNotBlank((CharSequence)pathParams.className)) {
                path.append("/").append(StringUtils.trim((String)pathParams.className));
            } else {
                this.support.warnDeprecatedNonClassNameNamespacedEndpointsForBeacons();
            }
        } else if (StringUtils.isNotBlank((CharSequence)pathParams.className)) {
            this.support.warnNotSupportedClassNamespacedEndpointsForBeacons();
        }
    }

    private void addClassName(StringBuilder path, Params pathParams) {
        if (StringUtils.isNotBlank((CharSequence)pathParams.className)) {
            path.append("/").append(StringUtils.trim((String)pathParams.className));
        }
    }

    private void addId(StringBuilder path, Params pathParams) {
        if (StringUtils.isNotBlank((CharSequence)pathParams.id)) {
            path.append("/").append(StringUtils.trim((String)pathParams.id));
        }
    }

    private void addProperty(StringBuilder path, Params pathParams) {
        if (StringUtils.isNotBlank((CharSequence)pathParams.property)) {
            path.append("/").append(StringUtils.trim((String)pathParams.property));
        }
    }

    public static class Params {
        private final String id;
        private final String className;
        private final String property;

        @Generated
        Params(String id, String className, String property) {
            this.id = id;
            this.className = className;
            this.property = property;
        }

        @Generated
        public static ParamsBuilder builder() {
            return new ParamsBuilder();
        }

        @Generated
        public String toString() {
            return "BeaconPath.Params(id=" + this.id + ", className=" + this.className + ", property=" + this.property + ")";
        }

        @Generated
        public static class ParamsBuilder {
            @Generated
            private String id;
            @Generated
            private String className;
            @Generated
            private String property;

            @Generated
            ParamsBuilder() {
            }

            @Generated
            public ParamsBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public ParamsBuilder className(String className) {
                this.className = className;
                return this;
            }

            @Generated
            public ParamsBuilder property(String property) {
                this.property = property;
                return this;
            }

            @Generated
            public Params build() {
                return new Params(this.id, this.className, this.property);
            }

            @Generated
            public String toString() {
                return "BeaconPath.Params.ParamsBuilder(id=" + this.id + ", className=" + this.className + ", property=" + this.property + ")";
            }
        }
    }
}

