/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.async.batch.api;

import io.weaviate.client.Config;
import io.weaviate.client.base.AsyncBaseClient;
import io.weaviate.client.base.AsyncClientResult;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.WeaviateError;
import io.weaviate.client.base.WeaviateErrorMessage;
import io.weaviate.client.base.WeaviateErrorResponse;
import io.weaviate.client.base.util.Assert;
import io.weaviate.client.base.util.Futures;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import io.weaviate.client.v1.batch.model.BatchReference;
import io.weaviate.client.v1.batch.model.BatchReferenceResponse;
import io.weaviate.client.v1.batch.util.ReferencesPath;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;

public class ReferencesBatcher
extends AsyncBaseClient<BatchReferenceResponse[]>
implements AsyncClientResult<BatchReferenceResponse[]> {
    private final ReferencesPath referencesPath;
    private final BatchRetriesConfig batchRetriesConfig;
    private final AutoBatchConfig autoBatchConfig;
    private final boolean autoRunEnabled;
    private final Executor executor;
    private final List<CompletableFuture<Result<BatchReferenceResponse[]>>> futures;
    private final List<BatchReference> references;
    private String consistencyLevel;

    private ReferencesBatcher(CloseableHttpAsyncClient client, Config config, AccessTokenProvider tokenProvider, ReferencesPath referencesPath, BatchRetriesConfig batchRetriesConfig, AutoBatchConfig autoBatchConfig, Executor executor) {
        super(client, config, tokenProvider);
        this.referencesPath = referencesPath;
        this.futures = Collections.synchronizedList(new ArrayList());
        this.references = Collections.synchronizedList(new ArrayList());
        this.batchRetriesConfig = batchRetriesConfig;
        this.executor = executor;
        if (autoBatchConfig != null) {
            this.autoRunEnabled = true;
            this.autoBatchConfig = autoBatchConfig;
        } else {
            this.autoRunEnabled = false;
            this.autoBatchConfig = null;
        }
    }

    public static ReferencesBatcher create(CloseableHttpAsyncClient client, Config config, AccessTokenProvider tokenProvider, ReferencesPath referencesPath, BatchRetriesConfig batchRetriesConfig, Executor executor) {
        Assert.requiredNotNull(batchRetriesConfig, "batchRetriesConfig");
        return new ReferencesBatcher(client, config, tokenProvider, referencesPath, batchRetriesConfig, null, executor);
    }

    public static ReferencesBatcher createAuto(CloseableHttpAsyncClient client, Config config, AccessTokenProvider tokenProvider, ReferencesPath referencesPath, BatchRetriesConfig batchRetriesConfig, AutoBatchConfig autoBatchConfig, Executor executor) {
        Assert.requiredNotNull(batchRetriesConfig, "batchRetriesConfig");
        Assert.requiredNotNull(autoBatchConfig, "autoBatchConfig");
        return new ReferencesBatcher(client, config, tokenProvider, referencesPath, batchRetriesConfig, autoBatchConfig, executor);
    }

    public ReferencesBatcher withReference(BatchReference reference) {
        return this.withReferences(reference);
    }

    public ReferencesBatcher withReferences(BatchReference ... references) {
        this.references.addAll(Arrays.asList(references));
        this.autoRun();
        return this;
    }

    public ReferencesBatcher withConsistencyLevel(String consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    @Override
    public Future<Result<BatchReferenceResponse[]>> run(FutureCallback<Result<BatchReferenceResponse[]>> callback) {
        CompletionStage<Result<Object>> future = this.runAll();
        if (callback != null) {
            future = future.whenComplete((result, throwable) -> {
                if (throwable != null) {
                    callback.failed((Exception)throwable);
                } else {
                    callback.completed(result);
                }
            });
        }
        return future;
    }

    private CompletableFuture<Result<BatchReferenceResponse[]>> runAll() {
        if (!this.autoRunEnabled) {
            if (this.references.isEmpty()) {
                return CompletableFuture.completedFuture(new Result<BatchReferenceResponse[]>(0, new BatchReferenceResponse[0], null));
            }
            List<BatchReference> batch = this.extractBatch(this.references.size());
            return this.runBatchRecursively(batch, 0, 0);
        }
        if (!this.references.isEmpty()) {
            List<BatchReference> batch = this.extractBatch(this.references.size());
            this.runBatch(batch);
        }
        if (this.futures.isEmpty()) {
            return CompletableFuture.completedFuture(new Result<BatchReferenceResponse[]>(0, new BatchReferenceResponse[0], null));
        }
        CompletableFuture[] futuresAsArray = this.futures.toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(futuresAsArray).thenApply(v -> {
            ArrayList allResponses = new ArrayList();
            ArrayList<WeaviateErrorMessage> allMessages = new ArrayList<WeaviateErrorMessage>();
            int[] lastErrStatusCode = new int[]{200};
            this.futures.stream().map(resultCompletableFuture -> {
                try {
                    return (Result)resultCompletableFuture.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new CompletionException(e);
                }
            }).forEach(result -> {
                Optional.ofNullable(result).map(Result::getResult).map(Arrays::asList).ifPresent(allResponses::addAll);
                Optional.ofNullable(result).filter(Result::hasErrors).map(Result::getError).map(WeaviateError::getMessages).ifPresent(allMessages::addAll);
                Optional.ofNullable(result).filter(Result::hasErrors).map(Result::getError).map(WeaviateError::getStatusCode).ifPresent(sc -> {
                    lastErrStatusCode[0] = sc;
                });
            });
            WeaviateErrorResponse errorResponse = allMessages.isEmpty() ? null : WeaviateErrorResponse.builder().error(allMessages).code(lastErrStatusCode[0]).build();
            return new Result<BatchReferenceResponse[]>(lastErrStatusCode[0], allResponses.toArray(new BatchReferenceResponse[0]), errorResponse);
        });
    }

    private List<BatchReference> extractBatch(int batchSize) {
        ArrayList<BatchReference> batch = new ArrayList<BatchReference>(batchSize);
        List<BatchReference> sublist = this.references.subList(0, batchSize);
        batch.addAll(sublist);
        sublist.clear();
        return batch;
    }

    private void autoRun() {
        if (!this.autoRunEnabled) {
            return;
        }
        while (this.references.size() >= this.autoBatchConfig.batchSize) {
            List<BatchReference> batch = this.extractBatch(this.autoBatchConfig.batchSize);
            this.runBatch(batch);
        }
    }

    private void runBatch(List<BatchReference> batch) {
        CompletionStage<Result<Object>> future = this.runBatchRecursively(batch, 0, 0);
        if (this.autoBatchConfig.callback != null) {
            future = future.whenComplete((result, e) -> this.autoBatchConfig.callback.accept(result));
        }
        this.futures.add((CompletableFuture<Result<BatchReferenceResponse[]>>)future);
    }

    private CompletableFuture<Result<BatchReferenceResponse[]>> runBatchRecursively(List<BatchReference> batch, int connectionErrorCount, int timeoutErrorCount) {
        return Futures.handleAsync(this.internalRun(batch), (result, throwable) -> {
            if (throwable != null) {
                boolean executeAgain = false;
                int tempConnCount = connectionErrorCount;
                int tempTimeCount = timeoutErrorCount;
                int delay = 0;
                if (throwable instanceof ConnectException) {
                    if (tempConnCount++ < this.batchRetriesConfig.maxConnectionRetries) {
                        executeAgain = true;
                        delay = tempConnCount * this.batchRetriesConfig.retriesIntervalMs;
                    }
                } else if (throwable instanceof SocketTimeoutException && tempTimeCount++ < this.batchRetriesConfig.maxTimeoutRetries) {
                    executeAgain = true;
                    delay = tempTimeCount * this.batchRetriesConfig.retriesIntervalMs;
                }
                if (executeAgain) {
                    int finalConnCount = tempConnCount;
                    int finalTimeCount = tempTimeCount;
                    try {
                        return Futures.supplyDelayed(() -> this.runBatchRecursively(batch, finalConnCount, finalTimeCount), delay, this.executor);
                    }
                    catch (InterruptedException e) {
                        throw new CompletionException(e);
                    }
                }
            }
            return CompletableFuture.completedFuture(this.createFinalResultFromLastResult((Result<BatchReferenceResponse[]>)result, (Throwable)throwable, batch));
        }, this.executor);
    }

    private CompletableFuture<Result<BatchReferenceResponse[]>> internalRun(List<BatchReference> batch) {
        final CompletableFuture<Result<BatchReferenceResponse[]>> future = new CompletableFuture<Result<BatchReferenceResponse[]>>();
        BatchReference[] payload = batch.toArray(new BatchReference[0]);
        String path = this.referencesPath.buildCreate(ReferencesPath.Params.builder().consistencyLevel(this.consistencyLevel).build());
        this.sendPostRequest(path, (Object)payload, BatchReferenceResponse[].class, new FutureCallback<Result<BatchReferenceResponse[]>>(){

            public void completed(Result<BatchReferenceResponse[]> batchResult) {
                future.complete(batchResult);
            }

            public void failed(Exception e) {
                future.completeExceptionally(e);
            }

            public void cancelled() {
            }
        });
        return future;
    }

    private Result<BatchReferenceResponse[]> createFinalResultFromLastResult(Result<BatchReferenceResponse[]> lastResult, Throwable throwable, List<BatchReference> batch) {
        if (lastResult != null) {
            return lastResult;
        }
        int statusCode = 0;
        String failedRefs = batch.stream().map(ref -> ref.getFrom() + " => " + ref.getTo()).collect(Collectors.joining(", "));
        WeaviateErrorMessage failedRefsMessage = WeaviateErrorMessage.builder().message("Failed refs: " + failedRefs).build();
        WeaviateErrorMessage throwableMessage = WeaviateErrorMessage.builder().message(throwable.getMessage()).throwable(throwable).build();
        return new Result<Object>(statusCode, null, WeaviateErrorResponse.builder().error(Arrays.asList(throwableMessage, failedRefsMessage)).code(statusCode).build());
    }

    public static class BatchRetriesConfig {
        public static final int MAX_TIMEOUT_RETRIES = 3;
        public static final int MAX_CONNECTION_RETRIES = 3;
        public static final int RETRIES_INTERVAL = 2000;
        private final int maxTimeoutRetries;
        private final int maxConnectionRetries;
        private final int retriesIntervalMs;

        private BatchRetriesConfig(int maxTimeoutRetries, int maxConnectionRetries, int retriesIntervalMs) {
            Assert.requireGreaterEqual(maxTimeoutRetries, 0, "maxTimeoutRetries");
            Assert.requireGreaterEqual(maxConnectionRetries, 0, "maxConnectionRetries");
            Assert.requireGreater(retriesIntervalMs, 0, "retriesIntervalMs");
            this.maxTimeoutRetries = maxTimeoutRetries;
            this.maxConnectionRetries = maxConnectionRetries;
            this.retriesIntervalMs = retriesIntervalMs;
        }

        public static BatchRetriesConfigBuilder defaultConfig() {
            return BatchRetriesConfig.builder().maxTimeoutRetries(3).maxConnectionRetries(3).retriesIntervalMs(2000);
        }

        @Generated
        public static BatchRetriesConfigBuilder builder() {
            return new BatchRetriesConfigBuilder();
        }

        @Generated
        public int getMaxTimeoutRetries() {
            return this.maxTimeoutRetries;
        }

        @Generated
        public int getMaxConnectionRetries() {
            return this.maxConnectionRetries;
        }

        @Generated
        public int getRetriesIntervalMs() {
            return this.retriesIntervalMs;
        }

        @Generated
        public String toString() {
            return "ReferencesBatcher.BatchRetriesConfig(maxTimeoutRetries=" + this.getMaxTimeoutRetries() + ", maxConnectionRetries=" + this.getMaxConnectionRetries() + ", retriesIntervalMs=" + this.getRetriesIntervalMs() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BatchRetriesConfig)) {
                return false;
            }
            BatchRetriesConfig other = (BatchRetriesConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxTimeoutRetries() != other.getMaxTimeoutRetries()) {
                return false;
            }
            if (this.getMaxConnectionRetries() != other.getMaxConnectionRetries()) {
                return false;
            }
            return this.getRetriesIntervalMs() == other.getRetriesIntervalMs();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BatchRetriesConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxTimeoutRetries();
            result = result * 59 + this.getMaxConnectionRetries();
            result = result * 59 + this.getRetriesIntervalMs();
            return result;
        }

        @Generated
        public static class BatchRetriesConfigBuilder {
            @Generated
            private int maxTimeoutRetries;
            @Generated
            private int maxConnectionRetries;
            @Generated
            private int retriesIntervalMs;

            @Generated
            BatchRetriesConfigBuilder() {
            }

            @Generated
            public BatchRetriesConfigBuilder maxTimeoutRetries(int maxTimeoutRetries) {
                this.maxTimeoutRetries = maxTimeoutRetries;
                return this;
            }

            @Generated
            public BatchRetriesConfigBuilder maxConnectionRetries(int maxConnectionRetries) {
                this.maxConnectionRetries = maxConnectionRetries;
                return this;
            }

            @Generated
            public BatchRetriesConfigBuilder retriesIntervalMs(int retriesIntervalMs) {
                this.retriesIntervalMs = retriesIntervalMs;
                return this;
            }

            @Generated
            public BatchRetriesConfig build() {
                return new BatchRetriesConfig(this.maxTimeoutRetries, this.maxConnectionRetries, this.retriesIntervalMs);
            }

            @Generated
            public String toString() {
                return "ReferencesBatcher.BatchRetriesConfig.BatchRetriesConfigBuilder(maxTimeoutRetries=" + this.maxTimeoutRetries + ", maxConnectionRetries=" + this.maxConnectionRetries + ", retriesIntervalMs=" + this.retriesIntervalMs + ")";
            }
        }
    }

    public static class AutoBatchConfig {
        public static final int BATCH_SIZE = 100;
        private final int batchSize;
        private final Consumer<Result<BatchReferenceResponse[]>> callback;

        private AutoBatchConfig(int batchSize, Consumer<Result<BatchReferenceResponse[]>> callback) {
            Assert.requireGreaterEqual(batchSize, 1, "batchSize");
            this.batchSize = batchSize;
            this.callback = callback;
        }

        public static AutoBatchConfigBuilder defaultConfig() {
            return AutoBatchConfig.builder().batchSize(100).callback(null);
        }

        @Generated
        public static AutoBatchConfigBuilder builder() {
            return new AutoBatchConfigBuilder();
        }

        @Generated
        public int getBatchSize() {
            return this.batchSize;
        }

        @Generated
        public Consumer<Result<BatchReferenceResponse[]>> getCallback() {
            return this.callback;
        }

        @Generated
        public String toString() {
            return "ReferencesBatcher.AutoBatchConfig(batchSize=" + this.getBatchSize() + ", callback=" + this.getCallback() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AutoBatchConfig)) {
                return false;
            }
            AutoBatchConfig other = (AutoBatchConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getBatchSize() != other.getBatchSize()) {
                return false;
            }
            Consumer<Result<BatchReferenceResponse[]>> this$callback = this.getCallback();
            Consumer<Result<BatchReferenceResponse[]>> other$callback = other.getCallback();
            return !(this$callback == null ? other$callback != null : !this$callback.equals(other$callback));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AutoBatchConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getBatchSize();
            Consumer<Result<BatchReferenceResponse[]>> $callback = this.getCallback();
            result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
            return result;
        }

        @Generated
        public static class AutoBatchConfigBuilder {
            @Generated
            private int batchSize;
            @Generated
            private Consumer<Result<BatchReferenceResponse[]>> callback;

            @Generated
            AutoBatchConfigBuilder() {
            }

            @Generated
            public AutoBatchConfigBuilder batchSize(int batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            @Generated
            public AutoBatchConfigBuilder callback(Consumer<Result<BatchReferenceResponse[]>> callback) {
                this.callback = callback;
                return this;
            }

            @Generated
            public AutoBatchConfig build() {
                return new AutoBatchConfig(this.batchSize, this.callback);
            }

            @Generated
            public String toString() {
                return "ReferencesBatcher.AutoBatchConfig.AutoBatchConfigBuilder(batchSize=" + this.batchSize + ", callback=" + this.callback + ")";
            }
        }
    }
}

