/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.backup.api;

import com.google.gson.annotations.SerializedName;
import io.weaviate.client.Config;
import io.weaviate.client.base.BaseClient;
import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.v1.backup.api.BackupCreateStatusGetter;
import io.weaviate.client.v1.backup.model.BackupCreateResponse;
import io.weaviate.client.v1.backup.model.BackupCreateStatusResponse;
import java.util.Arrays;
import lombok.Generated;

public class BackupCreator
extends BaseClient<BackupCreateResponse>
implements ClientResult<BackupCreateResponse> {
    private static final long WAIT_INTERVAL = 1000L;
    private final BackupCreateStatusGetter statusGetter;
    private String[] includeClassNames;
    private String[] excludeClassNames;
    private String backend;
    private String backupId;
    private BackupCreateConfig config;
    private boolean waitForCompletion;

    public BackupCreator(HttpClient httpClient, Config config, BackupCreateStatusGetter statusGetter) {
        super(httpClient, config);
        this.statusGetter = statusGetter;
    }

    public BackupCreator withIncludeClassNames(String ... classNames) {
        this.includeClassNames = classNames;
        return this;
    }

    public BackupCreator withExcludeClassNames(String ... classNames) {
        this.excludeClassNames = classNames;
        return this;
    }

    public BackupCreator withBackend(String backend) {
        this.backend = backend;
        return this;
    }

    public BackupCreator withBackupId(String backupId) {
        this.backupId = backupId;
        return this;
    }

    public BackupCreator withConfig(BackupCreateConfig config) {
        this.config = config;
        return this;
    }

    public BackupCreator withWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    @Override
    public Result<BackupCreateResponse> run() {
        BackupCreate payload = BackupCreate.builder().id(this.backupId).config(this.config).include(this.includeClassNames).exclude(this.excludeClassNames).build();
        if (this.waitForCompletion) {
            return this.createAndWaitForCompletion(payload);
        }
        return this.create(payload);
    }

    private Result<BackupCreateResponse> create(BackupCreate payload) {
        Response<BackupCreateResponse> response = this.sendPostRequest(this.path(), payload, BackupCreateResponse.class);
        return new Result<BackupCreateResponse>(response);
    }

    private Result<BackupCreateResponse> createAndWaitForCompletion(BackupCreate payload) {
        Result<BackupCreateResponse> result = this.create(payload);
        if (result.hasErrors()) {
            return result;
        }
        this.statusGetter.withBackend(this.backend).withBackupId(this.backupId);
        Response<BackupCreateStatusResponse> statusResponse;
        while (!new Result<BackupCreateStatusResponse>(statusResponse = this.statusGetter.statusCreate()).hasErrors()) {
            switch (statusResponse.getBody().getStatus()) {
                case "SUCCESS": 
                case "FAILED": {
                    return this.merge(statusResponse, result);
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return this.merge(statusResponse, result);
            }
        }
        return this.merge(statusResponse, result);
    }

    private String path() {
        return String.format("/backups/%s", this.backend);
    }

    private Result<BackupCreateResponse> merge(Response<BackupCreateStatusResponse> response, Result<BackupCreateResponse> result) {
        BackupCreateStatusResponse statusCreateResponse = response.getBody();
        BackupCreateResponse createResponse = result.getResult();
        BackupCreateResponse merged = null;
        if (statusCreateResponse != null) {
            merged = new BackupCreateResponse();
            merged.setId(statusCreateResponse.getId());
            merged.setBackend(statusCreateResponse.getBackend());
            merged.setPath(statusCreateResponse.getPath());
            merged.setStatus(statusCreateResponse.getStatus());
            merged.setError(statusCreateResponse.getError());
            merged.setClassNames(createResponse.getClassNames());
        }
        return new Result<BackupCreateResponse>(response.getStatusCode(), merged, response.getErrors());
    }

    public static class BackupCreateConfig {
        @SerializedName(value="CPUPercentage")
        Integer cpuPercentage;
        @SerializedName(value="ChunkSize")
        Integer chunkSize;
        @SerializedName(value="CompressionLevel")
        String compressionLevel;
        @SerializedName(value="Bucket")
        String bucket;
        @SerializedName(value="Path")
        String path;

        @Generated
        BackupCreateConfig(Integer cpuPercentage, Integer chunkSize, String compressionLevel, String bucket, String path) {
            this.cpuPercentage = cpuPercentage;
            this.chunkSize = chunkSize;
            this.compressionLevel = compressionLevel;
            this.bucket = bucket;
            this.path = path;
        }

        @Generated
        public static BackupCreateConfigBuilder builder() {
            return new BackupCreateConfigBuilder();
        }

        @Generated
        public Integer getCpuPercentage() {
            return this.cpuPercentage;
        }

        @Generated
        public Integer getChunkSize() {
            return this.chunkSize;
        }

        @Generated
        public String getCompressionLevel() {
            return this.compressionLevel;
        }

        @Generated
        public String getBucket() {
            return this.bucket;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public static class BackupCreateConfigBuilder {
            @Generated
            private Integer cpuPercentage;
            @Generated
            private Integer chunkSize;
            @Generated
            private String compressionLevel;
            @Generated
            private String bucket;
            @Generated
            private String path;

            @Generated
            BackupCreateConfigBuilder() {
            }

            @Generated
            public BackupCreateConfigBuilder cpuPercentage(Integer cpuPercentage) {
                this.cpuPercentage = cpuPercentage;
                return this;
            }

            @Generated
            public BackupCreateConfigBuilder chunkSize(Integer chunkSize) {
                this.chunkSize = chunkSize;
                return this;
            }

            @Generated
            public BackupCreateConfigBuilder compressionLevel(String compressionLevel) {
                this.compressionLevel = compressionLevel;
                return this;
            }

            @Generated
            public BackupCreateConfigBuilder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            @Generated
            public BackupCreateConfigBuilder path(String path) {
                this.path = path;
                return this;
            }

            @Generated
            public BackupCreateConfig build() {
                return new BackupCreateConfig(this.cpuPercentage, this.chunkSize, this.compressionLevel, this.bucket, this.path);
            }

            @Generated
            public String toString() {
                return "BackupCreator.BackupCreateConfig.BackupCreateConfigBuilder(cpuPercentage=" + this.cpuPercentage + ", chunkSize=" + this.chunkSize + ", compressionLevel=" + this.compressionLevel + ", bucket=" + this.bucket + ", path=" + this.path + ")";
            }
        }
    }

    private static class BackupCreate {
        String id;
        String[] include;
        String[] exclude;
        BackupCreateConfig config;

        @Generated
        BackupCreate(String id, String[] include, String[] exclude, BackupCreateConfig config) {
            this.id = id;
            this.include = include;
            this.exclude = exclude;
            this.config = config;
        }

        @Generated
        public static BackupCreateBuilder builder() {
            return new BackupCreateBuilder();
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String[] getInclude() {
            return this.include;
        }

        @Generated
        public String[] getExclude() {
            return this.exclude;
        }

        @Generated
        public BackupCreateConfig getConfig() {
            return this.config;
        }

        @Generated
        public static class BackupCreateBuilder {
            @Generated
            private String id;
            @Generated
            private String[] include;
            @Generated
            private String[] exclude;
            @Generated
            private BackupCreateConfig config;

            @Generated
            BackupCreateBuilder() {
            }

            @Generated
            public BackupCreateBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public BackupCreateBuilder include(String[] include) {
                this.include = include;
                return this;
            }

            @Generated
            public BackupCreateBuilder exclude(String[] exclude) {
                this.exclude = exclude;
                return this;
            }

            @Generated
            public BackupCreateBuilder config(BackupCreateConfig config) {
                this.config = config;
                return this;
            }

            @Generated
            public BackupCreate build() {
                return new BackupCreate(this.id, this.include, this.exclude, this.config);
            }

            @Generated
            public String toString() {
                return "BackupCreator.BackupCreate.BackupCreateBuilder(id=" + this.id + ", include=" + Arrays.deepToString(this.include) + ", exclude=" + Arrays.deepToString(this.exclude) + ", config=" + this.config + ")";
            }
        }
    }

    public static interface BackupCompression {
        public static final String DEFAULT_COMPRESSION = "DefaultCompression";
        public static final String BEST_SPEED = "BestSpeed";
        public static final String BEST_COMPRESSION = "BestCompression";
    }
}

