/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.cluster.api;

import io.weaviate.client.Config;
import io.weaviate.client.base.BaseClient;
import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.base.util.UrlEncoder;
import io.weaviate.client.v1.cluster.model.NodesStatusResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class NodesStatusGetter
extends BaseClient<NodesStatusResponse>
implements ClientResult<NodesStatusResponse> {
    private String className;
    private Map<String, Object> queryParams = new HashMap<String, Object>();

    public NodesStatusGetter(HttpClient httpClient, Config config) {
        super(httpClient, config);
    }

    public NodesStatusGetter withClassName(String className) {
        this.className = className;
        return this;
    }

    public NodesStatusGetter withShard(String shard) {
        this.queryParams.put("shard", shard);
        return this;
    }

    public NodesStatusGetter withOutput(String output) {
        this.queryParams.put("output", output);
        return this;
    }

    @Override
    public Result<NodesStatusResponse> run() {
        return new Result<NodesStatusResponse>(this.sendGetRequest(this.path(), NodesStatusResponse.class));
    }

    private String path() {
        String path = "/nodes";
        if (StringUtils.isNotBlank((CharSequence)this.className)) {
            path = path + "/" + UrlEncoder.encodePathParam(this.className);
        }
        ArrayList<String> query = new ArrayList<String>();
        for (Map.Entry<String, Object> qp : this.queryParams.entrySet()) {
            query.add(UrlEncoder.encodeQueryParam(qp.getKey(), qp.getValue().toString()));
        }
        if (!query.isEmpty()) {
            path = path + "?" + String.join((CharSequence)"&", query);
        }
        return path;
    }
}

