/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.experimental;

import io.weaviate.client.grpc.protocol.v1.WeaviateProtoBaseSearch;
import io.weaviate.client.grpc.protocol.v1.WeaviateProtoSearchGet;
import io.weaviate.client.v1.experimental.SearchOptions;
import io.weaviate.client.v1.grpc.GRPC;
import java.util.function.Consumer;

public class NearVector {
    private final float[] vector;
    private final Options opt = new Options();

    void append(WeaviateProtoSearchGet.SearchRequest.Builder search) {
        WeaviateProtoBaseSearch.NearVector.Builder nearVector = WeaviateProtoBaseSearch.NearVector.newBuilder();
        nearVector.setVectorBytes(GRPC.toByteString(this.vector));
        this.opt.append(search, nearVector);
        search.setNearVector(nearVector.build());
    }

    public NearVector(float[] vector, Consumer<Options> options) {
        this.vector = vector;
        options.accept(this.opt);
    }

    public static class Options
    extends SearchOptions<Options> {
        private Float distance;
        private Float certainty;

        public Options distance(float distance) {
            this.distance = Float.valueOf(distance);
            return this;
        }

        public Options certainty(float certainty) {
            this.certainty = Float.valueOf(certainty);
            return this;
        }

        void append(WeaviateProtoSearchGet.SearchRequest.Builder search, WeaviateProtoBaseSearch.NearVector.Builder nearVector) {
            if (this.certainty != null) {
                nearVector.setCertainty(this.certainty.floatValue());
            } else if (this.distance != null) {
                nearVector.setDistance(this.distance.floatValue());
            }
            super.append(search);
        }
    }
}

