/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.argument.Bm25Argument;
import io.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import io.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import io.weaviate.client.v1.graphql.query.argument.Targets;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class HybridArgument
implements Argument {
    private final String query;
    private final Float alpha;
    private final Float maxVectorDistance;
    private final Float[] vector;
    private final String fusionType;
    private final String[] properties;
    private final String[] targetVectors;
    private final Searches searches;
    private final Targets targets;
    private final Bm25Argument.SearchOperator bm25SearchOperator;

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        arg.add(String.format("query:%s", Serializer.quote(this.query)));
        if (this.vector != null) {
            arg.add(String.format("vector:%s", Serializer.array(this.vector)));
        }
        if (this.alpha != null) {
            arg.add(String.format("alpha:%s", this.alpha));
        }
        if (this.maxVectorDistance != null) {
            arg.add(String.format("maxVectorDistance:%s", this.maxVectorDistance));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.properties)) {
            arg.add(String.format("properties:%s", Serializer.arrayWithQuotes(this.properties)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.fusionType)) {
            arg.add(String.format("fusionType:%s", this.fusionType));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.targetVectors)) {
            arg.add(String.format("targetVectors:%s", Serializer.arrayWithQuotes(this.targetVectors)));
        }
        if (this.searches != null && (this.searches.nearVector != null || this.searches.nearText != null)) {
            LinkedHashSet<String> searchesArgs = new LinkedHashSet<String>();
            if (this.searches.nearVector != null) {
                searchesArgs.add(this.searches.nearVector.build());
            }
            if (this.searches.nearText != null) {
                searchesArgs.add(this.searches.nearText.build());
            }
            arg.add(String.format("searches:{%s}", String.join((CharSequence)" ", searchesArgs)));
        }
        if (this.bm25SearchOperator != null) {
            arg.add(String.format("bm25SearchOperator:%s", this.bm25SearchOperator.build()));
        }
        if (this.targets != null) {
            arg.add(String.format("%s", this.targets.build()));
        }
        return String.format("hybrid:{%s}", String.join((CharSequence)" ", arg));
    }

    @Generated
    HybridArgument(String query, Float alpha, Float maxVectorDistance, Float[] vector, String fusionType, String[] properties, String[] targetVectors, Searches searches, Targets targets, Bm25Argument.SearchOperator bm25SearchOperator) {
        this.query = query;
        this.alpha = alpha;
        this.maxVectorDistance = maxVectorDistance;
        this.vector = vector;
        this.fusionType = fusionType;
        this.properties = properties;
        this.targetVectors = targetVectors;
        this.searches = searches;
        this.targets = targets;
        this.bm25SearchOperator = bm25SearchOperator;
    }

    @Generated
    public static HybridArgumentBuilder builder() {
        return new HybridArgumentBuilder();
    }

    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public Float getAlpha() {
        return this.alpha;
    }

    @Generated
    public Float getMaxVectorDistance() {
        return this.maxVectorDistance;
    }

    @Generated
    public Float[] getVector() {
        return this.vector;
    }

    @Generated
    public String getFusionType() {
        return this.fusionType;
    }

    @Generated
    public String[] getProperties() {
        return this.properties;
    }

    @Generated
    public String[] getTargetVectors() {
        return this.targetVectors;
    }

    @Generated
    public Searches getSearches() {
        return this.searches;
    }

    @Generated
    public Targets getTargets() {
        return this.targets;
    }

    @Generated
    public Bm25Argument.SearchOperator getBm25SearchOperator() {
        return this.bm25SearchOperator;
    }

    @Generated
    public String toString() {
        return "HybridArgument(query=" + this.getQuery() + ", alpha=" + this.getAlpha() + ", maxVectorDistance=" + this.getMaxVectorDistance() + ", vector=" + Arrays.deepToString(this.getVector()) + ", fusionType=" + this.getFusionType() + ", properties=" + Arrays.deepToString(this.getProperties()) + ", targetVectors=" + Arrays.deepToString(this.getTargetVectors()) + ", searches=" + this.getSearches() + ", targets=" + this.getTargets() + ", bm25SearchOperator=" + this.getBm25SearchOperator() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HybridArgument)) {
            return false;
        }
        HybridArgument other = (HybridArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$alpha = this.getAlpha();
        Float other$alpha = other.getAlpha();
        if (this$alpha == null ? other$alpha != null : !((Object)this$alpha).equals(other$alpha)) {
            return false;
        }
        Float this$maxVectorDistance = this.getMaxVectorDistance();
        Float other$maxVectorDistance = other.getMaxVectorDistance();
        if (this$maxVectorDistance == null ? other$maxVectorDistance != null : !((Object)this$maxVectorDistance).equals(other$maxVectorDistance)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getVector(), other.getVector())) {
            return false;
        }
        String this$fusionType = this.getFusionType();
        String other$fusionType = other.getFusionType();
        if (this$fusionType == null ? other$fusionType != null : !this$fusionType.equals(other$fusionType)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getProperties(), other.getProperties())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTargetVectors(), other.getTargetVectors())) {
            return false;
        }
        Searches this$searches = this.getSearches();
        Searches other$searches = other.getSearches();
        if (this$searches == null ? other$searches != null : !this$searches.equals(other$searches)) {
            return false;
        }
        Targets this$targets = this.getTargets();
        Targets other$targets = other.getTargets();
        if (this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets)) {
            return false;
        }
        Bm25Argument.SearchOperator this$bm25SearchOperator = this.getBm25SearchOperator();
        Bm25Argument.SearchOperator other$bm25SearchOperator = other.getBm25SearchOperator();
        return !(this$bm25SearchOperator == null ? other$bm25SearchOperator != null : !this$bm25SearchOperator.equals(other$bm25SearchOperator));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HybridArgument;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $alpha = this.getAlpha();
        result = result * 59 + ($alpha == null ? 43 : ((Object)$alpha).hashCode());
        Float $maxVectorDistance = this.getMaxVectorDistance();
        result = result * 59 + ($maxVectorDistance == null ? 43 : ((Object)$maxVectorDistance).hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getVector());
        String $fusionType = this.getFusionType();
        result = result * 59 + ($fusionType == null ? 43 : $fusionType.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getProperties());
        result = result * 59 + Arrays.deepHashCode(this.getTargetVectors());
        Searches $searches = this.getSearches();
        result = result * 59 + ($searches == null ? 43 : $searches.hashCode());
        Targets $targets = this.getTargets();
        result = result * 59 + ($targets == null ? 43 : ((Object)$targets).hashCode());
        Bm25Argument.SearchOperator $bm25SearchOperator = this.getBm25SearchOperator();
        result = result * 59 + ($bm25SearchOperator == null ? 43 : $bm25SearchOperator.hashCode());
        return result;
    }

    public static class Searches {
        private final NearVectorArgument nearVector;
        private final NearTextArgument nearText;

        @Generated
        Searches(NearVectorArgument nearVector, NearTextArgument nearText) {
            this.nearVector = nearVector;
            this.nearText = nearText;
        }

        @Generated
        public static SearchesBuilder builder() {
            return new SearchesBuilder();
        }

        @Generated
        public NearVectorArgument getNearVector() {
            return this.nearVector;
        }

        @Generated
        public NearTextArgument getNearText() {
            return this.nearText;
        }

        @Generated
        public String toString() {
            return "HybridArgument.Searches(nearVector=" + this.getNearVector() + ", nearText=" + this.getNearText() + ")";
        }

        @Generated
        public static class SearchesBuilder {
            @Generated
            private NearVectorArgument nearVector;
            @Generated
            private NearTextArgument nearText;

            @Generated
            SearchesBuilder() {
            }

            @Generated
            public SearchesBuilder nearVector(NearVectorArgument nearVector) {
                this.nearVector = nearVector;
                return this;
            }

            @Generated
            public SearchesBuilder nearText(NearTextArgument nearText) {
                this.nearText = nearText;
                return this;
            }

            @Generated
            public Searches build() {
                return new Searches(this.nearVector, this.nearText);
            }

            @Generated
            public String toString() {
                return "HybridArgument.Searches.SearchesBuilder(nearVector=" + this.nearVector + ", nearText=" + this.nearText + ")";
            }
        }
    }

    @Generated
    public static class HybridArgumentBuilder {
        @Generated
        private String query;
        @Generated
        private Float alpha;
        @Generated
        private Float maxVectorDistance;
        @Generated
        private Float[] vector;
        @Generated
        private String fusionType;
        @Generated
        private String[] properties;
        @Generated
        private String[] targetVectors;
        @Generated
        private Searches searches;
        @Generated
        private Targets targets;
        @Generated
        private Bm25Argument.SearchOperator bm25SearchOperator;

        @Generated
        HybridArgumentBuilder() {
        }

        @Generated
        public HybridArgumentBuilder query(String query) {
            this.query = query;
            return this;
        }

        @Generated
        public HybridArgumentBuilder alpha(Float alpha) {
            this.alpha = alpha;
            return this;
        }

        @Generated
        public HybridArgumentBuilder maxVectorDistance(Float maxVectorDistance) {
            this.maxVectorDistance = maxVectorDistance;
            return this;
        }

        @Generated
        public HybridArgumentBuilder vector(Float[] vector) {
            this.vector = vector;
            return this;
        }

        @Generated
        public HybridArgumentBuilder fusionType(String fusionType) {
            this.fusionType = fusionType;
            return this;
        }

        @Generated
        public HybridArgumentBuilder properties(String[] properties) {
            this.properties = properties;
            return this;
        }

        @Generated
        public HybridArgumentBuilder targetVectors(String[] targetVectors) {
            this.targetVectors = targetVectors;
            return this;
        }

        @Generated
        public HybridArgumentBuilder searches(Searches searches) {
            this.searches = searches;
            return this;
        }

        @Generated
        public HybridArgumentBuilder targets(Targets targets) {
            this.targets = targets;
            return this;
        }

        @Generated
        public HybridArgumentBuilder bm25SearchOperator(Bm25Argument.SearchOperator bm25SearchOperator) {
            this.bm25SearchOperator = bm25SearchOperator;
            return this;
        }

        @Generated
        public HybridArgument build() {
            return new HybridArgument(this.query, this.alpha, this.maxVectorDistance, this.vector, this.fusionType, this.properties, this.targetVectors, this.searches, this.targets, this.bm25SearchOperator);
        }

        @Generated
        public String toString() {
            return "HybridArgument.HybridArgumentBuilder(query=" + this.query + ", alpha=" + this.alpha + ", maxVectorDistance=" + this.maxVectorDistance + ", vector=" + Arrays.deepToString(this.vector) + ", fusionType=" + this.fusionType + ", properties=" + Arrays.deepToString(this.properties) + ", targetVectors=" + Arrays.deepToString(this.targetVectors) + ", searches=" + this.searches + ", targets=" + this.targets + ", bm25SearchOperator=" + this.bm25SearchOperator + ")";
        }
    }
}

