/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.groups.api.oidc;

import com.google.gson.annotations.SerializedName;
import io.weaviate.client.Config;
import io.weaviate.client.base.BaseClient;
import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.base.util.UrlEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public class RoleAssigner
extends BaseClient<Void>
implements ClientResult<Boolean> {
    private String groupId;
    private List<String> roles = new ArrayList<String>();

    public RoleAssigner(HttpClient httpClient, Config config) {
        super(httpClient, config);
    }

    public RoleAssigner withGroupId(String id) {
        this.groupId = id;
        return this;
    }

    public RoleAssigner witRoles(String ... roles) {
        this.roles = Arrays.asList(roles);
        return this;
    }

    private String encodeGroupId() {
        return UrlEncoder.encode(this.groupId);
    }

    @Override
    public Result<Boolean> run() {
        return Result.voidToBoolean(this.sendPostRequest(this.path(), new Body(this.roles), Void.class));
    }

    private String path() {
        return String.format("/authz/groups/%s/assign", this.encodeGroupId());
    }

    private class Body {
        @SerializedName(value="roles")
        final List<String> roles;
        @SerializedName(value="groupType")
        final String groupType = "oidc";

        @Generated
        public Body(List<String> roles) {
            this.roles = roles;
        }
    }
}

