/*
 * Decompiled with CFR 0.152.
 */
package brave.context.rxjava2.internal;

import brave.context.rxjava2.internal.Util;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;

final class TraceContextCompletableObserver
implements CompletableObserver,
Disposable {
    final CompletableObserver downstream;
    final CurrentTraceContext contextScoper;
    final TraceContext assembled;
    Disposable upstream;

    TraceContextCompletableObserver(CompletableObserver downstream, CurrentTraceContext contextScoper, TraceContext assembled) {
        this.downstream = downstream;
        this.contextScoper = contextScoper;
        this.assembled = assembled;
    }

    public void onSubscribe(Disposable d) {
        if (!Util.validate(this.upstream, d)) {
            return;
        }
        this.upstream = d;
        this.downstream.onSubscribe((Disposable)this);
    }

    public void onError(Throwable t) {
        CurrentTraceContext.Scope scope = this.contextScoper.maybeScope(this.assembled);
        try {
            this.downstream.onError(t);
        }
        finally {
            scope.close();
        }
    }

    public void onComplete() {
        CurrentTraceContext.Scope scope = this.contextScoper.maybeScope(this.assembled);
        try {
            this.downstream.onComplete();
        }
        finally {
            scope.close();
        }
    }

    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    public void dispose() {
        this.upstream.dispose();
    }
}

