/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.http.HttpSampler;
import brave.http.HttpServerAdapter;
import brave.http.HttpServerParser;
import brave.http.HttpTracing;
import brave.internal.Nullable;
import brave.internal.Platform;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import zipkin.Endpoint;
import zipkin2.Endpoint;

public final class HttpServerHandler<Req, Resp> {
    final Tracer tracer;
    final HttpSampler sampler;
    final HttpServerParser parser;
    final HttpServerAdapter<Req, Resp> adapter;

    public static <Req, Resp> HttpServerHandler create(HttpTracing httpTracing, HttpServerAdapter<Req, Resp> adapter) {
        return new HttpServerHandler<Req, Resp>(httpTracing, adapter);
    }

    HttpServerHandler(HttpTracing httpTracing, HttpServerAdapter<Req, Resp> adapter) {
        this.tracer = httpTracing.tracing().tracer();
        this.sampler = httpTracing.serverSampler();
        this.parser = httpTracing.serverParser();
        this.adapter = adapter;
    }

    public Span handleReceive(TraceContext.Extractor<Req> extractor, Req request) {
        return this.handleReceive(extractor, request, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C> Span handleReceive(TraceContext.Extractor<C> extractor, C carrier, Req request) {
        Endpoint.Builder remoteEndpoint;
        Endpoint.Builder deprecatedEndpoint;
        Span span = this.nextSpan(extractor.extract(carrier), request);
        if (span.isNoop()) {
            return span;
        }
        span.kind(Span.Kind.SERVER);
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            this.parser.request(this.adapter, request, (SpanCustomizer)span);
        }
        finally {
            ws.close();
        }
        boolean parsedEndpoint = false;
        if (Platform.get().zipkinV1Present() && (parsedEndpoint = this.adapter.parseClientAddress(request, deprecatedEndpoint = zipkin.Endpoint.builder().serviceName("")))) {
            span.remoteEndpoint(deprecatedEndpoint.build());
        }
        if (!parsedEndpoint && this.adapter.parseClientAddress(request, remoteEndpoint = Endpoint.newBuilder())) {
            span.remoteEndpoint(remoteEndpoint.build());
        }
        return span.start();
    }

    Span nextSpan(TraceContextOrSamplingFlags extracted, Req request) {
        if (extracted.sampled() == null) {
            extracted = extracted.sampled(this.sampler.trySample(this.adapter, request));
        }
        return extracted.context() != null ? this.tracer.joinSpan(extracted.context()) : this.tracer.nextSpan(extracted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSend(@Nullable Resp response, @Nullable Throwable error, Span span) {
        if (span.isNoop()) {
            return;
        }
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            this.parser.response(this.adapter, response, error, (SpanCustomizer)span);
        }
        finally {
            ws.close();
            span.finish();
        }
    }
}

