/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.http.HttpAdapter;
import brave.http.HttpSampler;
import brave.sampler.ParameterizedSampler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import zipkin.internal.Pair;

public final class HttpRuleSampler
extends HttpSampler {
    final ParameterizedSampler<Pair<String>> sampler;

    public static Builder newBuilder() {
        return new Builder();
    }

    HttpRuleSampler(List<MethodAndPathRule> rules) {
        this.sampler = ParameterizedSampler.create(rules);
    }

    @Override
    public <Req> Boolean trySample(HttpAdapter<Req, ?> adapter, Req request) {
        String method = adapter.method(request);
        String path = adapter.path(request);
        if (method == null || path == null) {
            return null;
        }
        return this.sampler.sample((Object)Pair.create((Object)method, (Object)path)).sampled();
    }

    static final class MethodAndPathRule
    extends ParameterizedSampler.Rule<Pair<String>> {
        @Nullable
        final String method;
        final String path;

        MethodAndPathRule(@Nullable String method, String path, float rate) {
            super(rate);
            this.method = method;
            this.path = path;
        }

        public boolean matches(Pair<String> parameters) {
            if (this.method != null && !this.method.equals(parameters._1)) {
                return false;
            }
            return ((String)parameters._2).startsWith(this.path);
        }
    }

    public static final class Builder {
        final List<MethodAndPathRule> rules = new ArrayList<MethodAndPathRule>();

        public Builder addRule(@Nullable String method, String path, float rate) {
            this.rules.add(new MethodAndPathRule(method, path, rate));
            return this;
        }

        public HttpSampler build() {
            return new HttpRuleSampler(this.rules);
        }

        Builder() {
        }
    }
}

