/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.http.HttpClientAdapter;
import brave.http.HttpRequest;
import brave.internal.Nullable;
import brave.propagation.Propagation;

public abstract class HttpClientRequest
extends HttpRequest {
    static final Propagation.Setter<HttpClientRequest, String> SETTER = new Propagation.Setter<HttpClientRequest, String>(){

        public void put(HttpClientRequest carrier, String key, String value) {
            carrier.header(key, value);
        }

        public String toString() {
            return "HttpClientRequest::header";
        }
    };

    @Nullable
    public abstract void header(String var1, String var2);

    @Deprecated
    static final class FromHttpAdapter<Req>
    extends HttpClientRequest {
        final HttpClientAdapter<Req, ?> adapter;
        final Req request;

        FromHttpAdapter(HttpClientAdapter<Req, ?> adapter, Req request) {
            if (adapter == null) {
                throw new NullPointerException("adapter == null");
            }
            this.adapter = adapter;
            if (request == null) {
                throw new NullPointerException("request == null");
            }
            this.request = request;
        }

        @Override
        public Object unwrap() {
            return this.request;
        }

        @Override
        public long startTimestamp() {
            return this.adapter.startTimestamp(this.request);
        }

        @Override
        public String method() {
            return this.adapter.method(this.request);
        }

        @Override
        public String path() {
            return this.adapter.path(this.request);
        }

        @Override
        public String url() {
            return this.adapter.url(this.request);
        }

        @Override
        public String header(String name) {
            return this.adapter.requestHeader(this.request, name);
        }

        @Override
        public void header(String name, String value) {
            throw new UnsupportedOperationException("immutable");
        }

        @Override
        public final String toString() {
            return this.request.toString();
        }
    }

    @Deprecated
    static final class ToHttpAdapter
    extends HttpClientAdapter<Object, Void> {
        final HttpClientRequest delegate;
        final Object unwrapped;

        ToHttpAdapter(HttpClientRequest delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate == null");
            }
            this.delegate = delegate;
            this.unwrapped = delegate.unwrap();
            if (this.unwrapped == null) {
                throw new NullPointerException("delegate.unwrap() == null");
            }
        }

        @Override
        public final long startTimestamp(Object request) {
            if (request == this.unwrapped) {
                return this.delegate.startTimestamp();
            }
            return 0L;
        }

        @Override
        public final String method(Object request) {
            if (request == this.unwrapped) {
                return this.delegate.method();
            }
            return null;
        }

        @Override
        public final String url(Object request) {
            if (request == this.unwrapped) {
                return this.delegate.url();
            }
            return null;
        }

        @Override
        public final String requestHeader(Object request, String name) {
            if (request == this.unwrapped) {
                return this.delegate.header(name);
            }
            return null;
        }

        @Override
        public final String path(Object request) {
            if (request == this.unwrapped) {
                return this.delegate.path();
            }
            return null;
        }

        @Override
        public final String methodFromResponse(Void response) {
            return null;
        }

        @Override
        public final String route(Void response) {
            return null;
        }

        @Override
        public final int statusCodeAsInt(Void response) {
            return 0;
        }

        @Override
        public final Integer statusCode(Void response) {
            return null;
        }

        @Override
        public final long finishTimestamp(Void response) {
            return 0L;
        }

        public final String toString() {
            return this.delegate.toString();
        }
    }
}

