/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.Span;
import brave.Tracer;
import brave.http.HttpAdapter;
import brave.http.HttpHandler;
import brave.http.HttpRequest;
import brave.http.HttpServerAdapter;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import brave.internal.Nullable;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.sampler.SamplerFunction;

public final class HttpServerHandler<Req, Resp>
extends HttpHandler {
    final Tracer tracer;
    final SamplerFunction<HttpRequest> sampler;
    @Nullable
    final HttpServerAdapter<Req, Resp> adapter;
    final TraceContext.Extractor<HttpServerRequest> defaultExtractor;

    public static HttpServerHandler<HttpServerRequest, HttpServerResponse> create(HttpTracing httpTracing) {
        if (httpTracing == null) {
            throw new NullPointerException("httpTracing == null");
        }
        return new HttpServerHandler<HttpServerRequest, HttpServerResponse>(httpTracing, null);
    }

    @Deprecated
    public static <Req, Resp> HttpServerHandler<Req, Resp> create(HttpTracing httpTracing, HttpServerAdapter<Req, Resp> adapter) {
        if (httpTracing == null) {
            throw new NullPointerException("httpTracing == null");
        }
        if (adapter == null) {
            throw new NullPointerException("adapter == null");
        }
        return new HttpServerHandler<Req, Resp>(httpTracing, adapter);
    }

    HttpServerHandler(HttpTracing httpTracing, HttpServerAdapter<Req, Resp> adapter) {
        super(httpTracing.tracing().currentTraceContext(), httpTracing.serverParser());
        this.adapter = adapter;
        this.tracer = httpTracing.tracing().tracer();
        this.sampler = httpTracing.serverRequestSampler();
        this.defaultExtractor = httpTracing.tracing().propagation().extractor(HttpServerRequest.GETTER);
    }

    public Span handleReceive(HttpServerRequest request) {
        Span span = this.nextSpan(this.defaultExtractor.extract((Object)request), request);
        return this.handleStart(new HttpServerRequest.ToHttpAdapter(request), request.unwrap(), span);
    }

    @Deprecated
    public Span handleReceive(TraceContext.Extractor<Req> extractor, Req request) {
        return this.handleReceive(extractor, request, request);
    }

    @Deprecated
    public <C> Span handleReceive(TraceContext.Extractor<C> extractor, C carrier, Req request) {
        HttpServerRequest.FromHttpAdapter<Req> serverRequest = request instanceof HttpServerRequest ? (HttpServerRequest.FromHttpAdapter<Req>)((Object)request) : new HttpServerRequest.FromHttpAdapter<Req>(this.adapter, request);
        Span span = this.nextSpan(extractor.extract(carrier), serverRequest);
        return this.handleStart(this.adapter, request, span);
    }

    <Req1> void parseRequest(HttpAdapter<Req1, ?> adapter, Req1 request, Span span) {
        span.kind(Span.Kind.SERVER);
        ((HttpServerAdapter)adapter).parseClientIpAndPort(request, span);
        this.parser.request(adapter, request, span.customizer());
    }

    Span nextSpan(TraceContextOrSamplingFlags extracted, HttpServerRequest request) {
        Boolean sampled = extracted.sampled();
        if (sampled == null && (sampled = this.sampler.trySample((Object)request)) != null) {
            extracted = extracted.sampled(sampled.booleanValue());
        }
        return extracted.context() != null ? this.tracer.joinSpan(extracted.context()) : this.tracer.nextSpan(extracted);
    }

    public void handleSend(@Nullable Resp response, @Nullable Throwable error, Span span) {
        if (response instanceof HttpServerResponse) {
            HttpServerResponse.Adapter adapter = new HttpServerResponse.Adapter((HttpServerResponse)response);
            this.handleFinish(adapter, adapter.unwrapped, error, span);
        } else {
            this.handleFinish(this.adapter, response, error, span);
        }
    }
}

