/*
 * Decompiled with CFR 0.152.
 */
package brave.jaxrs2;

import brave.Span;
import brave.Tracer;
import brave.http.HttpServerAdapter;
import brave.http.HttpServerHandler;
import brave.http.HttpTracing;
import brave.jaxrs2.ContainerAdapter;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import java.lang.annotation.Annotation;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(value=0)
@ConstrainedTo(value=RuntimeType.SERVER)
final class TracingContainerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    static final Propagation.Getter<ContainerRequestContext, String> GETTER = new Propagation.Getter<ContainerRequestContext, String>(){

        public String get(ContainerRequestContext carrier, String key) {
            return carrier.getHeaderString(key);
        }

        public String toString() {
            return "ContainerRequestContext::getHeaderString";
        }
    };
    final Tracer tracer;
    final HttpServerHandler<ContainerRequestContext, ContainerResponseContext> handler;
    final TraceContext.Extractor<ContainerRequestContext> extractor;
    @Context
    ResourceInfo resourceInfo;

    @Inject
    TracingContainerFilter(HttpTracing httpTracing) {
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing, (HttpServerAdapter)new ContainerAdapter());
        this.extractor = httpTracing.tracing().propagation().extractor(GETTER);
    }

    public void filter(ContainerRequestContext request) {
        if (this.resourceInfo != null) {
            request.setProperty(ResourceInfo.class.getName(), (Object)this.resourceInfo);
        }
        Span span = this.handler.handleReceive(this.extractor, (Object)request);
        request.removeProperty(ResourceInfo.class.getName());
        if (TracingContainerFilter.shouldPutSpanInScope(this.resourceInfo)) {
            request.setProperty(Tracer.SpanInScope.class.getName(), (Object)this.tracer.withSpanInScope(span));
        } else {
            request.setProperty(Span.class.getName(), (Object)span);
        }
    }

    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        Span span = (Span)request.getProperty(Span.class.getName());
        Tracer.SpanInScope spanInScope = (Tracer.SpanInScope)request.getProperty(Tracer.SpanInScope.class.getName());
        if (span == null) {
            if (spanInScope != null) {
                span = this.tracer.currentSpan();
                spanInScope.close();
            } else if (response.getStatus() == 404) {
                span = this.handler.handleReceive(this.extractor, (Object)request);
            } else {
                return;
            }
        }
        this.handler.handleSend((Object)response, null, span);
    }

    static boolean shouldPutSpanInScope(ResourceInfo resourceInfo) {
        if (resourceInfo == null) {
            return false;
        }
        Annotation[][] annotationArray = resourceInfo.getResourceMethod().getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotationArray[i]) {
                if (!annotation.annotationType().equals(Suspended.class)) continue;
                return false;
            }
        }
        return true;
    }
}

