/*
 * Decompiled with CFR 0.152.
 */
package brave.jakarta.jms;

import brave.jakarta.jms.JmsTracing;
import brave.jakarta.jms.TracingConnection;
import brave.jakarta.jms.TracingXASession;
import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.XAConnection;
import jakarta.jms.XAQueueConnection;
import jakarta.jms.XAQueueSession;
import jakarta.jms.XASession;
import jakarta.jms.XATopicConnection;
import jakarta.jms.XATopicSession;

final class TracingXAConnection
extends TracingConnection
implements XATopicConnection,
XAQueueConnection {
    static TracingXAConnection create(XAConnection delegate, JmsTracing jmsTracing) {
        if (delegate instanceof TracingXAConnection) {
            return (TracingXAConnection)delegate;
        }
        return new TracingXAConnection(delegate, jmsTracing);
    }

    TracingXAConnection(XAConnection delegate, JmsTracing jmsTracing) {
        super((Connection)delegate, jmsTracing);
    }

    public XASession createXASession() throws JMSException {
        return TracingXASession.create(((XAConnection)this.delegate).createXASession(), this.jmsTracing);
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        if ((this.types & 0x10) != 16) {
            throw new IllegalStateException(this.delegate + " is not an XAQueueConnection");
        }
        XAQueueSession xats = ((XAQueueConnection)this.delegate).createXAQueueSession();
        return TracingXASession.create((XASession)xats, this.jmsTracing);
    }

    public XATopicSession createXATopicSession() throws JMSException {
        if ((this.types & 0x20) != 32) {
            throw new IllegalStateException(this.delegate + " is not an XATopicConnection");
        }
        XATopicSession xats = ((XATopicConnection)this.delegate).createXATopicSession();
        return TracingXASession.create((XASession)xats, this.jmsTracing);
    }
}

