/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.internal.Nullable;
import brave.jms.MessageParser;
import brave.jms.MessagePropagation;
import brave.messaging.ConsumerRequest;
import brave.propagation.Propagation;
import javax.jms.Destination;
import javax.jms.Message;

final class MessageConsumerRequest
extends ConsumerRequest {
    static final Propagation.Getter<MessageConsumerRequest, String> GETTER = new Propagation.Getter<MessageConsumerRequest, String>(){

        public String get(MessageConsumerRequest request, String name) {
            return request.getProperty(name);
        }

        public String toString() {
            return "MessageConsumerRequest::getProperty";
        }
    };
    static final Propagation.Setter<MessageConsumerRequest, String> SETTER = new Propagation.Setter<MessageConsumerRequest, String>(){

        public void put(MessageConsumerRequest request, String name, String value) {
            request.setProperty(name, value);
        }

        public String toString() {
            return "MessageConsumerRequest::setProperty";
        }
    };
    final Message delegate;
    @Nullable
    final Destination destination;

    MessageConsumerRequest(Message delegate, @Nullable Destination destination) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
        this.destination = destination;
    }

    public Span.Kind spanKind() {
        return Span.Kind.CONSUMER;
    }

    public Object unwrap() {
        return this.delegate;
    }

    public String operation() {
        return "receive";
    }

    public String channelKind() {
        return MessageParser.channelKind(this.destination);
    }

    public String channelName() {
        return MessageParser.channelName(this.destination);
    }

    @Nullable
    String getProperty(String name) {
        return MessagePropagation.GETTER.get((Object)this.delegate, (Object)name);
    }

    void setProperty(String name, String value) {
        MessagePropagation.SETTER.put((Object)this.delegate, (Object)name, value);
    }
}

