/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.Tracer;
import brave.internal.Nullable;
import brave.internal.Throwables;
import brave.jms.JmsTracing;
import brave.jms.MessageParser;
import brave.jms.MessageProducerRequest;
import brave.jms.TracingCompletionListener;
import brave.jms.TracingProducer;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.Topic;
import javax.jms.TopicPublisher;

final class TracingMessageProducer
extends TracingProducer<MessageProducerRequest>
implements QueueSender,
TopicPublisher {
    final MessageProducer delegate;
    final int types;

    static TracingMessageProducer create(MessageProducer delegate, JmsTracing jmsTracing) {
        if (delegate instanceof TracingMessageProducer) {
            return (TracingMessageProducer)delegate;
        }
        return new TracingMessageProducer(delegate, jmsTracing);
    }

    TracingMessageProducer(MessageProducer delegate, JmsTracing jmsTracing) {
        super(jmsTracing.messageProducerExtractor, jmsTracing.messageProducerInjector, jmsTracing);
        this.delegate = delegate;
        int types = 0;
        if (delegate instanceof QueueSender) {
            types |= 2;
        }
        if (delegate instanceof TopicPublisher) {
            types |= 4;
        }
        this.types = types;
    }

    Span createAndStartProducerSpan(Message message, Destination destination) {
        return this.createAndStartProducerSpan(new MessageProducerRequest(message, destination));
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.delegate.setDisableMessageID(value);
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.delegate.getDisableMessageID();
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.delegate.setDisableMessageTimestamp(value);
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.delegate.getDisableMessageTimestamp();
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.delegate.setDeliveryMode(deliveryMode);
    }

    public int getDeliveryMode() throws JMSException {
        return this.delegate.getDeliveryMode();
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.delegate.setPriority(defaultPriority);
    }

    public int getPriority() throws JMSException {
        return this.delegate.getPriority();
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.delegate.setTimeToLive(timeToLive);
    }

    public long getTimeToLive() throws JMSException {
        return this.delegate.getTimeToLive();
    }

    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        this.delegate.setDeliveryDelay(deliveryDelay);
    }

    public long getDeliveryDelay() throws JMSException {
        return this.delegate.getDeliveryDelay();
    }

    public Destination getDestination() throws JMSException {
        return this.delegate.getDestination();
    }

    public void close() throws JMSException {
        this.delegate.close();
    }

    public void send(Message message) throws JMSException {
        Span span = this.createAndStartProducerSpan(message, this.destination(message));
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            this.delegate.send(message);
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            span.error(t);
            throw t;
        }
        finally {
            ws.close();
            span.finish();
        }
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        Span span = this.createAndStartProducerSpan(message, this.destination(message));
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            this.delegate.send(message, deliveryMode, priority, timeToLive);
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            span.error(t);
            throw t;
        }
        finally {
            ws.close();
            span.finish();
        }
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(SendDestination.DESTINATION, destination, message);
    }

    void send(SendDestination sendDestination, Destination destination, Message message) throws JMSException {
        Span span = this.createAndStartProducerSpan(message, destination);
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            sendDestination.apply(this.delegate, destination, message);
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            span.error(t);
            throw t;
        }
        finally {
            ws.close();
            span.finish();
        }
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        Span span = this.createAndStartProducerSpan(message, destination);
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            this.delegate.send(destination, message, deliveryMode, priority, timeToLive);
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            span.error(t);
            throw t;
        }
        finally {
            ws.close();
            span.finish();
        }
    }

    public void send(Message message, CompletionListener completionListener) throws JMSException {
        Span span = this.createAndStartProducerSpan(message, this.destination(message));
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            this.delegate.send(message, TracingCompletionListener.create(completionListener, span, this.current));
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            span.error(t);
            span.finish();
            throw t;
        }
        finally {
            ws.close();
        }
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        Span span = this.createAndStartProducerSpan(message, this.destination(message));
        completionListener = TracingCompletionListener.create(completionListener, span, this.current);
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            this.delegate.send(message, deliveryMode, priority, timeToLive, completionListener);
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            span.error(t);
            span.finish();
            throw t;
        }
        finally {
            ws.close();
        }
    }

    public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        Span span = this.createAndStartProducerSpan(message, destination);
        completionListener = TracingCompletionListener.create(completionListener, span, this.current);
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            this.delegate.send(destination, message, completionListener);
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            span.error(t);
            span.finish();
            throw t;
        }
        finally {
            ws.close();
        }
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        Span span = this.createAndStartProducerSpan(message, destination);
        completionListener = TracingCompletionListener.create(completionListener, span, this.current);
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            this.delegate.send(destination, message, deliveryMode, priority, timeToLive, completionListener);
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            span.error(t);
            span.finish();
            throw t;
        }
        finally {
            ws.close();
        }
    }

    public Queue getQueue() throws JMSException {
        this.checkQueueSender();
        return ((QueueSender)this.delegate).getQueue();
    }

    public void send(Queue queue, Message message) throws JMSException {
        this.checkQueueSender();
        this.send(SendDestination.QUEUE, (Destination)queue, message);
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkQueueSender();
        QueueSender qs = (QueueSender)this.delegate;
        Span span = this.createAndStartProducerSpan(message, this.destination(message));
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            qs.send(queue, message, deliveryMode, priority, timeToLive);
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            span.error(t);
            throw t;
        }
        finally {
            ws.close();
            span.finish();
        }
    }

    void checkQueueSender() {
        if ((this.types & 2) != 2) {
            throw new IllegalStateException(this.delegate + " is not a QueueSender");
        }
    }

    public Topic getTopic() throws JMSException {
        this.checkTopicPublisher();
        return ((TopicPublisher)this.delegate).getTopic();
    }

    public void publish(Message message) throws JMSException {
        this.checkTopicPublisher();
        TopicPublisher tp = (TopicPublisher)this.delegate;
        Span span = this.createAndStartProducerSpan(message, this.destination(message));
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            tp.publish(message);
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            span.error(t);
            throw t;
        }
        finally {
            ws.close();
            span.finish();
        }
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkTopicPublisher();
        TopicPublisher tp = (TopicPublisher)this.delegate;
        Span span = this.createAndStartProducerSpan(message, this.destination(message));
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            tp.publish(message, deliveryMode, priority, timeToLive);
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            span.error(t);
            throw t;
        }
        finally {
            ws.close();
            span.finish();
        }
    }

    public void publish(Topic topic, Message message) throws JMSException {
        this.checkTopicPublisher();
        this.send(SendDestination.TOPIC, (Destination)topic, message);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkTopicPublisher();
        TopicPublisher tp = (TopicPublisher)this.delegate;
        Span span = this.createAndStartProducerSpan(message, this.destination(message));
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            tp.publish(topic, message, deliveryMode, priority, timeToLive);
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            span.error(t);
            throw t;
        }
        finally {
            ws.close();
            span.finish();
        }
    }

    @Nullable
    Destination destination(Message message) {
        Destination result = MessageParser.destination(message);
        if (result != null) {
            return result;
        }
        try {
            return this.delegate.getDestination();
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            JmsTracing.log(t, "error getting destination of producer {0}", this.delegate, null);
            return null;
        }
    }

    void checkTopicPublisher() {
        if ((this.types & 4) != 4) {
            throw new IllegalStateException(this.delegate + " is not a TopicPublisher");
        }
    }

    static enum SendDestination {
        DESTINATION{

            @Override
            void apply(MessageProducer producer, Destination destination, Message message) throws JMSException {
                producer.send(destination, message);
            }
        }
        ,
        QUEUE{

            @Override
            void apply(MessageProducer producer, Destination destination, Message message) throws JMSException {
                ((QueueSender)producer).send((Queue)destination, message);
            }
        }
        ,
        TOPIC{

            @Override
            void apply(MessageProducer producer, Destination destination, Message message) throws JMSException {
                ((TopicPublisher)producer).publish((Topic)destination, message);
            }
        };


        abstract void apply(MessageProducer var1, Destination var2, Message var3) throws JMSException;
    }
}

