/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.internal.Nullable;
import brave.internal.Throwables;
import brave.jms.JmsTracing;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;

final class MessageParser {
    MessageParser() {
    }

    @Nullable
    static Destination destination(Message message) {
        try {
            return message.getJMSDestination();
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            JmsTracing.log(t, "error getting destination of message {0}", message, null);
            return null;
        }
    }

    @Nullable
    static String channelKind(@Nullable Destination destination) {
        if (destination instanceof Queue) {
            return "queue";
        }
        if (destination instanceof Topic) {
            return "topic";
        }
        return null;
    }

    @Nullable
    static String channelName(@Nullable Destination destination) {
        try {
            if (destination instanceof Queue) {
                return ((Queue)destination).getQueueName();
            }
            if (destination instanceof Topic) {
                return ((Topic)destination).getTopicName();
            }
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            JmsTracing.log(t, "error getting destination name from {0}", destination, null);
        }
        return null;
    }
}

