/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.internal.Throwables;
import brave.jms.JmsTracing;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.jms.Message;

final class PropertyFilter {
    static final ThreadLocal<List<Object>> MESSAGE_PROPERTIES_BUFFER = new ThreadLocal();

    PropertyFilter() {
    }

    static void filterProperties(Message message, Set<String> namesToClear) {
        List<Object> retainedProperties = PropertyFilter.messagePropertiesBuffer();
        try {
            PropertyFilter.filterProperties(message, namesToClear, retainedProperties);
        }
        finally {
            retainedProperties.clear();
        }
    }

    static void filterProperties(Message message, Set<String> namesToClear, List<Object> out) {
        Enumeration names;
        try {
            names = message.getPropertyNames();
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            JmsTracing.log(t, "error getting property names from {0}", message, null);
            return;
        }
        while (names.hasMoreElements()) {
            Object value;
            String name = (String)names.nextElement();
            try {
                value = message.getObjectProperty(name);
            }
            catch (Throwable t) {
                Throwables.propagateIfFatal((Throwable)t);
                JmsTracing.log(t, "error getting property {0} from message {1}", name, message);
                return;
            }
            if (namesToClear.contains(name) || value == null) continue;
            out.add(name);
            out.add(value);
        }
        try {
            message.clearProperties();
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            JmsTracing.log(t, "error clearing properties of {0}", message, null);
            return;
        }
        int length = out.size();
        for (int i = 0; i < length; i += 2) {
            String name = out.get(i).toString();
            try {
                message.setObjectProperty(name, out.get(i + 1));
                continue;
            }
            catch (Throwable t) {
                Throwables.propagateIfFatal((Throwable)t);
                JmsTracing.log(t, "error setting property {0} on message {1}", name, message);
            }
        }
    }

    static List<Object> messagePropertiesBuffer() {
        List<Object> messagePropertiesBuffer = MESSAGE_PROPERTIES_BUFFER.get();
        if (messagePropertiesBuffer == null) {
            messagePropertiesBuffer = new ArrayList<Object>();
            MESSAGE_PROPERTIES_BUFFER.set(messagePropertiesBuffer);
        }
        return messagePropertiesBuffer;
    }
}

