/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.streams;

import brave.Span;
import brave.Tracer;
import brave.kafka.streams.KafkaStreamsTracing;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.processor.ProcessorContext;

abstract class TracingFilter<K, V, R> {
    final KafkaStreamsTracing kafkaStreamsTracing;
    final String spanName;
    final Predicate<K, V> delegatePredicate;
    final Tracer tracer;
    final boolean filterNot;
    ProcessorContext processorContext;

    TracingFilter(KafkaStreamsTracing kafkaStreamsTracing, String spanName, Predicate<K, V> delegatePredicate, boolean filterNot) {
        this.kafkaStreamsTracing = kafkaStreamsTracing;
        this.tracer = kafkaStreamsTracing.tracer;
        this.spanName = spanName;
        this.delegatePredicate = delegatePredicate;
        this.filterNot = filterNot;
    }

    public void init(ProcessorContext context) {
        this.processorContext = context;
    }

    public R transform(K key, V value) {
        Span span = this.kafkaStreamsTracing.nextSpan(this.processorContext);
        if (!span.isNoop()) {
            span.name(this.spanName);
            span.start();
        }
        try {
            R r;
            block16: {
                Tracer.SpanInScope ws;
                block14: {
                    R r2;
                    block15: {
                        ws = this.tracer.withSpanInScope(span);
                        try {
                            if (!(this.filterNot ^ this.delegatePredicate.test(key, value))) break block14;
                            span.tag("kafka.streams.filtered", "false");
                            r2 = this.result(key, value);
                            if (ws == null) break block15;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (ws != null) {
                                    try {
                                        ws.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Error | RuntimeException e) {
                                span.error(e);
                                throw e;
                            }
                        }
                        ws.close();
                    }
                    return r2;
                }
                span.tag("kafka.streams.filtered", "true");
                r = null;
                if (ws == null) break block16;
                ws.close();
            }
            return r;
        }
        finally {
            this.kafkaStreamsTracing.injector.inject(span.context(), (Object)this.processorContext.headers());
            span.finish();
        }
    }

    abstract R result(K var1, V var2);
}

