/*
 * Decompiled with CFR 0.152.
 */
package brave.okhttp3;

import brave.Span;
import brave.Tracing;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpTracing;
import brave.internal.Nullable;
import brave.okhttp3.TracingCallFactory;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import okhttp3.Connection;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class TracingInterceptor
implements Interceptor {
    final CurrentTraceContext currentTraceContext;
    final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;

    public static Interceptor create(Tracing tracing) {
        return TracingInterceptor.create(HttpTracing.create((Tracing)tracing));
    }

    public static Interceptor create(HttpTracing httpTracing) {
        return new TracingInterceptor(httpTracing);
    }

    TracingInterceptor(HttpTracing httpTracing) {
        if (httpTracing == null) {
            throw new NullPointerException("HttpTracing == null");
        }
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing);
    }

    /*
     * Loose catch block
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        CurrentTraceContext.Scope scope;
        Throwable error;
        Response response2;
        Span span;
        RequestWrapper request;
        block12: {
            block11: {
                request = new RequestWrapper(chain.request());
                TraceContext parent = (TraceContext)chain.request().tag(TraceContext.class);
                span = parent != null ? this.handler.handleSendWithParent((HttpClientRequest)request, (TraceContext)(parent != TracingCallFactory.NULL_SENTINEL ? parent : null)) : this.handler.handleSend((HttpClientRequest)request);
                TracingInterceptor.parseRouteAddress(chain, span);
                response2 = null;
                error = null;
                scope = this.currentTraceContext.newScope(span.context());
                response = response2 = chain.proceed(request.build());
                if (scope == null) break block11;
                scope.close();
            }
            if (response2 == null) break block12;
            request = new RequestWrapper(response2.request());
        }
        this.handler.handleReceive((HttpClientResponse)new ResponseWrapper(request, response2, error), span);
        return response;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        error = t;
                        throw t;
                    }
                }
                catch (Throwable throwable3) {
                    if (response2 != null) {
                        request = new RequestWrapper(response2.request());
                    }
                    this.handler.handleReceive((HttpClientResponse)new ResponseWrapper(request, response2, error), span);
                    throw throwable3;
                }
            }
        }
    }

    static void parseRouteAddress(Interceptor.Chain chain, Span span) {
        if (span.isNoop()) {
            return;
        }
        Connection connection = chain.connection();
        if (connection == null) {
            return;
        }
        InetSocketAddress socketAddress = connection.route().socketAddress();
        span.remoteIpAndPort(socketAddress.getHostString(), socketAddress.getPort());
    }

    static final class ResponseWrapper
    extends HttpClientResponse {
        final RequestWrapper request;
        @Nullable
        final Response response;
        @Nullable
        final Throwable error;

        ResponseWrapper(RequestWrapper request, @Nullable Response response, @Nullable Throwable error) {
            this.request = request;
            this.response = response;
            this.error = error;
        }

        public Object unwrap() {
            return this.response;
        }

        public RequestWrapper request() {
            return this.request;
        }

        public Throwable error() {
            return this.error;
        }

        public int statusCode() {
            return this.response != null ? this.response.code() : 0;
        }
    }

    static final class RequestWrapper
    extends HttpClientRequest {
        final Request delegate;
        Request.Builder builder;

        RequestWrapper(Request delegate) {
            this.delegate = delegate;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.method();
        }

        public String path() {
            return this.delegate.url().encodedPath();
        }

        public String url() {
            return this.delegate.url().toString();
        }

        public String header(String name) {
            return this.delegate.header(name);
        }

        public void header(String name, String value) {
            if (this.builder == null) {
                this.builder = this.delegate.newBuilder();
            }
            this.builder.header(name, value);
        }

        Request build() {
            return this.builder != null ? this.builder.build() : this.delegate;
        }
    }
}

