/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.web;

import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jvnet.animal_sniffer.IgnoreJRERequirement;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SuccessCallback;

final class TraceContextListenableFuture<T>
implements ListenableFuture<T> {
    final ListenableFuture<T> delegate;
    final CurrentTraceContext currentTraceContext;
    final TraceContext invocationContext;

    TraceContextListenableFuture(ListenableFuture<T> delegate, CurrentTraceContext currentTraceContext, TraceContext invocationContext) {
        this.delegate = delegate;
        this.currentTraceContext = currentTraceContext;
        this.invocationContext = invocationContext;
    }

    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.delegate.addCallback((ListenableFutureCallback)(callback != null ? new TraceContextListenableFutureCallback<T>(callback, this) : null));
    }

    public void addCallback(SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
        this.delegate.addCallback(successCallback != null ? new TraceContextSuccessCallback<T>(successCallback, this) : null, (FailureCallback)(failureCallback != null ? new TraceContextFailureCallback(failureCallback, this) : null));
    }

    @IgnoreJRERequirement
    public CompletableFuture<T> completable() {
        return this.delegate.completable();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public boolean isDone() {
        return this.delegate.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        return (T)this.delegate.get();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
        return (T)this.delegate.get();
    }

    static final class TraceContextFailureCallback
    implements FailureCallback {
        final FailureCallback delegate;
        final CurrentTraceContext currentTraceContext;
        final TraceContext invocationContext;

        TraceContextFailureCallback(FailureCallback delegate, TraceContextListenableFuture<?> future) {
            this.delegate = delegate;
            this.currentTraceContext = future.currentTraceContext;
            this.invocationContext = future.invocationContext;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onFailure(Throwable ex) {
            CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.invocationContext);
            try {
                this.delegate.onFailure(ex);
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    static final class TraceContextSuccessCallback<T>
    implements SuccessCallback<T> {
        final SuccessCallback<T> delegate;
        final CurrentTraceContext currentTraceContext;
        final TraceContext invocationContext;

        TraceContextSuccessCallback(SuccessCallback<T> delegate, TraceContextListenableFuture<?> future) {
            this.delegate = delegate;
            this.currentTraceContext = future.currentTraceContext;
            this.invocationContext = future.invocationContext;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onSuccess(T result) {
            CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.invocationContext);
            try {
                this.delegate.onSuccess(result);
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    static final class TraceContextListenableFutureCallback<T>
    implements ListenableFutureCallback<T> {
        final ListenableFutureCallback<T> delegate;
        final CurrentTraceContext currentTraceContext;
        final TraceContext invocationContext;

        TraceContextListenableFutureCallback(ListenableFutureCallback<T> delegate, TraceContextListenableFuture<?> future) {
            this.delegate = delegate;
            this.currentTraceContext = future.currentTraceContext;
            this.invocationContext = future.invocationContext;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onSuccess(T result) {
            CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.invocationContext);
            try {
                this.delegate.onSuccess(result);
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onFailure(Throwable ex) {
            CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.invocationContext);
            try {
                this.delegate.onFailure(ex);
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

