/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.beans;

import brave.Tracing;
import brave.rpc.RpcRequest;
import brave.rpc.RpcTracing;
import brave.rpc.RpcTracingCustomizer;
import brave.sampler.SamplerFunction;
import java.util.List;
import org.springframework.beans.factory.FactoryBean;

public class RpcTracingFactoryBean
implements FactoryBean {
    Tracing tracing;
    SamplerFunction<RpcRequest> clientSampler;
    SamplerFunction<RpcRequest> serverSampler;
    List<RpcTracingCustomizer> customizers;

    public RpcTracing getObject() {
        RpcTracing.Builder builder = RpcTracing.newBuilder((Tracing)this.tracing);
        if (this.clientSampler != null) {
            builder.clientSampler(this.clientSampler);
        }
        if (this.serverSampler != null) {
            builder.serverSampler(this.serverSampler);
        }
        if (this.customizers != null) {
            for (RpcTracingCustomizer customizer : this.customizers) {
                customizer.customize(builder);
            }
        }
        return builder.build();
    }

    public Class<? extends RpcTracing> getObjectType() {
        return RpcTracing.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setTracing(Tracing tracing) {
        this.tracing = tracing;
    }

    public void setClientSampler(SamplerFunction<RpcRequest> clientSampler) {
        this.clientSampler = clientSampler;
    }

    public void setServerSampler(SamplerFunction<RpcRequest> serverSampler) {
        this.serverSampler = serverSampler;
    }

    public void setCustomizers(List<RpcTracingCustomizer> customizers) {
        this.customizers = customizers;
    }
}

