/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation.tracecontext;

import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.tracecontext.TraceContextExtractor;
import brave.propagation.tracecontext.TraceContextInjector;
import brave.propagation.tracecontext.TraceparentFormat;
import brave.propagation.tracecontext.TracestateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class TraceContextPropagation
implements Propagation<String> {
    public static final String TRACEPARENT = "traceparent";
    public static final String TRACESTATE = "tracestate";
    public static final Propagation.Factory FACTORY = new Factory(TraceContextPropagation.newFactoryBuilder());
    static final Propagation<String> INSTANCE = FACTORY.get();
    final String tracestateKey;
    final List<String> keys = Collections.unmodifiableList(Arrays.asList("traceparent", "tracestate"));
    final TraceparentFormat traceparentFormat = TraceparentFormat.get();
    final TracestateFormat tracestateFormat = TracestateFormat.get();

    public static Propagation<String> get() {
        return INSTANCE;
    }

    public static FactoryBuilder newFactoryBuilder() {
        return new FactoryBuilder();
    }

    TraceContextPropagation(Factory factory) {
        this.tracestateKey = factory.tracestateKey;
    }

    public List<String> keys() {
        return this.keys;
    }

    public <R> TraceContext.Injector<R> injector(Propagation.Setter<R, String> setter) {
        if (setter == null) {
            throw new NullPointerException("setter == null");
        }
        return new TraceContextInjector<R>(this, setter);
    }

    public <R> TraceContext.Extractor<R> extractor(Propagation.Getter<R, String> getter) {
        if (getter == null) {
            throw new NullPointerException("getter == null");
        }
        return new TraceContextExtractor<R>(this, getter);
    }

    static boolean logOrThrow(String msg, boolean shouldThrow) {
        if (shouldThrow) {
            throw new IllegalArgumentException(msg);
        }
        Logger logger = LoggerHolder.logger();
        if (!logger.isLoggable(Level.FINE)) {
            return false;
        }
        logger.log(Level.FINE, msg);
        return false;
    }

    static boolean logOrThrow(String msg, String param1, boolean shouldThrow) {
        if (shouldThrow) {
            throw new IllegalArgumentException(msg.replace("{0}", param1));
        }
        Logger logger = LoggerHolder.logger();
        if (!logger.isLoggable(Level.FINE)) {
            return false;
        }
        LogRecord lr = new LogRecord(Level.FINE, msg);
        Object[] params = new Object[]{param1};
        lr.setParameters(params);
        logger.log(lr);
        return false;
    }

    static final class LoggerHolder {
        static final Logger LOG = Logger.getLogger(TraceContextPropagation.class.getName());

        LoggerHolder() {
        }

        static Logger logger() {
            return LOG;
        }
    }

    static final class Factory
    extends Propagation.Factory {
        final String tracestateKey;

        Factory(FactoryBuilder builder) {
            this.tracestateKey = builder.tracestateKey;
        }

        public Propagation<String> get() {
            return new TraceContextPropagation(this);
        }

        public boolean supportsJoin() {
            return true;
        }

        public boolean requires128BitTraceId() {
            return false;
        }

        public TraceContext decorate(TraceContext context) {
            return context;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Factory)) {
                return false;
            }
            Factory that = (Factory)((Object)o);
            return this.tracestateKey.equals(that.tracestateKey);
        }

        public int hashCode() {
            return this.tracestateKey.hashCode();
        }
    }

    public static final class FactoryBuilder {
        static final TracestateFormat THROWING_VALIDATOR = new TracestateFormat("b3", true);
        String tracestateKey = "b3";

        FactoryBuilder() {
        }

        public FactoryBuilder tracestateKey(String key) {
            if (key == null) {
                throw new NullPointerException("key == null");
            }
            THROWING_VALIDATOR.validateKey(key, 0, key.length());
            this.tracestateKey = key;
            return this;
        }

        public Propagation.Factory build() {
            Factory result = new Factory(this);
            if (result.equals(FACTORY)) {
                return FACTORY;
            }
            return result;
        }
    }
}

