/*
 * Decompiled with CFR 0.152.
 */
package zipkin.reporter;

import zipkin.Codec;
import zipkin.Span;
import zipkin.reporter.Encoding;

public interface Encoder<S> {
    public static final Encoder<Span> JSON = new Encoder<Span>(){

        @Override
        public Encoding encoding() {
            return Encoding.JSON;
        }

        @Override
        public byte[] encode(Span span) {
            return Codec.JSON.writeSpan(span);
        }
    };
    public static final Encoder<Span> THRIFT = new Encoder<Span>(){

        @Override
        public Encoding encoding() {
            return Encoding.THRIFT;
        }

        @Override
        public byte[] encode(Span span) {
            return Codec.THRIFT.writeSpan(span);
        }
    };

    public Encoding encoding();

    public byte[] encode(S var1);
}

