/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.support;

import io.zonky.test.db.AutoConfigureEmbeddedDatabase;
import io.zonky.test.db.support.DatabaseDefinition;
import io.zonky.test.db.support.ProviderDescriptor;
import io.zonky.test.db.support.ProviderResolver;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class DefaultProviderResolver
implements ProviderResolver {
    private static final Logger logger = LoggerFactory.getLogger(DefaultProviderResolver.class);
    private final Environment environment;
    private final ClassLoader classLoader;

    public DefaultProviderResolver(Environment environment, ClassLoader classLoader) {
        this.environment = environment;
        this.classLoader = classLoader;
    }

    @Override
    public ProviderDescriptor getDescriptor(DatabaseDefinition definition) {
        String providerName = this.getProviderName(definition.getProviderType());
        String databaseName = this.getDatabaseName(definition.getDatabaseType());
        ProviderDescriptor descriptor = ProviderDescriptor.of(providerName, databaseName);
        if (StringUtils.hasText((String)definition.getBeanName())) {
            logger.debug("Descriptor {} for '{}' DataSource has been resolved", (Object)descriptor, (Object)definition.getBeanName());
        } else {
            logger.debug("Descriptor {} for default DataSource has been resolved", (Object)descriptor);
        }
        return descriptor;
    }

    protected String getProviderName(AutoConfigureEmbeddedDatabase.DatabaseProvider providerType) {
        if (providerType != AutoConfigureEmbeddedDatabase.DatabaseProvider.DEFAULT) {
            return providerType.name();
        }
        String providerName = this.environment.getProperty("zonky.test.database.provider");
        if (providerName != null && !providerName.equalsIgnoreCase(AutoConfigureEmbeddedDatabase.DatabaseProvider.DEFAULT.name())) {
            return providerName;
        }
        return AutoConfigureEmbeddedDatabase.DatabaseProvider.DOCKER.name();
    }

    protected String getDatabaseName(AutoConfigureEmbeddedDatabase.DatabaseType databaseType) {
        if (databaseType != AutoConfigureEmbeddedDatabase.DatabaseType.AUTO) {
            return databaseType.name();
        }
        String databaseName = this.environment.getProperty("zonky.test.database.type");
        if (databaseName != null && !databaseName.equalsIgnoreCase(AutoConfigureEmbeddedDatabase.DatabaseType.AUTO.name())) {
            return databaseName;
        }
        LinkedHashSet<AutoConfigureEmbeddedDatabase.DatabaseType> detectedTypes = new LinkedHashSet<AutoConfigureEmbeddedDatabase.DatabaseType>();
        if (ClassUtils.isPresent((String)"org.postgresql.ds.PGSimpleDataSource", (ClassLoader)this.classLoader)) {
            detectedTypes.add(AutoConfigureEmbeddedDatabase.DatabaseType.POSTGRES);
        }
        if (ClassUtils.isPresent((String)"com.microsoft.sqlserver.jdbc.SQLServerDataSource", (ClassLoader)this.classLoader)) {
            detectedTypes.add(AutoConfigureEmbeddedDatabase.DatabaseType.MSSQL);
        }
        if (ClassUtils.isPresent((String)"com.mysql.cj.jdbc.MysqlDataSource", (ClassLoader)this.classLoader)) {
            detectedTypes.add(AutoConfigureEmbeddedDatabase.DatabaseType.MYSQL);
        }
        if (ClassUtils.isPresent((String)"org.mariadb.jdbc.MariaDbDataSource", (ClassLoader)this.classLoader)) {
            detectedTypes.add(AutoConfigureEmbeddedDatabase.DatabaseType.MARIADB);
        }
        if (detectedTypes.isEmpty()) {
            throw new IllegalStateException("Database auto-detection failed, no database driver detected. Please add a corresponding Maven or Gradle dependency to your project.");
        }
        if (detectedTypes.size() > 1) {
            throw new IllegalStateException("Database auto-detection failed, multiple database drivers detected: " + detectedTypes + ". You have to specify the database type manually via @AutoConfigureEmbeddedDatabase or using configuration properties.");
        }
        return ((AutoConfigureEmbeddedDatabase.DatabaseType)((Object)detectedTypes.iterator().next())).name();
    }
}

