/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.config;

import io.zonky.test.db.config.ConditionalOnClass;
import io.zonky.test.db.config.ConditionalOnMissingBean;
import io.zonky.test.db.config.DatabaseProviderFactory;
import io.zonky.test.db.config.MissingProviderDependencyException;
import io.zonky.test.db.config.Provider;
import io.zonky.test.db.flyway.FlywayDatabaseExtension;
import io.zonky.test.db.flyway.FlywayPropertiesPostProcessor;
import io.zonky.test.db.liquibase.LiquibaseDatabaseExtension;
import io.zonky.test.db.liquibase.LiquibasePropertiesPostProcessor;
import io.zonky.test.db.provider.DatabaseProvider;
import io.zonky.test.db.provider.derby.DerbyDatabaseProvider;
import io.zonky.test.db.provider.h2.H2DatabaseProvider;
import io.zonky.test.db.provider.hsqldb.HSQLDatabaseProvider;
import io.zonky.test.db.provider.mariadb.DockerMariaDBDatabaseProvider;
import io.zonky.test.db.provider.mssql.DockerMSSQLDatabaseProvider;
import io.zonky.test.db.provider.mysql.DockerMySQLDatabaseProvider;
import io.zonky.test.db.provider.postgres.DockerPostgresDatabaseProvider;
import io.zonky.test.db.provider.postgres.OpenTablePostgresDatabaseProvider;
import io.zonky.test.db.provider.postgres.YandexPostgresDatabaseProvider;
import io.zonky.test.db.provider.postgres.ZonkyPostgresDatabaseProvider;
import io.zonky.test.db.support.DatabaseProviders;
import io.zonky.test.db.support.DefaultProviderResolver;
import io.zonky.test.db.support.ProviderResolver;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;

@Configuration
public class EmbeddedDatabaseAutoConfiguration
implements BeanClassLoaderAware {
    private ClassLoader classLoader;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Bean
    @Provider(type="docker", database="postgres")
    @ConditionalOnMissingBean(name={"dockerPostgresDatabaseProvider"})
    public DatabaseProvider dockerPostgresDatabaseProvider(DatabaseProviderFactory postgresDatabaseProviderFactory) {
        this.checkDependency("org.testcontainers", "postgresql", "org.testcontainers.containers.PostgreSQLContainer");
        this.checkDependency("org.postgresql", "postgresql", "org.postgresql.ds.PGSimpleDataSource");
        return postgresDatabaseProviderFactory.createProvider(DockerPostgresDatabaseProvider.class);
    }

    @Bean
    @Provider(type="zonky", database="postgres")
    @ConditionalOnMissingBean(name={"zonkyPostgresDatabaseProvider"})
    public DatabaseProvider zonkyPostgresDatabaseProvider(DatabaseProviderFactory postgresDatabaseProviderFactory) {
        this.checkDependency("io.zonky.test", "embedded-postgres", "io.zonky.test.db.postgres.embedded.EmbeddedPostgres");
        this.checkDependency("org.postgresql", "postgresql", "org.postgresql.ds.PGSimpleDataSource");
        return postgresDatabaseProviderFactory.createProvider(ZonkyPostgresDatabaseProvider.class);
    }

    @Bean
    @Provider(type="opentable", database="postgres")
    @ConditionalOnMissingBean(name={"openTablePostgresDatabaseProvider"})
    public DatabaseProvider openTablePostgresDatabaseProvider(DatabaseProviderFactory postgresDatabaseProviderFactory) {
        this.checkDependency("com.opentable.components", "otj-pg-embedded", "com.opentable.db.postgres.embedded.EmbeddedPostgres");
        this.checkDependency("org.postgresql", "postgresql", "org.postgresql.ds.PGSimpleDataSource");
        return postgresDatabaseProviderFactory.createProvider(OpenTablePostgresDatabaseProvider.class);
    }

    @Bean
    @Provider(type="yandex", database="postgres")
    @ConditionalOnMissingBean(name={"yandexPostgresDatabaseProvider"})
    public DatabaseProvider yandexPostgresDatabaseProvider(DatabaseProviderFactory postgresDatabaseProviderFactory) {
        this.checkDependency("ru.yandex.qatools.embed", "postgresql-embedded", "ru.yandex.qatools.embed.postgresql.EmbeddedPostgres");
        this.checkDependency("org.postgresql", "postgresql", "org.postgresql.ds.PGSimpleDataSource");
        return postgresDatabaseProviderFactory.createProvider(YandexPostgresDatabaseProvider.class);
    }

    @Bean
    @Provider(type="docker", database="mssql")
    @ConditionalOnMissingBean(name={"dockerMsSqlDatabaseProvider"})
    public DatabaseProvider dockerMsSqlDatabaseProvider(DatabaseProviderFactory msSqlDatabaseProviderFactory) {
        this.checkDependency("org.testcontainers", "mssqlserver", "org.testcontainers.containers.MSSQLServerContainer");
        this.checkDependency("com.microsoft.sqlserver", "mssql-jdbc", "com.microsoft.sqlserver.jdbc.SQLServerDataSource");
        return msSqlDatabaseProviderFactory.createProvider(DockerMSSQLDatabaseProvider.class);
    }

    @Bean
    @Provider(type="docker", database="mysql")
    @ConditionalOnMissingBean(name={"dockerMySqlDatabaseProvider"})
    public DatabaseProvider dockerMySqlDatabaseProvider(DatabaseProviderFactory mySqlDatabaseProviderFactory) {
        this.checkDependency("org.testcontainers", "mysql", "org.testcontainers.containers.MySQLContainer");
        this.checkDependency("mysql", "mysql-connector-java", "com.mysql.cj.jdbc.MysqlDataSource");
        return mySqlDatabaseProviderFactory.createProvider(DockerMySQLDatabaseProvider.class);
    }

    @Bean
    @Provider(type="docker", database="mariadb")
    @ConditionalOnMissingBean(name={"dockerMariaDbDatabaseProvider"})
    public DatabaseProvider dockerMariaDbDatabaseProvider(DatabaseProviderFactory mariaDbDatabaseProviderFactory) {
        this.checkDependency("org.testcontainers", "mariadb", "org.testcontainers.containers.MariaDBContainer");
        this.checkDependency("org.mariadb.jdbc", "mariadb-java-client", "org.mariadb.jdbc.MariaDbDataSource");
        return mariaDbDatabaseProviderFactory.createProvider(DockerMariaDBDatabaseProvider.class);
    }

    @Bean
    @Provider(type="embedded", database="h2")
    @ConditionalOnMissingBean(name={"h2DatabaseProvider"})
    public DatabaseProvider h2DatabaseProvider(DatabaseProviderFactory h2DatabaseProviderFactory) {
        this.checkDependency("com.h2database", "h2", "org.h2.Driver");
        return h2DatabaseProviderFactory.createProvider(H2DatabaseProvider.class);
    }

    @Bean
    @Provider(type="embedded", database="hsql")
    @ConditionalOnMissingBean(name={"hsqlDatabaseProvider"})
    public DatabaseProvider hsqlDatabaseProvider(DatabaseProviderFactory hsqlDatabaseProviderFactory) {
        this.checkDependency("org.hsqldb", "hsqldb", "org.hsqldb.jdbcDriver");
        return hsqlDatabaseProviderFactory.createProvider(HSQLDatabaseProvider.class);
    }

    @Bean
    @Provider(type="embedded", database="derby")
    @ConditionalOnMissingBean(name={"derbyDatabaseProvider"})
    public DatabaseProvider derbyDatabaseProvider(DatabaseProviderFactory derbyDatabaseProviderFactory) {
        if (!ClassUtils.isPresent((String)"org.apache.derby.info.engine.DerbyModule", (ClassLoader)this.classLoader)) {
            this.checkDependency("org.apache.derby", "derby", "org.apache.derby.jdbc.EmbeddedDriver");
        } else {
            this.checkDependency("org.apache.derby", "derbytools", "org.apache.derby.jdbc.EmbeddedDriver");
        }
        return derbyDatabaseProviderFactory.createProvider(DerbyDatabaseProvider.class);
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean(name={"postgresDatabaseProviderFactory"})
    public DatabaseProviderFactory postgresDatabaseProviderFactory(DatabaseProviderFactory defaultDatabaseProviderFactory) {
        return defaultDatabaseProviderFactory.customizeProvider((builder, provider) -> builder.optimizingProvider(builder.prefetchingProvider(builder.templatingProvider((DatabaseProvider)provider))));
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean(name={"msSqlDatabaseProviderFactory"})
    public DatabaseProviderFactory msSqlDatabaseProviderFactory(DatabaseProviderFactory defaultDatabaseProviderFactory) {
        return defaultDatabaseProviderFactory.customizeProvider((builder, provider) -> builder.optimizingProvider(builder.prefetchingProvider(builder.templatingProvider((DatabaseProvider)provider))));
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean(name={"mySqlDatabaseProviderFactory"})
    public DatabaseProviderFactory mySqlDatabaseProviderFactory(DatabaseProviderFactory defaultDatabaseProviderFactory) {
        return defaultDatabaseProviderFactory.customizeProvider((builder, provider) -> builder.optimizingProvider((DatabaseProvider)provider));
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean(name={"mariaDbDatabaseProviderFactory"})
    public DatabaseProviderFactory mariaDbDatabaseProviderFactory(DatabaseProviderFactory defaultDatabaseProviderFactory) {
        return defaultDatabaseProviderFactory.customizeProvider((builder, provider) -> builder.optimizingProvider((DatabaseProvider)provider));
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean(name={"h2DatabaseProviderFactory"})
    public DatabaseProviderFactory h2DatabaseProviderFactory(DatabaseProviderFactory defaultDatabaseProviderFactory) {
        return defaultDatabaseProviderFactory.customizeProvider((builder, provider) -> builder.optimizingProvider(builder.prefetchingProvider((DatabaseProvider)provider)));
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean(name={"hsqlDatabaseProviderFactory"})
    public DatabaseProviderFactory hsqlDatabaseProviderFactory(DatabaseProviderFactory defaultDatabaseProviderFactory) {
        return defaultDatabaseProviderFactory.customizeProvider((builder, provider) -> builder.optimizingProvider(builder.prefetchingProvider((DatabaseProvider)provider)));
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean(name={"derbyDatabaseProviderFactory"})
    public DatabaseProviderFactory derbyDatabaseProviderFactory(DatabaseProviderFactory defaultDatabaseProviderFactory) {
        return defaultDatabaseProviderFactory.customizeProvider((builder, provider) -> builder.optimizingProvider(builder.prefetchingProvider((DatabaseProvider)provider)));
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean(name={"defaultDatabaseProviderFactory"})
    public DatabaseProviderFactory defaultDatabaseProviderFactory(AutowireCapableBeanFactory beanFactory, Environment environment) {
        String threadNamePrefix = environment.getProperty("zonky.test.database.prefetching.thread-name-prefix", "prefetching-");
        int concurrency = (Integer)environment.getProperty("zonky.test.database.prefetching.concurrency", Integer.TYPE, (Object)3);
        int pipelineCacheSize = (Integer)environment.getProperty("zonky.test.database.prefetching.pipeline-cache-size", Integer.TYPE, (Object)5);
        int maxPreparedTemplates = (Integer)environment.getProperty("zonky.test.database.prefetching.max-prepared-templates", Integer.TYPE, (Object)10);
        int maxPreparedDatabases = maxPreparedTemplates * 2 / 3 * 2 + pipelineCacheSize;
        return new DatabaseProviderFactory(beanFactory).customizeTemplating(builder -> builder.withMaxTemplateCount(maxPreparedTemplates)).customizePrefetching(builder -> builder.withThreadNamePrefix(threadNamePrefix).withConcurrency(concurrency).withPipelineMaxCacheSize(pipelineCacheSize).withMaxPreparedDatabases(maxPreparedDatabases));
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean(name={"databaseProviders"})
    public DatabaseProviders databaseProviders(ConfigurableListableBeanFactory beanFactory) {
        return new DatabaseProviders(beanFactory);
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean(name={"providerResolver"})
    public ProviderResolver providerResolver(Environment environment) {
        return new DefaultProviderResolver(environment, this.classLoader);
    }

    @Bean
    @Role(value=2)
    @ConditionalOnClass(name={"org.flywaydb.core.Flyway"})
    @ConditionalOnMissingBean(name={"flywayDatabaseExtension"})
    public FlywayDatabaseExtension flywayDatabaseExtension() {
        return new FlywayDatabaseExtension();
    }

    @Bean
    @Role(value=2)
    @ConditionalOnClass(name={"org.springframework.boot.autoconfigure.flyway.FlywayProperties"})
    @ConditionalOnMissingBean(name={"flywayPropertiesPostProcessor"})
    public FlywayPropertiesPostProcessor flywayPropertiesPostProcessor() {
        return new FlywayPropertiesPostProcessor();
    }

    @Bean
    @Role(value=2)
    @ConditionalOnClass(name={"liquibase.integration.spring.SpringLiquibase"})
    @ConditionalOnMissingBean(name={"liquibaseDatabaseExtension"})
    public LiquibaseDatabaseExtension liquibaseDatabaseExtension() {
        return new LiquibaseDatabaseExtension();
    }

    @Bean
    @Role(value=2)
    @ConditionalOnClass(name={"org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties"})
    @ConditionalOnMissingBean(name={"liquibasePropertiesPostProcessor"})
    public LiquibasePropertiesPostProcessor liquibasePropertiesPostProcessor() {
        return new LiquibasePropertiesPostProcessor();
    }

    private void checkDependency(String groupId, String artifactId, String className) {
        if (!ClassUtils.isPresent((String)className, (ClassLoader)this.classLoader)) {
            String dependencyName = String.format("%s:%s", groupId, artifactId);
            String dependencyUrl = String.format("https://mvnrepository.com/artifact/%s/%s", groupId, artifactId);
            String errorMessage = String.format("You have to add the following dependency to your project: '%s' (%s)", dependencyName, dependencyUrl);
            throw new MissingProviderDependencyException(errorMessage);
        }
    }
}

