/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.common;

import io.zonky.test.db.preparer.CompositeDatabasePreparer;
import io.zonky.test.db.preparer.DatabasePreparer;
import io.zonky.test.db.provider.DatabaseProvider;
import io.zonky.test.db.provider.DatabaseRequest;
import io.zonky.test.db.provider.DatabaseTemplate;
import io.zonky.test.db.provider.EmbeddedDatabase;
import io.zonky.test.db.provider.ProviderException;
import io.zonky.test.db.provider.TemplatableDatabaseProvider;
import io.zonky.test.db.shaded.com.google.common.base.Stopwatch;
import io.zonky.test.db.shaded.com.google.common.base.Throwables;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableList;
import io.zonky.test.db.shaded.com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public class TemplatingDatabaseProvider
implements DatabaseProvider {
    public static final CompositeDatabasePreparer EMPTY_PREPARER = new CompositeDatabasePreparer(Collections.emptyList());
    private static final ConcurrentMap<TemplateKey, TemplateWrapper> templates = new ConcurrentHashMap<TemplateKey, TemplateWrapper>();
    private static final ConcurrentMap<TemplateKey, PreparerStats> stats = new ConcurrentHashMap<TemplateKey, PreparerStats>();
    private final TemplatableDatabaseProvider provider;
    private final Config config;

    public TemplatingDatabaseProvider(TemplatableDatabaseProvider provider) {
        this(provider, Config.builder().build());
    }

    public TemplatingDatabaseProvider(TemplatableDatabaseProvider provider, Config config) {
        this.provider = provider;
        this.config = config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplatingDatabaseProvider that = (TemplatingDatabaseProvider)o;
        return Objects.equals(this.provider, that.provider) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.provider, this.config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EmbeddedDatabase createDatabase(DatabasePreparer preparer) throws ProviderException {
        CompositeDatabasePreparer compositePreparer = preparer instanceof CompositeDatabasePreparer ? (CompositeDatabasePreparer)preparer : new CompositeDatabasePreparer(ImmutableList.of(preparer));
        List<DatabasePreparer> preparers = compositePreparer.getPreparers();
        PreparerStats preparerStats = stats.computeIfAbsent(new TemplateKey(this.provider, compositePreparer), key -> new PreparerStats());
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            for (int i = preparers.size(); i > 0; --i) {
                CompositeDatabasePreparer templatePreparer = new CompositeDatabasePreparer(preparers.subList(0, i));
                TemplateWrapper existingTemplate = (TemplateWrapper)templates.get(new TemplateKey(this.provider, templatePreparer));
                if (existingTemplate == null) continue;
                CompositeDatabasePreparer complementaryPreparer = new CompositeDatabasePreparer(preparers.subList(i, preparers.size()));
                if (i == preparers.size()) {
                    EmbeddedDatabase embeddedDatabase = this.createDatabase(complementaryPreparer, existingTemplate, false);
                    return embeddedDatabase;
                }
                EmbeddedDatabase embeddedDatabase = this.createDatabase(complementaryPreparer, existingTemplate, true);
                return embeddedDatabase;
            }
            EmbeddedDatabase embeddedDatabase = this.createDatabase(compositePreparer, null, true);
            return embeddedDatabase;
        }
        finally {
            preparerStats.onLoad(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    private EmbeddedDatabase createDatabase(CompositeDatabasePreparer preparer, TemplateWrapper template, boolean createNewTemplate) {
        TemplateWrapper newTemplate;
        if (createNewTemplate && (newTemplate = this.createTemplateIfPossible(preparer, template)) != null) {
            return newTemplate.createDatabase(EMPTY_PREPARER);
        }
        if (template != null) {
            return template.createDatabase(preparer);
        }
        return this.provider.createDatabase(DatabaseRequest.of(TemplatingDatabaseProvider.mergedPreparer(preparer, template)));
    }

    private DatabaseTemplate createTemplate(CompositeDatabasePreparer preparer, TemplateWrapper template) {
        if (template != null) {
            return template.createTemplate(preparer);
        }
        return this.provider.createTemplate(DatabaseRequest.of(preparer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TemplateWrapper createTemplateIfPossible(CompositeDatabasePreparer preparer, TemplateWrapper template) {
        TemplateWrapper newTemplate;
        CompositeDatabasePreparer templatePreparer = TemplatingDatabaseProvider.mergedPreparer(preparer, template);
        TemplateKey templateKey = new TemplateKey(this.provider, templatePreparer);
        PreparerStats preparerStats = (PreparerStats)stats.get(templateKey);
        if (preparerStats.getTotalLoadTime() < this.config.getDurationThreshold()) {
            return null;
        }
        TemplateWrapper oldTemplate = null;
        ConcurrentMap<TemplateKey, TemplateWrapper> concurrentMap = templates;
        synchronized (concurrentMap) {
            TemplateWrapper existingTemplate = (TemplateWrapper)templates.get(templateKey);
            if (existingTemplate != null) {
                return existingTemplate;
            }
            if (this.templateCount() >= (long)this.config.getMaxTemplateCount()) {
                TemplateKey templateToRemove = this.findTemplateToRemove();
                if (templateToRemove == null) {
                    return null;
                }
                PreparerStats templateToRemoveStats = (PreparerStats)stats.get(templateToRemove);
                if (preparerStats.getTotalLoadTime() < templateToRemoveStats.getTotalLoadTime() + this.config.getDurationThreshold()) {
                    return null;
                }
                oldTemplate = (TemplateWrapper)templates.remove(templateToRemove);
            }
            newTemplate = new TemplateWrapper(this.provider, templatePreparer);
            templates.put(templateKey, newTemplate);
        }
        if (oldTemplate != null) {
            oldTemplate.close();
        }
        newTemplate.loadTemplate(() -> this.createTemplate(preparer, template));
        return newTemplate;
    }

    private long templateCount() {
        return templates.keySet().stream().filter(key -> ((TemplateKey)key).provider.equals(this.provider)).count();
    }

    private TemplateKey findTemplateToRemove() {
        return templates.entrySet().stream().filter(entry -> ((TemplateWrapper)entry.getValue()).isLoaded()).map(Map.Entry::getKey).filter(key -> ((TemplateKey)key).provider.equals(this.provider)).min(Comparator.comparing(key -> ((PreparerStats)stats.get(key)).getTotalLoadTime())).orElse(null);
    }

    private static CompositeDatabasePreparer mergedPreparer(CompositeDatabasePreparer preparer, TemplateWrapper template) {
        if (template == null) {
            return preparer;
        }
        CompositeDatabasePreparer templatePreparer = template.getPreparer();
        Iterable<DatabasePreparer> combinedPreparers = Iterables.concat(templatePreparer.getPreparers(), preparer.getPreparers());
        return new CompositeDatabasePreparer(ImmutableList.copyOf(combinedPreparers));
    }

    public static class Config {
        private final long durationThreshold;
        private final int maxTemplateCount;

        private Config(Builder builder) {
            this.durationThreshold = builder.durationThreshold;
            this.maxTemplateCount = builder.maxTemplateCount;
        }

        public long getDurationThreshold() {
            return this.durationThreshold;
        }

        public int getMaxTemplateCount() {
            return this.maxTemplateCount;
        }

        public static Builder builder() {
            return new Builder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Config config = (Config)o;
            return this.durationThreshold == config.durationThreshold && this.maxTemplateCount == config.maxTemplateCount;
        }

        public int hashCode() {
            return Objects.hash(this.durationThreshold, this.maxTemplateCount);
        }

        public static class Builder {
            private long durationThreshold = 0L;
            private int maxTemplateCount = 10;

            private Builder() {
            }

            public Builder withDurationThreshold(long durationThreshold) {
                this.durationThreshold = durationThreshold;
                return this;
            }

            public Builder withMaxTemplateCount(int maxTemplateCount) {
                this.maxTemplateCount = maxTemplateCount;
                return this;
            }

            public Config build() {
                return new Config(this);
            }
        }
    }

    private static class PreparerStats {
        private final AtomicLong totalLoadTime = new AtomicLong(0L);
        private final AtomicInteger loadCount = new AtomicInteger(0);

        private PreparerStats() {
        }

        public long getTotalLoadTime() {
            return this.totalLoadTime.get();
        }

        public int getLoadCount() {
            return this.loadCount.get();
        }

        public long getAvgLoadTime() {
            return this.getTotalLoadTime() / (long)this.getLoadCount();
        }

        public void onLoad(long loadTime) {
            this.loadCount.incrementAndGet();
            this.totalLoadTime.addAndGet(loadTime);
        }
    }

    private static class TemplateWrapper {
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private final CompletableFuture<DatabaseTemplate> future = new CompletableFuture();
        private final TemplatableDatabaseProvider provider;
        private final CompositeDatabasePreparer preparer;
        private boolean closed = false;

        private TemplateWrapper(TemplatableDatabaseProvider provider, CompositeDatabasePreparer preparer) {
            this.provider = provider;
            this.preparer = preparer;
        }

        public CompositeDatabasePreparer getPreparer() {
            return this.preparer;
        }

        public boolean isLoaded() {
            return this.future.isDone();
        }

        public EmbeddedDatabase createDatabase(CompositeDatabasePreparer preparer) {
            this.lock.readLock().lock();
            try {
                if (!this.closed) {
                    EmbeddedDatabase embeddedDatabase = this.provider.createDatabase(DatabaseRequest.of(preparer, this.getTemplate()));
                    return embeddedDatabase;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            CompositeDatabasePreparer mergedPreparer = TemplatingDatabaseProvider.mergedPreparer(preparer, this);
            return this.provider.createDatabase(DatabaseRequest.of(mergedPreparer));
        }

        public DatabaseTemplate createTemplate(CompositeDatabasePreparer preparer) {
            this.lock.readLock().lock();
            try {
                if (!this.closed) {
                    DatabaseTemplate databaseTemplate = this.provider.createTemplate(DatabaseRequest.of(preparer, this.getTemplate()));
                    return databaseTemplate;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            CompositeDatabasePreparer mergedPreparer = TemplatingDatabaseProvider.mergedPreparer(preparer, this);
            return this.provider.createTemplate(DatabaseRequest.of(mergedPreparer));
        }

        public void close() {
            this.lock.writeLock().lock();
            try {
                this.closed = true;
                this.getTemplate().close();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private DatabaseTemplate getTemplate() {
            try {
                return this.future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Throwables.throwIfInstanceOf(e.getCause(), ProviderException.class);
                throw new ProviderException("Unexpected error when preparing a database template", e.getCause());
            }
        }

        private void loadTemplate(Supplier<DatabaseTemplate> templateProvider) {
            try {
                this.future.complete(templateProvider.get());
            }
            catch (Throwable e) {
                this.future.completeExceptionally(e);
                throw e;
            }
        }
    }

    protected static class TemplateKey {
        private final TemplatableDatabaseProvider provider;
        private final CompositeDatabasePreparer preparer;

        private TemplateKey(TemplatableDatabaseProvider provider, CompositeDatabasePreparer preparer) {
            this.provider = provider;
            this.preparer = preparer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplateKey that = (TemplateKey)o;
            return Objects.equals(this.provider, that.provider) && Objects.equals(this.preparer, that.preparer);
        }

        public int hashCode() {
            return Objects.hash(this.provider, this.preparer);
        }
    }
}

