/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.mssql;

import com.microsoft.sqlserver.jdbc.SQLServerDataSource;
import io.zonky.test.db.provider.support.AbstractEmbeddedDatabase;
import io.zonky.test.db.util.ReflectionUtils;
import javax.sql.DataSource;
import org.springframework.util.StringUtils;

public class MsSQLEmbeddedDatabase
extends AbstractEmbeddedDatabase {
    private final SQLServerDataSource dataSource;

    public MsSQLEmbeddedDatabase(SQLServerDataSource dataSource, Runnable closeCallback) {
        super(closeCallback);
        this.dataSource = dataSource;
    }

    @Override
    protected DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public String getJdbcUrl() {
        String url = String.format("jdbc:sqlserver://%s:%s;databaseName=%s;user=%s", this.dataSource.getServerName(), this.dataSource.getPortNumber(), this.dataSource.getDatabaseName(), this.dataSource.getUser());
        if (StringUtils.hasText((String)this.getPassword())) {
            url = url + String.format(";password=%s", this.getPassword());
        }
        return url;
    }

    private String getPassword() {
        return (String)ReflectionUtils.invokeMethod(this.dataSource, "getPassword", new Object[0]);
    }
}

