/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import redis.embedded.RedisExecProvider;
import redis.embedded.RedisServer;
import redis.embedded.exceptions.RedisBuildingException;

public class RedisServerBuilder {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String CONF_FILENAME = "embedded-redis-server";
    private File executable;
    private RedisExecProvider redisExecProvider = RedisExecProvider.defaultProvider();
    private String bind = "127.0.0.1";
    private int port = 6379;
    private InetSocketAddress slaveOf;
    private String redisConf;
    private StringBuilder redisConfigBuilder;

    public RedisServerBuilder redisExecProvider(RedisExecProvider redisExecProvider) {
        this.redisExecProvider = redisExecProvider;
        return this;
    }

    public RedisServerBuilder bind(String bind) {
        this.bind = bind;
        return this;
    }

    public RedisServerBuilder port(int port) {
        this.port = port;
        return this;
    }

    public RedisServerBuilder slaveOf(String hostname, int port) {
        this.slaveOf = new InetSocketAddress(hostname, port);
        return this;
    }

    public RedisServerBuilder slaveOf(InetSocketAddress slaveOf) {
        this.slaveOf = slaveOf;
        return this;
    }

    public RedisServerBuilder configFile(String redisConf) {
        if (this.redisConfigBuilder != null) {
            throw new RedisBuildingException("Redis configuration is already partially build using setting(String) method!");
        }
        this.redisConf = redisConf;
        return this;
    }

    public RedisServerBuilder setting(String configLine) {
        if (this.redisConf != null) {
            throw new RedisBuildingException("Redis configuration is already set using redis conf file!");
        }
        if (this.redisConfigBuilder == null) {
            this.redisConfigBuilder = new StringBuilder();
        }
        this.redisConfigBuilder.append(configLine);
        this.redisConfigBuilder.append(LINE_SEPARATOR);
        return this;
    }

    public RedisServer build() {
        this.setting("bind " + this.bind);
        this.tryResolveConfAndExec();
        List<String> args = this.buildCommandArgs();
        return new RedisServer(args, this.port);
    }

    public void reset() {
        this.executable = null;
        this.redisConfigBuilder = null;
        this.slaveOf = null;
        this.redisConf = null;
    }

    private void tryResolveConfAndExec() {
        try {
            this.resolveConfAndExec();
        }
        catch (IOException e) {
            throw new RedisBuildingException("Could not build server instance", e);
        }
    }

    private void resolveConfAndExec() throws IOException {
        if (this.redisConf == null && this.redisConfigBuilder != null) {
            File redisConfigFile = File.createTempFile(this.resolveConfigName(), ".conf");
            redisConfigFile.deleteOnExit();
            Files.write((CharSequence)this.redisConfigBuilder.toString(), (File)redisConfigFile, (Charset)Charset.forName("UTF-8"));
            this.redisConf = redisConfigFile.getAbsolutePath();
        }
        try {
            this.executable = this.redisExecProvider.get();
        }
        catch (Exception e) {
            throw new RedisBuildingException("Failed to resolve executable", e);
        }
    }

    private String resolveConfigName() {
        return "embedded-redis-server_" + this.port;
    }

    private List<String> buildCommandArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.executable.getAbsolutePath());
        if (!Strings.isNullOrEmpty((String)this.redisConf)) {
            args.add(this.redisConf);
        }
        args.add("--port");
        args.add(Integer.toString(this.port));
        if (this.slaveOf != null) {
            args.add("--slaveof");
            args.add(this.slaveOf.getHostName());
            args.add(Integer.toString(this.slaveOf.getPort()));
        }
        return args;
    }
}

