/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.stringparsers;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.PropertyStringParser;
import com.martiansoftware.jsap.stringparsers.BooleanStringParser;
import java.io.File;

public class FileStringParser
extends PropertyStringParser {
    public static final String MUSTBEFILE = "mustBeFile";
    public static final String MUSTBEDIRECTORY = "mustBeDirectory";
    public static final String MUSTEXIST = "mustExist";
    private boolean mustExist = false;
    private boolean mustBeDirectory = false;
    private boolean mustBeFile = false;

    public static FileStringParser getParser() {
        return new FileStringParser();
    }

    @Override
    public void setUp() throws ParseException {
        BooleanStringParser booleanStringParser = JSAP.BOOLEAN_PARSER;
        this.setMustExist((Boolean)booleanStringParser.parse(this.getProperty(MUSTEXIST, new Boolean(this.mustExist).toString())));
        this.setMustBeDirectory((Boolean)booleanStringParser.parse(this.getProperty(MUSTBEDIRECTORY, new Boolean(this.mustBeDirectory).toString())));
        this.setMustBeFile((Boolean)booleanStringParser.parse(this.getProperty(MUSTBEFILE, new Boolean(this.mustBeFile).toString())));
    }

    public FileStringParser setMustBeDirectory(boolean bl) {
        this.mustBeDirectory = bl;
        return this;
    }

    public FileStringParser setMustBeFile(boolean bl) {
        this.mustBeFile = bl;
        return this;
    }

    public FileStringParser setMustExist(boolean bl) {
        this.mustExist = bl;
        return this;
    }

    public boolean mustBeDirectory() {
        return this.mustBeDirectory;
    }

    public boolean mustBeFile() {
        return this.mustBeFile;
    }

    public boolean mustExist() {
        return this.mustExist;
    }

    @Override
    public void tearDown() {
    }

    @Override
    public Object parse(String string) throws ParseException {
        File file = null;
        try {
            file = new File(string);
            if (this.mustExist() && !file.exists()) {
                throw new ParseException(file + " does not exist.");
            }
            if (this.mustBeDirectory() && file.exists() && !file.isDirectory()) {
                throw new ParseException(file + " is not a directory.");
            }
            if (this.mustBeFile() && file.exists() && file.isDirectory()) {
                throw new ParseException(file + " is not a file.");
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new ParseException("No File given to parse", nullPointerException);
        }
        return file;
    }
}

