/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.bits;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.LongBigArrayBitVector;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.sux4j.bits.Rank9;
import it.unimi.dsi.sux4j.bits.Select;
import java.io.IOException;
import java.io.ObjectInputStream;

public class Select9
implements Select {
    private static final long serialVersionUID = 2L;
    private static final long ONES_STEP_16 = 0x1000100010001L;
    private static final long MSBS_STEP_16 = -9223231297218904064L;
    private static final long ONES_STEP_9 = 18049651735527937L;
    private static final long MSBS_STEP_9 = 4620710844295151872L;
    private static final int LOG2_ONES_PER_INVENTORY = 9;
    private static final int ONES_PER_INVENTORY = 512;
    private static final int INVENTORY_MASK = 511;
    private final long[] inventory;
    private final long[] subinventory;
    private final long numOnes;
    private final int numWords;
    private transient long[] bits;
    private final long[] count;
    private final Rank9 rank9;

    public Select9(Rank9 rank9) {
        this.rank9 = rank9;
        this.numOnes = rank9.numOnes;
        this.numWords = rank9.numWords;
        this.bits = rank9.bits;
        this.count = rank9.count;
        int inventorySize = (int)((this.numOnes + 512L - 1L) / 512L);
        this.inventory = new long[inventorySize + 1];
        this.subinventory = new long[this.numWords + 3 >> 2];
        int numWords = this.numWords;
        long[] bits = this.bits;
        long[] count = this.count;
        long[] inventory = this.inventory;
        long[] subinventory = this.subinventory;
        long d = 0L;
        for (int i = 0; i < numWords; ++i) {
            for (int j = 0; j < 64; ++j) {
                if ((bits[i] & 1L << j) == 0L) continue;
                if ((d & 0x1FFL) == 0L) {
                    inventory[(int)(d >> 9)] = LongArrayBitVector.bits((int)i) + (long)j;
                }
                ++d;
            }
        }
        inventory[inventorySize] = LongBigArrayBitVector.bits((long)((long)(numWords + 3) & 0xFFFFFFFFFFFFFFFCL));
        d = 0L;
        int state = 0;
        long firstBit = 0L;
        int subinventoryPosition = 0;
        LongArrayBitVector v = LongArrayBitVector.wrap((long[])subinventory);
        LongBigList subinventoryAsShorts = v.asLongBigList(16);
        LongBigList subinventoryasInts = v.asLongBigList(32);
        for (int i = 0; i < numWords; ++i) {
            for (int j = 0; j < 64; ++j) {
                if ((bits[i] & 1L << j) == 0L) continue;
                if ((d & 0x1FFL) == 0L) {
                    int k;
                    LongBigList s;
                    firstBit = LongArrayBitVector.bits((int)i) + (long)j;
                    int index = (int)(d >> 9);
                    assert (inventory[index] == firstBit);
                    subinventoryPosition = LongArrayBitVector.word((long)inventory[index]) >>> 2;
                    int span = (LongArrayBitVector.word((long)inventory[index + 1]) >>> 2) - (LongArrayBitVector.word((long)inventory[index]) >>> 2);
                    state = -1;
                    long countsAtStart = count[LongArrayBitVector.word((long)inventory[index]) >>> 3 << 1];
                    int blockSpan = (LongArrayBitVector.word((long)inventory[index + 1]) >>> 3) - (LongArrayBitVector.word((long)inventory[index]) >>> 3);
                    int blockLeft = LongArrayBitVector.word((long)inventory[index]) >>> 3;
                    if (span >= 512) {
                        state = 0;
                    } else if (span >= 256) {
                        state = 1;
                    } else if (span >= 128) {
                        state = 2;
                    } else if (span >= 16) {
                        assert (((long)(blockSpan + 8) & 0xFFFFFFFFFFFFFFF8L) + 8L <= (long)(span * 4));
                        s = subinventoryAsShorts.subList((long)(subinventoryPosition * 4), subinventoryAsShorts.size64());
                        for (k = 0; k < blockSpan; ++k) {
                            assert (s.getLong((long)(k + 8)) == 0L);
                            s.set((long)(k + 8), count[(blockLeft + k + 1) * 2] - countsAtStart);
                        }
                        while ((long)k < ((long)(blockSpan + 8) & 0xFFFFFFFFFFFFFFF8L)) {
                            assert (s.getLong((long)(k + 8)) == 0L);
                            s.set((long)(k + 8), 65535L);
                            ++k;
                        }
                        assert (blockSpan / 8 <= 8);
                        for (k = 0; k < blockSpan >>> 3; ++k) {
                            assert (s.getLong((long)k) == 0L);
                            s.set((long)k, count[(blockLeft + (k + 1) * 8) * 2] - countsAtStart);
                        }
                        while (k < 8) {
                            assert (s.getLong((long)k) == 0L);
                            s.set((long)k, 65535L);
                            ++k;
                        }
                    } else if (span >= 2) {
                        assert (((long)(blockSpan + 8) & 0xFFFFFFFFFFFFFFF8L) <= (long)(span * 4));
                        s = subinventoryAsShorts.subList((long)(subinventoryPosition * 4), subinventoryAsShorts.size64());
                        for (k = 0; k < blockSpan; ++k) {
                            assert (s.getLong((long)k) == 0L);
                            s.set((long)k, count[(blockLeft + k + 1) * 2] - countsAtStart);
                        }
                        while ((long)k < ((long)(blockSpan + 8) & 0xFFFFFFFFFFFFFFF8L)) {
                            assert (s.getLong((long)k) == 0L);
                            s.set((long)k, 65535L);
                            ++k;
                        }
                    }
                }
                switch (state) {
                    case 0: {
                        assert (subinventory[subinventoryPosition + (int)(d & 0x1FFL)] == 0L);
                        subinventory[subinventoryPosition + (int)(d & 0x1FFL)] = LongArrayBitVector.bits((int)i) + (long)j;
                        break;
                    }
                    case 1: {
                        assert (subinventoryasInts.getLong((long)(subinventoryPosition << 1) + (d & 0x1FFL)) == 0L);
                        assert (LongArrayBitVector.bits((int)i) + (long)j - firstBit < 0x100000000L);
                        subinventoryasInts.set((long)(subinventoryPosition << 1) + (d & 0x1FFL), LongArrayBitVector.bits((int)i) + (long)j - firstBit);
                        break;
                    }
                    case 2: {
                        assert (subinventoryAsShorts.getLong((long)(subinventoryPosition << 2) + (d & 0x1FFL)) == 0L);
                        assert (LongArrayBitVector.bits((int)i) + (long)j - firstBit < 65536L);
                        subinventoryAsShorts.set((long)(subinventoryPosition << 2) + (d & 0x1FFL), LongArrayBitVector.bits((int)i) + (long)j - firstBit);
                    }
                }
                ++d;
            }
        }
    }

    @Override
    public long select(long rank) {
        int rankInBlock;
        int countLeft;
        int inventoryIndexLeft = (int)(rank >> 9);
        long inventoryLeft = this.inventory[inventoryIndexLeft];
        int blockRight = LongArrayBitVector.word((long)this.inventory[inventoryIndexLeft + 1]);
        int blockLeft = LongArrayBitVector.word((long)inventoryLeft);
        int subinventoryIndex = blockLeft >>> 2;
        long span = (blockRight >>> 2) - (blockLeft >>> 2);
        long[] count = this.count;
        if (span < 2L) {
            countLeft = (blockLeft &= 0xFFFFFFF8) >> 2 & 0xFFFFFFFE;
            assert (rank >= count[countLeft]) : rank + " < " + count[countLeft];
            assert (rank < count[countLeft + 2]) : rank + " >= " + count[countLeft + 2];
            rankInBlock = (int)(rank - count[countLeft]);
        } else if (span < 16L) {
            countLeft = (blockLeft &= 0xFFFFFFF8) >> 2 & 0xFFFFFFFE;
            long rankInSuperblock = rank - count[countLeft];
            long rankInSuperblockStep16 = rankInSuperblock * 0x1000100010001L;
            long first = this.subinventory[subinventoryIndex];
            long second = this.subinventory[subinventoryIndex + 1];
            int where = (int)(((((((rankInSuperblockStep16 | 0x8000800080008000L) - (first & 0x7FFF7FFF7FFF7FFFL) | first ^ rankInSuperblockStep16) ^ first & (rankInSuperblockStep16 ^ 0xFFFFFFFFFFFFFFFFL)) & 0x8000800080008000L) >>> 15) + (((((rankInSuperblockStep16 | 0x8000800080008000L) - (second & 0x7FFF7FFF7FFF7FFFL) | second ^ rankInSuperblockStep16) ^ second & (rankInSuperblockStep16 ^ 0xFFFFFFFFFFFFFFFFL)) & 0x8000800080008000L) >>> 15)) * 0x1000100010001L >>> 47);
            assert (where >= 0);
            assert (where <= 16);
            blockLeft += where * 4;
            rankInBlock = (int)(rank - count[countLeft += where]);
            assert (rankInBlock >= 0);
            assert (rankInBlock < 512);
        } else if (span < 128L) {
            long[] subinventory = this.subinventory;
            countLeft = (blockLeft &= 0xFFFFFFF8) >> 2 & 0xFFFFFFFE;
            long rankInSuperblock = rank - count[countLeft];
            long rankInSuperblockStep16 = rankInSuperblock * 0x1000100010001L;
            long first = subinventory[subinventoryIndex];
            long second = subinventory[subinventoryIndex + 1];
            int where0 = (int)(((((((rankInSuperblockStep16 | 0x8000800080008000L) - (first & 0x7FFF7FFF7FFF7FFFL) | first ^ rankInSuperblockStep16) ^ first & (rankInSuperblockStep16 ^ 0xFFFFFFFFFFFFFFFFL)) & 0x8000800080008000L) >>> 15) + (((((rankInSuperblockStep16 | 0x8000800080008000L) - (second & 0x7FFF7FFF7FFF7FFFL) | second ^ rankInSuperblockStep16) ^ second & (rankInSuperblockStep16 ^ 0xFFFFFFFFFFFFFFFFL)) & 0x8000800080008000L) >>> 15)) * 0x1000100010001L >>> 47);
            assert (where0 <= 16);
            long first_bis = subinventory[subinventoryIndex + where0 + 2];
            long second_bis = subinventory[subinventoryIndex + where0 + 2 + 1];
            int where1 = (where0 << 3) + (int)(((((((rankInSuperblockStep16 | 0x8000800080008000L) - (first_bis & 0x7FFF7FFF7FFF7FFFL) | first_bis ^ rankInSuperblockStep16) ^ first_bis & (rankInSuperblockStep16 ^ 0xFFFFFFFFFFFFFFFFL)) & 0x8000800080008000L) >>> 15) + (((((rankInSuperblockStep16 | 0x8000800080008000L) - (second_bis & 0x7FFF7FFF7FFF7FFFL) | second_bis ^ rankInSuperblockStep16) ^ second_bis & (rankInSuperblockStep16 ^ 0xFFFFFFFFFFFFFFFFL)) & 0x8000800080008000L) >>> 15)) * 0x1000100010001L >>> 47);
            blockLeft += where1 << 2;
            rankInBlock = (int)(rank - count[countLeft += where1]);
            assert (rankInBlock >= 0);
            assert (rankInBlock < 512);
        } else {
            if (span < 256L) {
                int index16 = (subinventoryIndex << 2) + (int)(rank & 0x1FFL);
                return (this.subinventory[index16 >>> 2] >>> ((index16 & 3) << 4) & 0xFFFFL) + inventoryLeft;
            }
            if (span < 512L) {
                int index32 = (subinventoryIndex << 1) + (int)(rank & 0x1FFL);
                return (this.subinventory[index32 >>> 1] >>> ((index32 & 1) << 5) & 0xFFFFFFFFL) + inventoryLeft;
            }
            return this.subinventory[subinventoryIndex + (int)(rank & 0x1FFL)];
        }
        long rankInBlockStep9 = (long)rankInBlock * 18049651735527937L;
        long subcounts = count[countLeft + 1];
        int offsetInBlock = (int)((((((rankInBlockStep9 | 0x4020100804020100L) - (subcounts & 0xBFDFEFF7FBFDFEFFL) | subcounts ^ rankInBlockStep9) ^ subcounts & (rankInBlockStep9 ^ 0xFFFFFFFFFFFFFFFFL)) & 0x4020100804020100L) >>> 8) * 18049651735527937L >>> 54 & 7L);
        int word = blockLeft + offsetInBlock;
        int rankInWord = (int)((long)rankInBlock - (subcounts >>> (offsetInBlock - 1 & 7) * 9 & 0x1FFL));
        assert (offsetInBlock >= 0);
        assert (offsetInBlock <= 7);
        assert (rankInWord < 64);
        assert (rankInWord >= 0);
        return LongArrayBitVector.bits((int)word) + (long)Fast.select((long)this.bits[word], (int)rankInWord);
    }

    @Override
    public long numBits() {
        return this.rank9.numBits() + LongArrayBitVector.bits((int)this.inventory.length) + LongArrayBitVector.bits((int)this.subinventory.length);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.bits = this.rank9.bitVector.bits();
    }

    @Override
    public BitVector bitVector() {
        return this.rank9.bitVector();
    }
}

