/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.Util;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.BitVectors;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.LongBigArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongBigListIterator;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.AbstractObject2LongFunction;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.io.FileLinesByteArrayIterable;
import it.unimi.dsi.io.FileLinesMutableStringIterable;
import it.unimi.dsi.io.OfflineIterable;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.io.BucketedHashStore;
import it.unimi.dsi.sux4j.mph.Hashes;
import it.unimi.dsi.sux4j.mph.codec.Codec;
import it.unimi.dsi.sux4j.mph.solve.Linear3SystemSolver;
import it.unimi.dsi.util.XoRoShiRo128PlusRandom;
import it.unimi.dsi.util.concurrent.ReorderingBlockingQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import org.apache.commons.math3.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GV3CompressedFunction<T>
extends AbstractObject2LongFunction<T>
implements Serializable,
Size64 {
    private static final long serialVersionUID = 1L;
    private static final LongArrayBitVector END_OF_SOLUTION_QUEUE = LongArrayBitVector.getInstance();
    private static final Pair<BucketedHashStore.Bucket, Integer> END_OF_BUCKET_QUEUE = new Pair((Object)new BucketedHashStore.Bucket(), (Object)0);
    private static final Logger LOGGER = LoggerFactory.getLogger(GV3CompressedFunction.class);
    private static final boolean DEBUG = false;
    protected static final int SEED_BITS = 10;
    protected static final int OFFSET_BITS = 54;
    private static final long SEED_STEP = 0x40000000000000L;
    private static final long OFFSET_MASK = 0x3FFFFFFFFFFFFFL;
    private static final long SEED_MASK = -18014398509481984L;
    public static final String NUMBER_OF_THREADS_PROPERTY = "it.unimi.dsi.sux4j.mph.threads";
    public static final double DELTA_PEEL = 1.23;
    public static final double DELTA_GAUSSIAN = 1.1;
    public static final int BUCKET_SIZE = 1000;
    private final int deltaTimes256;
    private final long multiplier;
    protected final long n;
    protected final int globalMaxCodewordLength;
    protected long globalSeed;
    protected final long[] offsetAndSeed;
    protected final BitVector data;
    protected final TransformationStrategy<? super T> transform;
    protected final Codec.Decoder decoder;
    protected final int escapeLength;
    protected final int escapedSymbolLength;

    protected GV3CompressedFunction(Iterable<? extends T> keys, TransformationStrategy<? super T> transform, LongIterable values, boolean indirect, File tempDir, BucketedHashStore<T> bucketedHashStore, Codec codec, boolean peeled) throws IOException {
        Long2LongOpenHashMap frequencies;
        boolean givenBucketedHashStore;
        Objects.requireNonNull(codec, "Null codec");
        this.transform = transform;
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.displayLocalSpeed = true;
        pl.displayFreeMemory = true;
        XoRoShiRo128PlusRandom r = new XoRoShiRo128PlusRandom();
        pl.itemsName = "keys";
        boolean bl = givenBucketedHashStore = bucketedHashStore != null;
        if (!givenBucketedHashStore) {
            if (keys == null) {
                throw new IllegalArgumentException("If you do not provide a bucketed hash store, you must provide the keys");
            }
            bucketedHashStore = new BucketedHashStore<T>(transform, tempDir, -1, pl);
            bucketedHashStore.reset(r.nextLong());
            if (values == null || indirect) {
                bucketedHashStore.addAll(keys.iterator());
            } else {
                bucketedHashStore.addAll(keys.iterator(), values.iterator());
            }
        }
        this.n = bucketedHashStore.size();
        this.defRetValue = -1L;
        this.deltaTimes256 = (int)Math.floor((peeled ? 1.23 : 1.1) * 256.0);
        if (indirect) {
            frequencies = new Long2LongOpenHashMap();
            LongIterator longIterator = values.iterator();
            while (longIterator.hasNext()) {
                long v = (Long)longIterator.next();
                frequencies.addTo(v, 1L);
            }
        } else {
            frequencies = bucketedHashStore.value2FrequencyMap();
        }
        Codec.Coder coder = frequencies.isEmpty() ? Codec.ZeroCodec.getInstance().getCoder((Long2LongMap)frequencies) : codec.getCoder((Long2LongMap)frequencies);
        this.globalMaxCodewordLength = coder.maxCodewordLength();
        this.decoder = coder.getDecoder();
        this.escapedSymbolLength = this.decoder.escapedSymbolLength();
        this.escapeLength = this.decoder.escapeLength();
        bucketedHashStore.bucketSize(1000);
        if (this.n / 1000L + 1L > Integer.MAX_VALUE) {
            throw new IllegalStateException("This class supports at most -2001 keys");
        }
        int numBuckets = (int)(this.n / 1000L + 1L);
        this.multiplier = (long)numBuckets * 2L;
        LOGGER.debug("Number of buckets: " + numBuckets);
        this.offsetAndSeed = new long[numBuckets + 1];
        OfflineIterable offlineData = new OfflineIterable((OfflineIterable.Serializer)BitVectors.OFFLINE_SERIALIZER, (Object)LongArrayBitVector.getInstance());
        int duplicates = 0;
        while (true) {
            pl.expectedUpdates = numBuckets;
            pl.itemsName = "buckets";
            pl.start((CharSequence)"Analysing buckets... ");
            AtomicLong unsolvable = new AtomicLong();
            try {
                int numberOfThreads = Integer.parseInt(System.getProperty(NUMBER_OF_THREADS_PROPERTY, Integer.toString(Math.min(4, Runtime.getRuntime().availableProcessors()))));
                ArrayBlockingQueue bucketQueue = new ArrayBlockingQueue(numberOfThreads);
                ReorderingBlockingQueue queue = new ReorderingBlockingQueue(numberOfThreads * 128);
                ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads + 2);
                ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(executorService);
                executorCompletionService.submit(() -> {
                    LongArrayBitVector data;
                    while ((data = (LongArrayBitVector)queue.take()) != END_OF_SOLUTION_QUEUE) {
                        offlineData.add((Object)data);
                    }
                    return null;
                });
                BucketedHashStore<Object> chs = bucketedHashStore;
                executorCompletionService.submit(() -> {
                    try {
                        Iterator<BucketedHashStore.Bucket> iterator = chs.iterator();
                        int i1 = 0;
                        while (iterator.hasNext()) {
                            BucketedHashStore.Bucket bucket = new BucketedHashStore.Bucket(iterator.next());
                            assert ((long)i1 == bucket.index());
                            LongBigList valueList = bucket.valueList((LongIterable)(indirect ? values : null));
                            long sumOfLengths = 0L;
                            for (int i = 0; i < bucket.size(); sumOfLengths += (long)coder.codewordLength(valueList.getLong((long)i)), ++i) {
                            }
                            long numVariables = Math.max(3L, (sumOfLengths * (long)this.deltaTimes256 >>> 8) + (long)this.globalMaxCodewordLength);
                            assert (numVariables <= Integer.MAX_VALUE);
                            long[] lArray = this.offsetAndSeed;
                            // MONITORENTER : this.offsetAndSeed
                            this.offsetAndSeed[i1 + 1] = this.offsetAndSeed[i1] + numVariables;
                            assert (this.offsetAndSeed[i1 + 1] <= 0x40000000000000L);
                            // MONITOREXIT : lArray
                            bucketQueue.put(new Pair((Object)bucket, (Object)((int)sumOfLengths)));
                            ++i1;
                        }
                        return null;
                    }
                    finally {
                        int i2 = numberOfThreads;
                        while (true) {
                            if (i2-- == 0) {
                            }
                            bucketQueue.put(END_OF_BUCKET_QUEUE);
                        }
                    }
                });
                AtomicInteger activeThreads = new AtomicInteger(numberOfThreads);
                int i = numberOfThreads;
                while (i-- != 0) {
                    executorCompletionService.submit(() -> {
                        Thread.currentThread().setPriority(1);
                        long bucketTime = 0L;
                        long outputTime = 0L;
                        while (true) {
                            long[] solution;
                            LongArrayBitVector data;
                            BucketedHashStore.Bucket bucket;
                            long start;
                            block9: {
                                start = System.nanoTime();
                                Pair bucketLength = (Pair)bucketQueue.take();
                                bucketTime += System.nanoTime() - start;
                                if (bucketLength == END_OF_BUCKET_QUEUE) {
                                    if (activeThreads.decrementAndGet() == 0) {
                                        queue.put((Object)END_OF_SOLUTION_QUEUE, (long)numBuckets);
                                    }
                                    LOGGER.debug("Queue waiting time: " + Util.format((double)((double)bucketTime / 1.0E9)) + "s");
                                    LOGGER.debug("Output waiting time: " + Util.format((double)((double)outputTime / 1.0E9)) + "s");
                                    return null;
                                }
                                bucket = (BucketedHashStore.Bucket)bucketLength.getFirst();
                                int numEquations = (Integer)bucketLength.getSecond();
                                int numVariables = (int)(this.offsetAndSeed[(int)(bucket.index() + 1L)] - this.offsetAndSeed[(int)bucket.index()] & 0x3FFFFFFFFFFFFFL);
                                long seed = 0L;
                                Linear3SystemSolver solver = new Linear3SystemSolver(numVariables, numEquations);
                                do {
                                    boolean solved22 = solver.generateAndSolve(bucket, seed, bucket.valueList((LongIterable)(indirect ? values : null)), coder, numVariables - this.globalMaxCodewordLength, this.globalMaxCodewordLength, peeled);
                                    unsolvable.addAndGet(solver.unsolvable);
                                    if (!solved22) continue;
                                    long[] solved22 = this.offsetAndSeed;
                                    // MONITORENTER : this.offsetAndSeed
                                    int n = (int)bucket.index();
                                    this.offsetAndSeed[n] = this.offsetAndSeed[n] | seed;
                                    // MONITOREXIT : solved22
                                    data = LongArrayBitVector.getInstance();
                                    solution = solver.solution;
                                    data.length((long)solution.length);
                                    break block9;
                                } while ((seed += 0x40000000000000L) != 0L);
                                throw new AssertionError((Object)"Exhausted local seeds");
                            }
                            for (int j = 0; j < solution.length; ++j) {
                                data.set((long)j, (int)solution[j]);
                            }
                            start = System.nanoTime();
                            queue.put((Object)data, bucket.index());
                            outputTime += System.nanoTime() - start;
                            ProgressLogger progressLogger = pl;
                            // MONITORENTER : progressLogger
                            pl.update();
                            // MONITOREXIT : progressLogger
                        }
                    });
                }
                try {
                    i = numberOfThreads + 2;
                    while (i-- != 0) {
                        executorCompletionService.take().get();
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof BucketedHashStore.DuplicateException) {
                        throw (BucketedHashStore.DuplicateException)cause;
                    }
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new RuntimeException(cause);
                }
                finally {
                    executorService.shutdown();
                }
                LOGGER.info("Unsolvable systems: " + unsolvable.get() + "/" + (unsolvable.get() + (long)numBuckets) + " (" + Util.format((double)(100.0 * (double)unsolvable.get() / (double)(unsolvable.get() + (long)numBuckets))) + "%)");
                pl.done();
            }
            catch (BucketedHashStore.DuplicateException e) {
                if (keys == null) {
                    throw new IllegalStateException("You provided no keys, but the bucketed hash store was not checked");
                }
                if (duplicates++ > 3) {
                    throw new IllegalArgumentException("The input list contains duplicates");
                }
                LOGGER.warn("Found duplicate. Recomputing signatures...");
                bucketedHashStore.reset(r.nextLong());
                pl.itemsName = "keys";
                if (values == null || indirect) {
                    bucketedHashStore.addAll(keys.iterator());
                } else {
                    bucketedHashStore.addAll(keys.iterator(), values.iterator());
                }
                offlineData.clear();
                Arrays.fill(this.offsetAndSeed, 0L);
                continue;
            }
            break;
        }
        this.globalSeed = bucketedHashStore.seed();
        OfflineIterable.OfflineIterator iterator = offlineData.iterator();
        if ((this.offsetAndSeed[numBuckets] & 0x3FFFFFFFFFFFFFL) + 1L < LongArrayBitVector.bits((int)0x7FFFFFF7)) {
            LongArrayBitVector dataBitVector = LongArrayBitVector.getInstance((long)((this.offsetAndSeed[numBuckets] & 0x3FFFFFFFFFFFFFL) + 1L));
            this.data = dataBitVector;
            while (iterator.hasNext()) {
                dataBitVector.append((BitVector)iterator.next());
            }
        } else {
            LongBigArrayBitVector dataBitVector = LongBigArrayBitVector.getInstance((long)((this.offsetAndSeed[numBuckets] & 0x3FFFFFFFFFFFFFL) + 1L));
            this.data = dataBitVector;
            while (iterator.hasNext()) {
                dataBitVector.append((BitVector)iterator.next());
            }
        }
        iterator.close();
        offlineData.close();
        this.data.add(0);
        LOGGER.info("Completed.");
        LOGGER.info("Actual bit cost per element: " + (double)this.numBits() / (double)this.n);
        if (!givenBucketedHashStore) {
            bucketedHashStore.close();
        }
    }

    public long getLong(Object o) {
        int[] e = new int[3];
        long[] signature = new long[2];
        Hashes.spooky4(this.transform.toBitVector(o), this.globalSeed, signature);
        int bucket = (int)Math.multiplyHigh(signature[0] >>> 1, this.multiplier);
        long olc = this.offsetAndSeed[bucket];
        long bucketOffset = olc & 0x3FFFFFFFFFFFFFL;
        long nextBucketOffset = this.offsetAndSeed[bucket + 1] & 0x3FFFFFFFFFFFFFL;
        long bucketSeed = olc & 0xFFC0000000000000L;
        int w = this.globalMaxCodewordLength;
        int numVariables = (int)(nextBucketOffset - bucketOffset - (long)w);
        Linear3SystemSolver.signatureToEquation(signature, bucketSeed, numVariables, e);
        long e0 = (long)e[0] + bucketOffset;
        long e1 = (long)e[1] + bucketOffset;
        long e2 = (long)e[2] + bucketOffset;
        long t = this.decoder.decode(this.data.getLong(e0, e0 + (long)w) ^ this.data.getLong(e1, e1 + (long)w) ^ this.data.getLong(e2, e2 + (long)w));
        if (t != -1L) {
            return t;
        }
        int end = w - this.escapeLength;
        int start = end - this.escapedSymbolLength;
        return this.data.getLong(e0 + (long)start, e0 + (long)end) ^ this.data.getLong(e1 + (long)start, e1 + (long)end) ^ this.data.getLong(e2 + (long)start, e2 + (long)end);
    }

    public long size64() {
        return this.n;
    }

    @Deprecated
    public int size() {
        return (int)Math.min(this.n, Integer.MAX_VALUE);
    }

    public long numBits() {
        if (this.n == 0L) {
            return 0L;
        }
        return this.data.size64() + LongArrayBitVector.bits((int)this.offsetAndSeed.length) + this.decoder.numBits();
    }

    public boolean containsKey(Object o) {
        return true;
    }

    public void dump(String file) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(0x100000).order(ByteOrder.nativeOrder());
        FileOutputStream fos = new FileOutputStream(file);
        FileChannel channel = fos.getChannel();
        buffer.clear();
        buffer.putLong(this.size64());
        buffer.putLong(this.multiplier);
        buffer.putLong(this.globalMaxCodewordLength);
        buffer.putLong(this.globalSeed);
        buffer.putLong(this.offsetAndSeed.length);
        for (long l : this.offsetAndSeed) {
            if (!buffer.hasRemaining()) {
                buffer.flip();
                channel.write(buffer);
                buffer.clear();
            }
            buffer.putLong(l);
        }
        buffer.flip();
        channel.write(buffer);
        buffer.clear();
        LongBigList list = this.data.asLongBigList(64);
        buffer.putLong(LongArrayBitVector.words((long)this.data.length()));
        LongBigListIterator longBigListIterator = list.iterator();
        while (longBigListIterator.hasNext()) {
            long l = (Long)longBigListIterator.next();
            buffer.putLong(l);
            if (buffer.hasRemaining()) continue;
            buffer.flip();
            channel.write(buffer);
            buffer.clear();
        }
        if (!LongArrayBitVector.round((long)this.data.length())) {
            buffer.putLong(this.data.getLong(this.data.length() & 0xFFFFFFFFFFFFFFC0L, this.data.length()));
        }
        buffer.flip();
        channel.write(buffer);
        buffer.clear();
        ((Codec.Huffman.Coder.Decoder)this.decoder).dump(buffer);
        buffer.flip();
        channel.write(buffer);
        fos.close();
    }

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException {
        LongIterable values;
        SimpleJSAP jsap = new SimpleJSAP(GV3CompressedFunction.class.getName(), "Builds a GOV function mapping a newline-separated list of strings to their ordinal position, or to specific values.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new FlaggedOption("tempDir", (StringParser)FileStringParser.getParser(), JSAP.NO_DEFAULT, false, 'T', "temp-dir", "A directory for temporary files."), new Switch("iso", 'i', "iso", "Use ISO-8859-1 coding internally (i.e., just use the lower eight bits of each character)."), new Switch("peel", 'p', "peel", "Use peeling instead of lazy Gaussian elimination (+12% space, much faster construction)."), new Switch("utf32", '\u0000', "utf-32", "Use UTF-32 internally (handles surrogate pairs)."), new Switch("byteArray", 'b', "byte-array", "Create a function on byte arrays (no character encoding)."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new FlaggedOption("decompressor", (StringParser)JSAP.CLASS_PARSER, JSAP.NO_DEFAULT, false, 'd', "decompressor", "Use this extension of InputStream to decompress the strings (e.g., java.util.zip.GZIPInputStream)."), new FlaggedOption("codec", (StringParser)JSAP.STRING_PARSER, "HUFFMAN", false, 'C', "codec", "The name of the codec to use (UNARY, BINARY, GAMMA, HUFFMAN, LLHUFFMAN)."), new FlaggedOption("limit", (StringParser)JSAP.INTEGER_PARSER, "20", false, 'l', "limit", "Decoding-table length limit for the LLHUFFMAN codec."), new FlaggedOption("values", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'v', "values", "A binary file in DataInput format containing a long for each string (otherwise, the values will be the ordinal positions of the strings)."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised GOV function."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, "-", false, false, "The name of a file containing a newline-separated list of strings, or - for standard input; in the second case, strings must be fewer than 2^31 and will be loaded into core memory.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("function");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        File tempDir = jsapResult.getFile("tempDir");
        boolean byteArray = jsapResult.getBoolean("byteArray");
        boolean zipped = jsapResult.getBoolean("zipped");
        Class<GZIPInputStream> decompressor = jsapResult.getClass("decompressor");
        boolean peeled = jsapResult.getBoolean("peel");
        boolean iso = jsapResult.getBoolean("iso");
        boolean utf32 = jsapResult.getBoolean("utf32");
        int limit = jsapResult.getInt("limit");
        if (zipped && decompressor != null) {
            throw new IllegalArgumentException("The zipped and decompressor options are incompatible");
        }
        if (zipped) {
            decompressor = GZIPInputStream.class;
        }
        Codec codec = null;
        switch (jsapResult.getString("codec")) {
            case "UNARY": {
                codec = new Codec.Unary();
                break;
            }
            case "BINARY": {
                codec = new Codec.Binary();
                break;
            }
            case "GAMMA": {
                codec = new Codec.Gamma();
                break;
            }
            case "HUFFMAN": {
                codec = new Codec.Huffman();
                break;
            }
            case "LLHUFFMAN": {
                codec = new Codec.Huffman(limit);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown codec \"" + jsapResult.getString("codec") + "\"");
            }
        }
        LongIterable longIterable = values = jsapResult.userSpecified("values") ? BinIO.asLongIterable((CharSequence)jsapResult.getString("values")) : null;
        if (byteArray) {
            if ("-".equals(stringFile)) {
                throw new IllegalArgumentException("Cannot read from standard input when building byte-array functions");
            }
            if (iso || utf32 || jsapResult.userSpecified("encoding")) {
                throw new IllegalArgumentException("Encoding options are not available when building byte-array functions");
            }
            FileLinesByteArrayIterable keys = new FileLinesByteArrayIterable(stringFile, decompressor);
            BinIO.storeObject(new GV3CompressedFunction(keys, TransformationStrategies.rawByteArray(), values, false, tempDir, null, codec, peeled), (CharSequence)functionName);
        } else {
            ObjectArrayList keys;
            if ("-".equals(stringFile)) {
                ObjectArrayList list;
                keys = list = new ObjectArrayList();
                FileLinesMutableStringIterable.iterator((InputStream)System.in, (Charset)encoding, decompressor).forEachRemaining(s -> list.add((Object)s.toString()));
            } else {
                keys = new FileLinesMutableStringIterable(stringFile, encoding, decompressor);
            }
            TransformationStrategy transformationStrategy = iso ? TransformationStrategies.rawIso() : (utf32 ? TransformationStrategies.rawUtf32() : TransformationStrategies.rawUtf16());
            BinIO.storeObject(new GV3CompressedFunction(keys, transformationStrategy, values, false, tempDir, null, codec, peeled), (CharSequence)functionName);
        }
        LOGGER.info("Completed.");
    }

    public static class Builder<T> {
        protected Iterable<? extends T> keys;
        protected TransformationStrategy<? super T> transform;
        protected File tempDir;
        protected BucketedHashStore<T> bucketedHashStore;
        protected LongIterable values;
        protected boolean indirect;
        protected boolean built;
        protected Codec codec;
        protected boolean peeled;

        public Builder<T> keys(Iterable<? extends T> keys) {
            this.keys = keys;
            return this;
        }

        public Builder<T> transform(TransformationStrategy<? super T> transform) {
            this.transform = transform;
            return this;
        }

        public Builder<T> tempDir(File tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public Builder<T> store(BucketedHashStore<T> bucketedHashStore) {
            this.bucketedHashStore = bucketedHashStore;
            return this;
        }

        public Builder<T> values(LongIterable values) {
            this.values = values;
            return this;
        }

        public Builder<T> indirect() {
            this.indirect = true;
            return this;
        }

        public Builder<T> codec(Codec codec) {
            this.codec = codec;
            return this;
        }

        public Builder<T> peeled() {
            this.peeled = true;
            return this;
        }

        public GV3CompressedFunction<T> build() throws IOException {
            if (this.built) {
                throw new IllegalStateException("This builder has been already used");
            }
            if (this.codec == null) {
                this.codec = new Codec.Huffman();
            }
            this.built = true;
            if (this.transform == null) {
                if (this.bucketedHashStore != null) {
                    this.transform = this.bucketedHashStore.transform();
                } else {
                    throw new IllegalArgumentException("You must specify a TransformationStrategy, either explicitly or via a given BucketedHashStore");
                }
            }
            return new GV3CompressedFunction<T>(this.keys, this.transform, this.values, this.indirect, this.tempDir, this.bucketedHashStore, this.codec, this.peeled);
        }
    }
}

