/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.util;

import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.LongBigArrayBitVector;
import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.LongBigListIterator;
import it.unimi.dsi.fastutil.longs.LongMappedBigList;
import it.unimi.dsi.lang.FlyweightPrototype;
import it.unimi.dsi.sux4j.bits.SimpleBigSelect;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.util.NoSuchElementException;

public class MappedEliasFanoMonotoneLongBigList
extends AbstractLongBigList
implements Serializable,
Closeable,
FlyweightPrototype<MappedEliasFanoMonotoneLongBigList> {
    private static final long serialVersionUID = 5L;
    public static final String OBJECT_EXTENSION = ".object";
    public static final String LOWER_BITS_EXTENSION = ".lowerbits";
    protected final long length;
    protected final int l;
    protected long[][] upperBits;
    protected LongMappedBigList lowerBits;
    protected final SimpleBigSelect selectUpper;
    protected final long lowerBitsMask;
    private FileChannel fileChannel;
    private final boolean littleEndian;

    public static MappedEliasFanoMonotoneLongBigList load(String basename) throws IOException, ClassNotFoundException {
        return ((MappedEliasFanoMonotoneLongBigList)BinIO.loadObject((CharSequence)(basename + OBJECT_EXTENSION))).lowerBits(basename + LOWER_BITS_EXTENSION);
    }

    public MappedEliasFanoMonotoneLongBigList lowerBits(String lowerBits) throws IOException {
        this.fileChannel = FileChannel.open(new File(lowerBits).toPath(), new OpenOption[0]);
        this.lowerBits = LongMappedBigList.map((FileChannel)this.fileChannel, (ByteOrder)(this.littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN));
        return this;
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
    }

    protected MappedEliasFanoMonotoneLongBigList(long length, int l, long[][] upperBits, SimpleBigSelect selectUpper, boolean littleEndian) {
        this.length = length;
        this.l = l;
        this.upperBits = upperBits;
        this.selectUpper = selectUpper;
        this.littleEndian = littleEndian;
        this.lowerBitsMask = (1L << l) - 1L;
    }

    public long numBits() {
        return this.selectUpper.numBits() + this.selectUpper.bitVector().length() + this.lowerBits.size64() * 64L;
    }

    public long getLong(long index) {
        assert (index >= 0L);
        assert (index < this.length);
        int l = this.l;
        long upperBits = this.selectUpper.select(index) - index;
        long position = index * (long)l;
        long startWord = LongBigArrayBitVector.word((long)position);
        int startBit = LongArrayBitVector.bit((long)position);
        long result = this.lowerBits.getLong(startWord) >>> startBit;
        return upperBits << l | (startBit + l <= 64 ? result : result | this.lowerBits.getLong(startWord + 1L) << -startBit) & this.lowerBitsMask;
    }

    public long getDelta(long index) {
        assert (index >= 0L);
        assert (index < this.length - 1L);
        long[] dest = new long[2];
        this.selectUpper.select(index, dest, 0, 2);
        int l = this.l;
        LongMappedBigList lowerBits = this.lowerBits;
        long position = index * (long)l;
        long startWord = LongBigArrayBitVector.word((long)position);
        int startBit = LongArrayBitVector.bit((long)position);
        long first = lowerBits.getLong(startWord) >>> startBit;
        first = dest[0] - index++ << l | (startBit + l <= 64 ? first : first | lowerBits.getLong(startWord + 1L) << -startBit) & this.lowerBitsMask;
        startWord = LongBigArrayBitVector.word((long)(position += (long)l));
        startBit = LongArrayBitVector.bit((long)position);
        long second = lowerBits.getLong(startWord) >>> startBit;
        second = dest[1] - index << l | (startBit + l <= 64 ? second : second | lowerBits.getLong(startWord + 1L) << -startBit) & this.lowerBitsMask;
        return second - first;
    }

    public long[] get(long index, long[] dest, int offset, int length) {
        assert (index >= 0L);
        assert (index < this.length);
        assert (offset >= 0);
        assert (offset < dest.length);
        assert (length >= 0);
        assert (offset + length <= dest.length);
        this.selectUpper.select(index, dest, offset, length);
        int l = this.l;
        long lowerBitsMask = this.lowerBitsMask;
        LongMappedBigList lowerBits = this.lowerBits;
        long position = index * (long)l;
        for (int i = 0; i < length; ++i) {
            long startWord = LongBigArrayBitVector.word((long)position);
            int startBit = LongArrayBitVector.bit((long)position);
            long result = lowerBits.getLong(startWord) >>> startBit;
            dest[offset + i] = dest[offset + i] - index++ << l | (startBit + l <= 64 ? result : result | lowerBits.getLong(startWord + 1L) << -startBit) & lowerBitsMask;
            position += (long)l;
        }
        return dest;
    }

    public long[] get(long index, long[] dest) {
        return this.get(index, dest, 0, dest.length);
    }

    public MappedEliasFanoMonotoneLongBigListIterator listIterator(long from) {
        return new MappedEliasFanoMonotoneLongBigListIterator(from);
    }

    public MappedEliasFanoMonotoneLongBigListIterator listIterator() {
        return new MappedEliasFanoMonotoneLongBigListIterator(0L);
    }

    public MappedEliasFanoMonotoneLongBigListIterator iterator() {
        return this.listIterator();
    }

    public long size64() {
        return this.length;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.upperBits = this.selectUpper.bitVector().bigBits();
    }

    public MappedEliasFanoMonotoneLongBigList copy() {
        MappedEliasFanoMonotoneLongBigList copy = new MappedEliasFanoMonotoneLongBigList(this.length, this.l, this.upperBits, this.selectUpper, this.littleEndian);
        copy.lowerBits = this.lowerBits.copy();
        return copy;
    }

    public class MappedEliasFanoMonotoneLongBigListIterator
    implements LongBigListIterator {
        protected long index;
        protected long word;
        protected long window;
        protected long lowerBitsPosition;

        protected MappedEliasFanoMonotoneLongBigListIterator(long from) {
            this.index = from;
            long position = MappedEliasFanoMonotoneLongBigList.this.selectUpper.select(from);
            this.word = LongBigArrayBitVector.word((long)position);
            this.window = BigArrays.get((long[][])MappedEliasFanoMonotoneLongBigList.this.upperBits, (long)this.word) & -1L << (int)position;
            this.lowerBitsPosition = this.index * (long)MappedEliasFanoMonotoneLongBigList.this.l;
        }

        private long getNextUpperBits() {
            while (this.window == 0L) {
                this.window = BigArrays.get((long[][])MappedEliasFanoMonotoneLongBigList.this.upperBits, (long)(++this.word));
            }
            long upperBits = LongBigArrayBitVector.bits((long)this.word) + (long)Long.numberOfTrailingZeros(this.window) - this.index++;
            this.window &= this.window - 1L;
            return upperBits;
        }

        public long previousIndex() {
            return this.index - 1L;
        }

        public long nextIndex() {
            return this.index;
        }

        public boolean hasPrevious() {
            return this.index > 0L;
        }

        public boolean hasNext() {
            return this.index < MappedEliasFanoMonotoneLongBigList.this.length;
        }

        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextLongUnsafe();
        }

        public long nextLongUnsafe() {
            int l = MappedEliasFanoMonotoneLongBigList.this.l;
            long startWord = LongBigArrayBitVector.word((long)this.lowerBitsPosition);
            int startBit = LongArrayBitVector.bit((long)this.lowerBitsPosition);
            long lower = MappedEliasFanoMonotoneLongBigList.this.lowerBits.getLong(startWord) >>> startBit;
            if (startBit + l > 64) {
                lower |= MappedEliasFanoMonotoneLongBigList.this.lowerBits.getLong(startWord + 1L) << -startBit;
            }
            this.lowerBitsPosition += (long)l;
            return this.getNextUpperBits() << l | lower & MappedEliasFanoMonotoneLongBigList.this.lowerBitsMask;
        }

        public long previousLong() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.previousLongUnsafe();
        }

        public long previousLongUnsafe() {
            int l = MappedEliasFanoMonotoneLongBigList.this.l;
            --this.index;
            long position = MappedEliasFanoMonotoneLongBigList.this.selectUpper.select(this.index);
            this.word = LongBigArrayBitVector.word((long)position);
            this.window = BigArrays.get((long[][])MappedEliasFanoMonotoneLongBigList.this.upperBits, (long)this.word) & -1L << (int)position;
            this.lowerBitsPosition = this.index * (long)l;
            long startWord = LongBigArrayBitVector.word((long)this.lowerBitsPosition);
            int startBit = LongArrayBitVector.bit((long)this.lowerBitsPosition);
            long lower = MappedEliasFanoMonotoneLongBigList.this.lowerBits.getLong(startWord) >>> startBit;
            if (startBit + l > 64) {
                lower |= MappedEliasFanoMonotoneLongBigList.this.lowerBits.getLong(startWord + 1L) << -startBit;
            }
            return position - this.index << l | lower & MappedEliasFanoMonotoneLongBigList.this.lowerBitsMask;
        }
    }
}

