/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.util;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.bytes.ByteIterable;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import it.unimi.dsi.fastutil.shorts.ShortIterable;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.sux4j.bits.Rank9;
import java.io.Serializable;
import java.util.Arrays;

public class TwoSizesLongBigList
extends AbstractLongBigList
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final boolean ASSERTS = false;
    private final long length;
    private final LongBigList small;
    private final LongBigList large;
    private final LongArrayBitVector marker;
    private final Rank9 rank;
    private final long numBits;

    public TwoSizesLongBigList(IntIterable elements) {
        this(() -> LongIterators.wrap((IntIterator)elements.iterator()));
    }

    public TwoSizesLongBigList(ShortIterable elements) {
        this(() -> LongIterators.wrap((ShortIterator)elements.iterator()));
    }

    public TwoSizesLongBigList(ByteIterable elements) {
        this(() -> LongIterators.wrap((ByteIterator)elements.iterator()));
    }

    public TwoSizesLongBigList(LongIterable elements) {
        long l = 0L;
        Long2LongOpenHashMap counts = new Long2LongOpenHashMap();
        int width = 0;
        LongIterator i = elements.iterator();
        while (i.hasNext()) {
            long value = i.nextLong();
            width = Math.max(width, Fast.mostSignificantBit((long)value) + 1);
            counts.put(value, counts.get(value) + 1L);
            ++l;
        }
        this.length = l;
        long[] keys = counts.keySet().toLongArray();
        Arrays.sort(keys);
        long costSmall = 0L;
        long costLarge = this.length * (long)width;
        int minIndex = width;
        long minCostLarge = costLarge;
        long minCostSmall = costSmall;
        int j = 0;
        for (int i2 = 1; i2 < width; ++i2) {
            long k;
            assert (costSmall % (long)i2 == 0L);
            if (i2 != 1) {
                costSmall = costSmall / (long)i2 * (long)(i2 + 1);
            }
            while (j < keys.length && (k = keys[j]) < (long)(1 << i2)) {
                long c = counts.get(k);
                costLarge -= c * (long)width;
                costSmall += c * (long)(i2 + 1);
                ++j;
            }
            if (costLarge + costSmall >= minCostLarge + minCostSmall) continue;
            minIndex = i2;
            minCostLarge = costLarge;
            minCostSmall = costSmall;
        }
        assert (minCostSmall / (long)(minIndex + 1) + minCostLarge / (long)width == this.length);
        if (width != 0 && minIndex != width) {
            long numSmall = minCostSmall / (long)(minIndex + 1);
            long numLarge = minCostLarge / (long)width;
            this.small = LongArrayBitVector.getInstance().asLongBigList(minIndex);
            this.small.size(numSmall);
            this.marker = LongArrayBitVector.getInstance();
            this.marker.length(this.length);
            this.large = LongArrayBitVector.getInstance().asLongBigList(width);
            this.large.size(numLarge);
        } else {
            this.small = LongArrayBitVector.getInstance().asLongBigList(minIndex);
            this.small.size(this.length);
            this.marker = null;
            this.large = null;
        }
        int maxSmall = 1 << minIndex;
        LongIterator iterator = elements.iterator();
        long p = 0L;
        long q = 0L;
        for (long i3 = 0L; i3 < this.length; ++i3) {
            long value = iterator.nextLong();
            if (value < (long)maxSmall) {
                this.small.set(p++, value);
                continue;
            }
            this.large.set(q++, value);
            this.marker.set(i3);
        }
        this.rank = this.marker != null ? new Rank9((BitVector)this.marker) : null;
        this.numBits = this.small.size64() * (long)minIndex + (this.marker != null ? this.rank.numBits() + this.marker.length() + this.large.size64() * (long)width : 0L);
    }

    public long getLong(long index) {
        if (this.marker == null) {
            return this.small.getLong(index);
        }
        if (this.marker.getBoolean(index)) {
            return this.large.getLong(this.rank.rank(index));
        }
        return this.small.getLong(index - this.rank.rank(index));
    }

    public long size64() {
        return this.length;
    }

    public long numBits() {
        return this.numBits;
    }
}

