/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph;

import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.LazyLongIterator;
import it.unimi.dsi.big.webgraph.Transform;
import it.unimi.dsi.fastutil.longs.LongIterator;

public class BidirectionalImmutableGraph
extends ImmutableGraph {
    public final ImmutableGraph forward;
    public final ImmutableGraph backward;

    public BidirectionalImmutableGraph(ImmutableGraph graph, ImmutableGraph transpose) {
        this.forward = graph;
        this.backward = transpose;
        if (graph.numNodes() != transpose.numNodes()) {
            throw new IllegalArgumentException("The graph and its transpose have a different number of nodes");
        }
        try {
            if (graph.numArcs() != transpose.numArcs()) {
                throw new IllegalArgumentException("The graph and its transpose have a different number of arcs");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Override
    public long numNodes() {
        return this.forward.numNodes();
    }

    @Override
    public long numArcs() {
        return this.forward.numArcs();
    }

    @Override
    public boolean randomAccess() {
        return this.forward.randomAccess() && this.backward.randomAccess();
    }

    @Override
    public boolean hasCopiableIterators() {
        return this.forward.hasCopiableIterators() && this.backward.hasCopiableIterators();
    }

    @Override
    public BidirectionalImmutableGraph copy() {
        return new BidirectionalImmutableGraph(this.forward.copy(), this.backward.copy());
    }

    public BidirectionalImmutableGraph transpose() {
        return new BidirectionalImmutableGraph(this.backward, this.forward);
    }

    public BidirectionalImmutableGraph symmetrize() {
        ImmutableGraph symmetric = Transform.union(this.forward, this.backward);
        return new BidirectionalImmutableGraph(symmetric, symmetric);
    }

    public BidirectionalImmutableGraph simplify() {
        ImmutableGraph simplified = Transform.simplify(this.forward, this.backward);
        return new BidirectionalImmutableGraph(simplified, simplified);
    }

    @Override
    public long outdegree(long l) {
        return this.forward.outdegree(l);
    }

    @Override
    public LazyLongIterator successors(long nodeId) {
        return this.forward.successors(nodeId);
    }

    @Override
    public long[][] successorBigArray(long x) {
        return this.forward.successorBigArray(x);
    }

    public long indegree(long x) {
        return this.backward.outdegree(x);
    }

    public LazyLongIterator predecessors(long x) {
        return this.backward.successors(x);
    }

    public long[][] predecessorBigArray(long x) {
        return this.backward.successorBigArray(x);
    }

    public LongIterator indegrees() {
        return this.backward.outdegrees();
    }
}

