/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph;

import it.unimi.dsi.big.webgraph.AbstractLazyLongIterator;
import it.unimi.dsi.big.webgraph.LazyLongIterator;
import it.unimi.dsi.big.webgraph.LazyLongIterators;
import it.unimi.dsi.big.webgraph.NodeIterator;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.lang.FlyweightPrototype;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.AbstractLazyIntIterator;
import it.unimi.dsi.webgraph.LazyIntIterator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImmutableGraph
implements FlyweightPrototype<ImmutableGraph> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmutableGraph.class);
    public static final String GRAPHCLASS_PROPERTY_KEY = "graphclass";
    public static final String PROPERTIES_EXTENSION = ".properties";
    public static final String NUMBER_OF_THREADS_PROPERTY = "it.unimi.dsi.webgraph.threads";
    private static final ProgressLogger UNUSED = new ProgressLogger();

    public abstract long numNodes();

    public int intNumNodes() {
        long numNodes = this.numNodes();
        if (numNodes > Integer.MAX_VALUE) {
            throw new IllegalStateException("This graph has more than Integer.MAX_VALUE nodes");
        }
        return (int)numNodes;
    }

    public long numArcs() {
        throw new UnsupportedOperationException();
    }

    public abstract boolean randomAccess();

    public boolean hasCopiableIterators() {
        return this.randomAccess();
    }

    public CharSequence basename() {
        throw new UnsupportedOperationException();
    }

    public LazyLongIterator successors(long x) {
        return LazyLongIterators.wrap(this.successorBigArray(x), this.outdegree(x));
    }

    public long[][] successorBigArray(long x) {
        long[][] successor = LongBigArrays.newBigArray((long)this.outdegree(x));
        LazyLongIterators.unwrap(this.successors(x), successor);
        return successor;
    }

    public abstract long outdegree(long var1);

    public NodeIterator nodeIterator(final long from) {
        return new NodeIterator(){
            long curr;
            final long n;
            {
                this.curr = from - 1L;
                this.n = ImmutableGraph.this.numNodes();
            }

            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ++this.curr;
            }

            public boolean hasNext() {
                return this.curr < this.n - 1L;
            }

            @Override
            public LazyLongIterator successors() {
                if (this.curr == from - 1L) {
                    throw new IllegalStateException();
                }
                return ImmutableGraph.this.successors(this.curr);
            }

            @Override
            public long outdegree() {
                if (this.curr == from - 1L) {
                    throw new IllegalStateException();
                }
                return ImmutableGraph.this.outdegree(this.curr);
            }
        };
    }

    public NodeIterator nodeIterator() {
        return this.nodeIterator(0L);
    }

    public NodeIterator[] splitNodeIterators(int howMany) {
        if (this.numNodes() == 0L && howMany == 0) {
            return new NodeIterator[0];
        }
        if (howMany < 1) {
            throw new IllegalArgumentException();
        }
        Object[] result = new NodeIterator[howMany];
        if (!this.hasCopiableIterators()) {
            result[0] = this.nodeIterator();
            return result;
        }
        long n = this.numNodes();
        int m = (int)Math.ceil((double)n / (double)howMany);
        if (this.randomAccess()) {
            int i = 0;
            long from = 0;
            while (from < n) {
                result[i] = this.nodeIterator(from).copy(from + (long)m);
                from += (long)m;
                ++i;
            }
            Arrays.fill(result, i, result.length, NodeIterator.EMPTY);
            return result;
        }
        NodeIterator nodeIterator = this.nodeIterator();
        int i = 0;
        long nextNode = 0L;
        while (i < result.length && nodeIterator.hasNext()) {
            if (nextNode % (long)m == 0L) {
                result[i++] = nodeIterator.copy(nextNode + (long)m);
            }
            long node = nodeIterator.nextLong();
            assert (node == nextNode);
            ++nextNode;
        }
        Arrays.fill(result, i, result.length, NodeIterator.EMPTY);
        return result;
    }

    public abstract ImmutableGraph copy();

    public LongIterator outdegrees() {
        return this.randomAccess() ? new LongIterator(){
            private final long n;
            private long next;
            {
                this.n = ImmutableGraph.this.numNodes();
                this.next = 0L;
            }

            public boolean hasNext() {
                return this.next < this.n;
            }

            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ImmutableGraph.this.outdegree(this.next++);
            }
        } : new LongIterator(){
            private final NodeIterator nodeIterator;
            {
                this.nodeIterator = ImmutableGraph.this.nodeIterator();
            }

            public boolean hasNext() {
                return this.nodeIterator.hasNext();
            }

            public long nextLong() {
                this.nodeIterator.nextLong();
                return this.nodeIterator.outdegree();
            }
        };
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        long numArcs = -1L;
        try {
            numArcs = this.numArcs();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        s.append("Nodes: " + this.numNodes() + "\nArcs: " + (numArcs == -1L ? "unknown" : Long.toString(numArcs)) + "\n");
        NodeIterator nodeIterator = this.nodeIterator();
        long i = this.numNodes();
        while (i-- != 0L) {
            long curr = nodeIterator.nextLong();
            s.append("Successors of " + curr + " (degree " + nodeIterator.outdegree() + "):");
            LazyLongIterator successors = nodeIterator.successors();
            long d = nodeIterator.outdegree();
            while (d-- != 0L) {
                s.append(" " + successors.nextLong());
            }
            s.append('\n');
        }
        return s.toString();
    }

    @Deprecated
    public static ImmutableGraph loadSequential(CharSequence basename) throws IOException {
        return ImmutableGraph.load(LoadMethod.SEQUENTIAL, basename, null);
    }

    @Deprecated
    public static ImmutableGraph loadSequential(CharSequence basename, ProgressLogger pl) throws IOException {
        return ImmutableGraph.load(LoadMethod.SEQUENTIAL, basename, null, pl);
    }

    public static ImmutableGraph loadOffline(CharSequence basename) throws IOException {
        return ImmutableGraph.load(LoadMethod.OFFLINE, basename, null);
    }

    public static ImmutableGraph loadOffline(CharSequence basename, ProgressLogger pl) throws IOException {
        return ImmutableGraph.load(LoadMethod.OFFLINE, basename, null, pl);
    }

    public static ImmutableGraph loadMapped(CharSequence basename, ProgressLogger pl) throws IOException {
        return ImmutableGraph.load(LoadMethod.MAPPED, basename, null, pl);
    }

    public static ImmutableGraph loadMapped(CharSequence basename) throws IOException {
        return ImmutableGraph.load(LoadMethod.MAPPED, basename, null);
    }

    public static ImmutableGraph loadOnce(InputStream is) throws IOException {
        throw new UnsupportedOperationException("This class does not support read-once loading");
    }

    public static ImmutableGraph load(CharSequence basename) throws IOException {
        return ImmutableGraph.load(LoadMethod.STANDARD, basename, null);
    }

    public static ImmutableGraph load(CharSequence basename, ProgressLogger pl) throws IOException {
        return ImmutableGraph.load(LoadMethod.STANDARD, basename, null, pl);
    }

    private static ImmutableGraph load(LoadMethod method, CharSequence basename, InputStream is) throws IOException {
        return ImmutableGraph.load(method, basename, is, UNUSED);
    }

    protected static ImmutableGraph load(LoadMethod method, CharSequence basename, InputStream is, ProgressLogger pl) throws IOException {
        FileInputStream propertyFile = new FileInputStream(basename + PROPERTIES_EXTENSION);
        Properties properties = new Properties();
        properties.load(propertyFile);
        propertyFile.close();
        String graphClassName = properties.getProperty(GRAPHCLASS_PROPERTY_KEY);
        if (graphClassName == null) {
            throw new IOException("The property file for " + basename + " does not contain a graphclass property");
        }
        if (graphClassName.startsWith("class ")) {
            graphClassName = graphClassName.substring(6);
        }
        if (graphClassName.startsWith("it.unimi.dsi.webgraph")) {
            String standardGraphClassName = graphClassName.replace("it.unimi.dsi.webgraph", "it.unimi.dsi.big.webgraph");
            LOGGER.warn("Replacing class " + graphClassName + " with " + standardGraphClassName);
            graphClassName = standardGraphClassName;
        }
        ImmutableGraph graph = null;
        try {
            Class<?> graphClass = Class.forName(graphClassName);
            graph = method == LoadMethod.ONCE ? (ImmutableGraph)graphClass.getMethod(method.toMethod(), InputStream.class).invoke(null, is) : (pl == UNUSED ? (ImmutableGraph)graphClass.getMethod(method.toMethod(), CharSequence.class).invoke(null, basename) : (ImmutableGraph)graphClass.getMethod(method.toMethod(), CharSequence.class, ProgressLogger.class).invoke(null, basename, pl));
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return graph;
    }

    public static void store(Class<?> graphClass, ImmutableGraph graph, CharSequence basename, ProgressLogger pl) throws IOException {
        if (!ImmutableGraph.class.isAssignableFrom(graphClass)) {
            throw new ClassCastException(graphClass.getName() + " is not a subclass of ImmutableGraph");
        }
        try {
            if (pl == UNUSED) {
                graphClass.getMethod("store", ImmutableGraph.class, CharSequence.class).invoke(null, graph, basename);
            } else {
                graphClass.getMethod("store", ImmutableGraph.class, CharSequence.class, ProgressLogger.class).invoke(null, graph, basename, pl);
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void store(Class<?> graphClass, ImmutableGraph graph, CharSequence basename) throws IOException {
        ImmutableGraph.store(graphClass, graph, basename, UNUSED);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImmutableGraph)) {
            return false;
        }
        ImmutableGraph g = (ImmutableGraph)o;
        long n = this.numNodes();
        if (n != g.numNodes()) {
            return false;
        }
        NodeIterator i = this.nodeIterator();
        NodeIterator j = g.nodeIterator();
        while (n-- != 0L) {
            i.nextLong();
            j.nextLong();
            long d = i.outdegree();
            if (d != j.outdegree()) {
                return false;
            }
            LazyLongIterator s = i.successors();
            LazyLongIterator t = j.successors();
            while (d-- != 0L) {
                if (s.nextLong() == t.nextLong()) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        long n = this.numNodes();
        long h = -1L;
        NodeIterator i = this.nodeIterator();
        while (n-- != 0L) {
            long x;
            h = h * 31L + i.nextLong();
            LazyLongIterator s = i.successors();
            while ((x = s.nextLong()) != -1L) {
                h = h * 31L + x;
            }
        }
        return (int)(h ^ h >>> 32);
    }

    public static ImmutableGraph wrap(it.unimi.dsi.webgraph.ImmutableGraph graph) {
        return new ImmutableGraphAdapter(graph);
    }

    public static it.unimi.dsi.webgraph.ImmutableGraph wrap(ImmutableGraph graph) {
        return new BigImmutableGraphAdapter(graph);
    }

    public static enum LoadMethod {
        STANDARD,
        SEQUENTIAL,
        OFFLINE,
        ONCE,
        MAPPED;


        public String toMethod() {
            switch (this) {
                case STANDARD: {
                    return "load";
                }
                case SEQUENTIAL: {
                    return "loadSequential";
                }
                case OFFLINE: {
                    return "loadOffline";
                }
                case ONCE: {
                    return "loadOnce";
                }
                case MAPPED: {
                    return "loadMapped";
                }
            }
            throw new AssertionError();
        }
    }

    private static final class ImmutableGraphAdapter
    extends ImmutableGraph {
        private final it.unimi.dsi.webgraph.ImmutableGraph graph;

        public ImmutableGraphAdapter(it.unimi.dsi.webgraph.ImmutableGraph graph) {
            this.graph = graph;
        }

        private final void ensureNode(long x) {
            if (x >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException(Long.toString(x));
            }
        }

        @Override
        public NodeIterator nodeIterator(long from) {
            this.ensureNode(from - 1L);
            return new NodeIteratorAdapter(from == 0L ? this.graph.nodeIterator() : this.graph.nodeIterator((int)from));
        }

        @Override
        public long numArcs() {
            return this.graph.numArcs();
        }

        @Override
        public long numNodes() {
            return this.graph.numNodes();
        }

        @Override
        public long outdegree(long x) {
            this.ensureNode(x);
            return this.graph.outdegree((int)x);
        }

        @Override
        public boolean randomAccess() {
            return this.graph.randomAccess();
        }

        @Override
        public LazyLongIterator successors(final long x) {
            this.ensureNode(x);
            return new AbstractLazyLongIterator(){
                final LazyIntIterator iterator;
                {
                    this.iterator = graph.successors((int)x);
                }

                @Override
                public long nextLong() {
                    return this.iterator.nextInt();
                }
            };
        }

        @Override
        public CharSequence basename() {
            return this.graph.basename();
        }

        @Override
        public ImmutableGraph copy() {
            return new ImmutableGraphAdapter(this.graph.copy());
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ImmutableGraph)) {
                return false;
            }
            return this.graph.equals((Object)ImmutableGraph.wrap((ImmutableGraph)o));
        }

        @Override
        public int hashCode() {
            return this.graph.hashCode();
        }

        @Override
        public String toString() {
            return this.graph.toString();
        }

        private final class NodeIteratorAdapter
        extends NodeIterator {
            final it.unimi.dsi.webgraph.NodeIterator nodeIterator;

            private NodeIteratorAdapter(it.unimi.dsi.webgraph.NodeIterator nodeIterator) {
                this.nodeIterator = nodeIterator;
            }

            public long nextLong() {
                return this.nodeIterator.nextInt();
            }

            public boolean hasNext() {
                return this.nodeIterator.hasNext();
            }

            @Override
            public long outdegree() {
                return this.nodeIterator.outdegree();
            }

            @Override
            public LazyLongIterator successors() {
                return new AbstractLazyLongIterator(){
                    LazyIntIterator iterator;
                    {
                        this.iterator = NodeIteratorAdapter.this.nodeIterator.successors();
                    }

                    @Override
                    public long nextLong() {
                        return this.iterator.nextInt();
                    }
                };
            }

            @Override
            public NodeIterator copy(long upperBound) {
                return new NodeIteratorAdapter(this.nodeIterator.copy((int)Math.min(Integer.MAX_VALUE, upperBound)));
            }
        }
    }

    private static final class BigImmutableGraphAdapter
    extends it.unimi.dsi.webgraph.ImmutableGraph {
        private final ImmutableGraph graph;

        public BigImmutableGraphAdapter(ImmutableGraph graph) {
            this.graph = graph;
        }

        private final int check(long x) {
            if (x > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(Long.toString(x));
            }
            return (int)x;
        }

        public it.unimi.dsi.webgraph.NodeIterator nodeIterator(int from) {
            return new NodeIteratorAdapter(from == 0 ? this.graph.nodeIterator() : this.graph.nodeIterator(from));
        }

        public long numArcs() {
            return this.graph.numArcs();
        }

        public int numNodes() {
            return this.check(this.graph.numNodes());
        }

        public int outdegree(int x) {
            return this.check(this.graph.outdegree(x));
        }

        public boolean randomAccess() {
            return this.graph.randomAccess();
        }

        public AbstractLazyIntIterator successors(final int x) {
            return new AbstractLazyIntIterator(){
                final LazyLongIterator iterator;
                {
                    this.iterator = graph.successors(x);
                }

                public int nextInt() {
                    return this.check(this.iterator.nextLong());
                }
            };
        }

        public CharSequence basename() {
            return this.graph.basename();
        }

        public it.unimi.dsi.webgraph.ImmutableGraph copy() {
            return new BigImmutableGraphAdapter(this.graph.copy());
        }

        public boolean equals(Object o) {
            if (!(o instanceof it.unimi.dsi.webgraph.ImmutableGraph)) {
                return false;
            }
            return this.graph.equals(ImmutableGraph.wrap((it.unimi.dsi.webgraph.ImmutableGraph)o));
        }

        public int hashCode() {
            return this.graph.hashCode();
        }

        public String toString() {
            return this.graph.toString();
        }

        private final class NodeIteratorAdapter
        extends it.unimi.dsi.webgraph.NodeIterator {
            final NodeIterator nodeIterator;

            private NodeIteratorAdapter(NodeIterator nodeIterator) {
                this.nodeIterator = nodeIterator;
            }

            public int nextInt() {
                return BigImmutableGraphAdapter.this.check(this.nodeIterator.nextLong());
            }

            public boolean hasNext() {
                return this.nodeIterator.hasNext();
            }

            public int outdegree() {
                return BigImmutableGraphAdapter.this.check(this.nodeIterator.outdegree());
            }

            public LazyIntIterator successors() {
                return new AbstractLazyIntIterator(){
                    final LazyLongIterator iterator;
                    {
                        this.iterator = NodeIteratorAdapter.this.nodeIterator.successors();
                    }

                    public int nextInt() {
                        return BigImmutableGraphAdapter.this.check(this.iterator.nextLong());
                    }
                };
            }

            public it.unimi.dsi.webgraph.NodeIterator copy(int upperBound) {
                return new NodeIteratorAdapter(this.nodeIterator.copy(upperBound));
            }
        }
    }
}

