/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph;

import it.unimi.dsi.big.webgraph.LazyLongIterator;
import it.unimi.dsi.big.webgraph.LazyLongIterators;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.NoSuchElementException;

public abstract class NodeIterator
implements LongIterator {
    public static final NodeIterator EMPTY = new NodeIterator(){

        @Override
        public NodeIterator copy(long upperBound) {
            return this;
        }

        public boolean hasNext() {
            return false;
        }

        @Override
        public long outdegree() {
            throw new IllegalStateException();
        }

        public long nextLong() {
            throw new NoSuchElementException();
        }
    };

    public abstract long outdegree();

    public LazyLongIterator successors() {
        return LazyLongIterators.wrap(this.successorBigArray(), this.outdegree());
    }

    public long[][] successorBigArray() {
        long[][] successor = LongBigArrays.newBigArray((long)this.outdegree());
        LazyLongIterators.unwrap(this.successors(), successor);
        return successor;
    }

    public NodeIterator copy(long upperBound) {
        throw new UnsupportedOperationException();
    }

    public long skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Argument must be nonnegative: " + n);
        }
        long i = n;
        while (i-- != 0L && this.hasNext()) {
            this.nextLong();
        }
        return n - i - 1L;
    }
}

