/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.big.webgraph.AbstractLazyLongIterator;
import it.unimi.dsi.big.webgraph.BVGraph;
import it.unimi.dsi.big.webgraph.GraphClassParser;
import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.ImmutableSequentialGraph;
import it.unimi.dsi.big.webgraph.LazyLongIterator;
import it.unimi.dsi.big.webgraph.LazyLongIterators;
import it.unimi.dsi.big.webgraph.NodeIterator;
import it.unimi.dsi.big.webgraph.UnionImmutableGraph;
import it.unimi.dsi.big.webgraph.labelling.ArcLabelledImmutableGraph;
import it.unimi.dsi.big.webgraph.labelling.ArcLabelledImmutableSequentialGraph;
import it.unimi.dsi.big.webgraph.labelling.ArcLabelledNodeIterator;
import it.unimi.dsi.big.webgraph.labelling.BitStreamArcLabelledImmutableGraph;
import it.unimi.dsi.big.webgraph.labelling.Label;
import it.unimi.dsi.big.webgraph.labelling.LabelMergeStrategy;
import it.unimi.dsi.big.webgraph.labelling.LabelSemiring;
import it.unimi.dsi.big.webgraph.labelling.Labels;
import it.unimi.dsi.big.webgraph.labelling.UnionArcLabelledImmutableGraph;
import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import it.unimi.dsi.fastutil.io.TextIO;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongHeapSemiIndirectPriorityQueue;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.util.XoRoShiRo128PlusRandom;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transform {
    private static final Logger LOGGER = LoggerFactory.getLogger(Transform.class);
    private static final boolean DEBUG = false;
    public static final NoLoops NO_LOOPS = new NoLoops();

    private Transform() {
    }

    public static ImmutableGraph filterArcs(ImmutableGraph graph, ArcFilter filter, ProgressLogger ignored) {
        return Transform.filterArcs(graph, filter);
    }

    public static ArcLabelledImmutableGraph filterArcs(ArcLabelledImmutableGraph graph, LabelledArcFilter filter, ProgressLogger ignored) {
        return Transform.filterArcs(graph, filter);
    }

    public static ImmutableGraph filterArcs(ImmutableGraph graph, ArcFilter filter) {
        return new FilteredImmutableGraph(filter, graph);
    }

    public static ArcLabelledImmutableGraph filterArcs(ArcLabelledImmutableGraph graph, LabelledArcFilter filter) {
        return new FilteredArcLabelledImmutableGraph(filter, graph);
    }

    public static ImmutableGraph symmetrizeOffline(ImmutableGraph g, int batchSize) throws IOException {
        return Transform.symmetrizeOffline(g, batchSize, null, null);
    }

    public static ImmutableGraph symmetrizeOffline(ImmutableGraph g, int batchSize, File tempDir) throws IOException {
        return Transform.symmetrizeOffline(g, batchSize, tempDir, null);
    }

    public static ImmutableGraph symmetrizeOffline(ImmutableGraph g, int batchSize, File tempDir, ProgressLogger pl) throws IOException {
        return Transform.union(g, Transform.transposeOffline(g, batchSize, tempDir, pl));
    }

    public static ImmutableGraph simplify(ImmutableGraph g, ImmutableGraph t, ProgressLogger pl) {
        return Transform.filterArcs(Transform.union(g, t), NO_LOOPS, pl);
    }

    public static ImmutableGraph simplify(ImmutableGraph g, ImmutableGraph t) {
        return Transform.filterArcs(Transform.union(g, t), NO_LOOPS, null);
    }

    public static ImmutableGraph simplifyOffline(ImmutableGraph g, int batchSize) throws IOException {
        return Transform.simplifyOffline(g, batchSize, null, null);
    }

    public static ImmutableGraph simplifyOffline(ImmutableGraph g, int batchSize, File tempDir) throws IOException {
        return Transform.simplifyOffline(g, batchSize, tempDir, null);
    }

    public static ImmutableGraph simplifyOffline(ImmutableGraph g, int batchSize, File tempDir, ProgressLogger pl) throws IOException {
        return Transform.filterArcs(Transform.symmetrizeOffline(g, batchSize, tempDir, pl), NO_LOOPS);
    }

    public static int processBatch(int n, long[] source, long[] target, File tempDir, List<File> batches) throws IOException {
        LongArrays.parallelQuickSort((long[])source, (long[])target, (int)0, (int)n);
        File batchFile = File.createTempFile("batch", ".bitstream", tempDir);
        batchFile.deleteOnExit();
        batches.add(batchFile);
        OutputBitStream batch = new OutputBitStream(batchFile);
        int u = 0;
        if (n != 0) {
            u = 1;
            int i = n - 1;
            while (i-- != 0) {
                if (source[i] == source[i + 1] && target[i] == target[i + 1]) continue;
                ++u;
            }
            batch.writeDelta(u);
            long prevSource = source[0];
            batch.writeLongDelta(prevSource);
            batch.writeLongDelta(target[0]);
            for (int i2 = 1; i2 < n; ++i2) {
                if (source[i2] != prevSource) {
                    batch.writeLongDelta(source[i2] - prevSource);
                    batch.writeLongDelta(target[i2]);
                    prevSource = source[i2];
                    continue;
                }
                if (target[i2] == target[i2 - 1]) continue;
                batch.writeDelta(0);
                assert (target[i2] > target[i2 - 1]) : target[i2] + "<=" + target[i2 - 1];
                batch.writeLongDelta(target[i2] - target[i2 - 1] - 1L);
            }
        } else {
            batch.writeDelta(0);
        }
        batch.close();
        return u;
    }

    private static void processTransposeBatch(int n, long[] source, long[] target, long[] start, InputBitStream labelBitStream, File tempDir, List<File> batches, List<File> labelBatches, Label prototype) throws IOException {
        int i;
        Arrays.parallelQuickSort((int)0, (int)n, (x, y) -> {
            int t = Long.compare(source[x], source[y]);
            if (t != 0) {
                return t;
            }
            return Long.compare(target[x], target[y]);
        }, (x, y) -> {
            long t = source[x];
            source[x] = source[y];
            source[y] = t;
            t = target[x];
            target[x] = target[y];
            target[y] = t;
            long u = start[x];
            start[x] = start[y];
            start[y] = u;
        });
        File batchFile = File.createTempFile("batch", ".bitstream", tempDir);
        batchFile.deleteOnExit();
        batches.add(batchFile);
        OutputBitStream batch = new OutputBitStream(batchFile);
        if (n != 0) {
            batch.writeDelta(n);
            long prevSource = source[0];
            batch.writeLongDelta(prevSource);
            batch.writeLongDelta(target[0]);
            for (i = 1; i < n; ++i) {
                if (source[i] != prevSource) {
                    batch.writeLongDelta(source[i] - prevSource);
                    batch.writeLongDelta(target[i]);
                    prevSource = source[i];
                    continue;
                }
                if (target[i] == target[i - 1]) continue;
                batch.writeDelta(0);
                batch.writeLongDelta(target[i] - target[i - 1] - 1L);
            }
        } else {
            batch.writeDelta(0);
        }
        batch.close();
        File labelFile = File.createTempFile("label-", ".bits", tempDir);
        labelFile.deleteOnExit();
        labelBatches.add(labelFile);
        OutputBitStream labelObs = new OutputBitStream(labelFile);
        for (i = 0; i < n; ++i) {
            labelBitStream.position(start[i]);
            prototype.fromBitStream(labelBitStream, source[i]);
            prototype.toBitStream(labelObs, target[i]);
        }
        labelObs.close();
    }

    public static ImmutableSequentialGraph transposeOffline(ImmutableGraph g, int batchSize) throws IOException {
        return Transform.transposeOffline(g, batchSize, null);
    }

    public static ImmutableSequentialGraph transposeOffline(ImmutableGraph g, int batchSize, File tempDir) throws IOException {
        return Transform.transposeOffline(g, batchSize, tempDir, null);
    }

    public static ImmutableSequentialGraph transposeOffline(ImmutableGraph g, int batchSize, File tempDir, ProgressLogger pl) throws IOException {
        long[] source = new long[batchSize];
        long[] target = new long[batchSize];
        ObjectArrayList batches = new ObjectArrayList();
        long n = g.numNodes();
        if (pl != null) {
            pl.itemsName = "nodes";
            pl.expectedUpdates = n;
            pl.start((CharSequence)"Creating sorted batches...");
        }
        NodeIterator nodeIterator = g.nodeIterator();
        long m = 0L;
        int j = 0;
        long i = n;
        while (i-- != 0L) {
            long currNode = nodeIterator.nextLong();
            long d = nodeIterator.outdegree();
            LazyLongIterator succ = nodeIterator.successors();
            m += d;
            for (long k = 0L; k < d; ++k) {
                target[j] = currNode;
                source[j++] = succ.nextLong();
                if (j != batchSize) continue;
                Transform.processBatch(batchSize, source, target, tempDir, (List<File>)batches);
                j = 0;
            }
            if (pl == null) continue;
            pl.lightUpdate();
        }
        if (j != 0) {
            Transform.processBatch(j, source, target, tempDir, (List<File>)batches);
        }
        if (pl != null) {
            pl.done();
            Transform.logBatches((ObjectArrayList<File>)batches, m, pl);
        }
        return new BatchGraph(n, m, (ObjectArrayList<File>)batches);
    }

    protected static void logBatches(ObjectArrayList<File> batches, long pairs, ProgressLogger pl) {
        long length = 0L;
        for (File f : batches) {
            length += f.length();
        }
        pl.logger().info("Created " + batches.size() + " batches using " + Util.format((double)(8.0 * (double)length / (double)pairs)) + " bits/arc.");
    }

    public static ImmutableSequentialGraph mapOffline(ImmutableGraph g, long[][] map, int batchSize) throws IOException {
        return Transform.mapOffline(g, map, batchSize, null);
    }

    public static ImmutableSequentialGraph mapOffline(ImmutableGraph g, long[][] map, int batchSize, File tempDir) throws IOException {
        return Transform.mapOffline(g, map, batchSize, tempDir, null);
    }

    public static ImmutableSequentialGraph mapOffline(ImmutableGraph g, long[][] map, int batchSize, File tempDir, ProgressLogger pl) throws IOException {
        long[] source = new long[batchSize];
        long[] target = new long[batchSize];
        ObjectArrayList batches = new ObjectArrayList();
        long max = -1L;
        int i = map.length;
        while (i-- != 0) {
            long[] t = map[i];
            int k = t.length;
            while (k-- != 0) {
                max = Math.max(max, t[k]);
            }
        }
        long mapLength = BigArrays.length((long[][])map);
        if (pl != null) {
            pl.itemsName = "nodes";
            pl.expectedUpdates = mapLength;
            pl.start((CharSequence)"Creating sorted batches...");
        }
        NodeIterator nodeIterator = g.nodeIterator();
        int j = 0;
        long pairs = 0L;
        long i2 = g.numNodes();
        while (i2-- != 0L) {
            long mappedCurrNode = BigArrays.get((long[][])map, (long)nodeIterator.nextLong());
            if (mappedCurrNode != -1L) {
                long d = nodeIterator.outdegree();
                LazyLongIterator succ = nodeIterator.successors();
                for (long k = 0L; k < d; ++k) {
                    long s = succ.nextLong();
                    if (BigArrays.get((long[][])map, (long)s) == -1L) continue;
                    source[j] = mappedCurrNode;
                    target[j++] = BigArrays.get((long[][])map, (long)s);
                    if (j != batchSize) continue;
                    pairs += (long)Transform.processBatch(batchSize, source, target, tempDir, (List<File>)batches);
                    j = 0;
                }
            }
            if (pl == null) continue;
            pl.lightUpdate();
        }
        if (g.numNodes() != mapLength) {
            throw new IllegalArgumentException("Mismatch between number of nodes (" + g.numNodes() + ") and map length (" + mapLength + ")");
        }
        if (j != 0) {
            pairs += (long)Transform.processBatch(j, source, target, tempDir, (List<File>)batches);
        }
        if (pl != null) {
            pl.done();
            Transform.logBatches((ObjectArrayList<File>)batches, pairs, pl);
        }
        return new BatchGraph(max + 1L, -1L, (ObjectArrayList<File>)batches);
    }

    public static ArcLabelledImmutableGraph transposeOffline(ArcLabelledImmutableGraph g, int batchSize) throws IOException {
        return Transform.transposeOffline(g, batchSize, null);
    }

    public static ArcLabelledImmutableGraph transposeOffline(ArcLabelledImmutableGraph g, int batchSize, File tempDir) throws IOException {
        return Transform.transposeOffline(g, batchSize, tempDir, null);
    }

    public static ArcLabelledImmutableGraph transposeOffline(ArcLabelledImmutableGraph g, int batchSize, File tempDir, ProgressLogger pl) throws IOException {
        long[] source = new long[batchSize];
        long[] target = new long[batchSize];
        long[] start = new long[batchSize];
        FastByteArrayOutputStream fbos = new FastByteArrayOutputStream();
        OutputBitStream obs = new OutputBitStream((OutputStream)fbos);
        final ObjectArrayList batches = new ObjectArrayList();
        final ObjectArrayList labelBatches = new ObjectArrayList();
        final Label prototype = g.prototype().copy();
        final long n = g.numNodes();
        if (pl != null) {
            pl.itemsName = "nodes";
            pl.expectedUpdates = n;
            pl.start((CharSequence)"Creating sorted batches...");
        }
        ArcLabelledNodeIterator nodeIterator = g.nodeIterator();
        Object[][] label = null;
        long m = 0L;
        int j = 0;
        long i = n;
        while (i-- != 0L) {
            long currNode = nodeIterator.nextLong();
            long d = nodeIterator.outdegree();
            ArcLabelledNodeIterator.LabelledArcIterator succ = nodeIterator.successors();
            label = nodeIterator.labelBigArray();
            m += d;
            for (long k = 0L; k < d; ++k) {
                source[j] = succ.nextLong();
                target[j] = currNode;
                start[j] = obs.writtenBits();
                ((Label)BigArrays.get((Object[][])label, (long)k)).toBitStream(obs, currNode);
                if (++j != batchSize) continue;
                obs.flush();
                Transform.processTransposeBatch(batchSize, source, target, start, new InputBitStream(fbos.array), tempDir, (List<File>)batches, (List<File>)labelBatches, prototype);
                fbos = new FastByteArrayOutputStream();
                obs = new OutputBitStream((OutputStream)fbos);
                j = 0;
            }
            if (pl == null) continue;
            pl.lightUpdate();
        }
        if (j != 0) {
            obs.flush();
            Transform.processTransposeBatch(j, source, target, start, new InputBitStream(fbos.array), tempDir, (List<File>)batches, (List<File>)labelBatches, prototype);
        }
        if (pl != null) {
            pl.done();
            Transform.logBatches((ObjectArrayList<File>)batches, m, pl);
        }
        final long numArcs = m;
        return new ArcLabelledImmutableSequentialGraph(){

            @Override
            public long numNodes() {
                return n;
            }

            @Override
            public long numArcs() {
                return numArcs;
            }

            @Override
            public boolean hasCopiableIterators() {
                return true;
            }

            @Override
            public ArcLabelledNodeIterator nodeIterator() {
                try {
                    return new InternalArcLabelledNodeIterator(Long.MAX_VALUE);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            protected void finalize() throws Throwable {
                try {
                    for (File f : batches) {
                        f.delete();
                    }
                    for (File f : labelBatches) {
                        f.delete();
                    }
                }
                finally {
                    super.finalize();
                }
            }

            @Override
            public Label prototype() {
                return prototype;
            }

            class InternalArcLabelledNodeIterator
            extends ArcLabelledNodeIterator {
                private static final int STD_BUFFER_SIZE = 65536;
                private final long[] refArray;
                private final InputBitStream[] batchIbs;
                private final int[] inputStreamLength;
                private final InputBitStream[] labelInputBitStream;
                private final long[] prevTarget;
                private final LongHeapSemiIndirectPriorityQueue queue;
                private final long hasNextLimit;
                private long last;
                private long outdegree;
                private long[][] successor;
                private Label[][] label;

                public InternalArcLabelledNodeIterator(long upperBound) throws IOException {
                    this(upperBound, null, null, null, null, null, -1L, 0L, LongBigArrays.EMPTY_BIG_ARRAY, Label.EMPTY_LABEL_BIG_ARRAY);
                }

                public InternalArcLabelledNodeIterator(long upperBound, InputBitStream[] baseIbs, InputBitStream[] baseLabelInputBitStream, long[] refArray, long[] prevTarget, int[] inputStreamLength, long last, long outdegree, long[][] successor, Label[][] label) throws IOException {
                    this.hasNextLimit = Math.min(n, upperBound) - 1L;
                    this.last = last;
                    this.outdegree = outdegree;
                    this.successor = successor;
                    this.label = label;
                    this.batchIbs = new InputBitStream[batches.size()];
                    this.labelInputBitStream = new InputBitStream[batches.size()];
                    if (refArray == null) {
                        this.refArray = new long[batches.size()];
                        this.prevTarget = new long[batches.size()];
                        this.inputStreamLength = new int[batches.size()];
                        java.util.Arrays.fill(this.prevTarget, -1L);
                        this.queue = new LongHeapSemiIndirectPriorityQueue(this.refArray);
                        for (int i = 0; i < batches.size(); ++i) {
                            this.batchIbs[i] = new InputBitStream((File)batches.get(i), 65536);
                            this.labelInputBitStream[i] = new InputBitStream((File)labelBatches.get(i), 65536);
                            this.inputStreamLength[i] = this.batchIbs[i].readDelta();
                            this.refArray[i] = this.batchIbs[i].readDelta();
                            this.queue.enqueue(i);
                        }
                    } else {
                        this.refArray = refArray;
                        this.prevTarget = prevTarget;
                        this.inputStreamLength = inputStreamLength;
                        this.queue = new LongHeapSemiIndirectPriorityQueue(refArray);
                        for (int i = 0; i < refArray.length; ++i) {
                            if (baseIbs[i] == null) continue;
                            this.batchIbs[i] = new InputBitStream((File)batches.get(i), 65536);
                            this.batchIbs[i].position(baseIbs[i].position());
                            this.labelInputBitStream[i] = new InputBitStream((File)labelBatches.get(i), 65536);
                            this.labelInputBitStream[i].position(baseLabelInputBitStream[i].position());
                            this.queue.enqueue(i);
                        }
                    }
                }

                @Override
                public long outdegree() {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    return this.outdegree;
                }

                public boolean hasNext() {
                    return this.last < this.hasNextLimit;
                }

                public long nextLong() {
                    ++this.last;
                    long d = 0L;
                    try {
                        int i;
                        while (!this.queue.isEmpty() && this.refArray[i = this.queue.first()] == this.last) {
                            this.successor = BigArrays.grow((long[][])this.successor, (long)(d + 1L));
                            int n = i;
                            long l = this.prevTarget[n] + (this.batchIbs[i].readLongDelta() + 1L);
                            this.prevTarget[n] = l;
                            BigArrays.set((long[][])this.successor, (long)d, (long)l);
                            this.label = (Label[][])BigArrays.grow((Object[][])this.label, (long)(d + 1L));
                            Label l2 = prototype.copy();
                            BigArrays.set((Object[][])this.label, (long)d, (Object)l2);
                            l2.fromBitStream(this.labelInputBitStream[i], this.last);
                            int n2 = i;
                            this.inputStreamLength[n2] = this.inputStreamLength[n2] - 1;
                            if (this.inputStreamLength[n2] == 0) {
                                this.queue.dequeue();
                                this.batchIbs[i].close();
                                this.labelInputBitStream[i].close();
                                this.batchIbs[i] = null;
                                this.labelInputBitStream[i] = null;
                            } else {
                                long sourceDelta = this.batchIbs[i].readLongDelta();
                                if (sourceDelta != 0L) {
                                    int n3 = i;
                                    this.refArray[n3] = this.refArray[n3] + sourceDelta;
                                    this.prevTarget[i] = -1L;
                                    this.queue.changed();
                                }
                            }
                            ++d;
                        }
                        BigArrays.quickSort((long)0L, (long)d, (x, y) -> Long.compare(BigArrays.get((long[][])this.successor, (long)x), BigArrays.get((long[][])this.successor, (long)y)), (x, y) -> {
                            long t = BigArrays.get((long[][])this.successor, (long)x);
                            BigArrays.set((long[][])this.successor, (long)x, (long)BigArrays.get((long[][])this.successor, (long)y));
                            BigArrays.set((long[][])this.successor, (long)y, (long)t);
                            Label l = (Label)BigArrays.get((Object[][])this.label, (long)x);
                            BigArrays.set((Object[][])this.label, (long)x, (Object)((Label)BigArrays.get((Object[][])this.label, (long)y)));
                            BigArrays.set((Object[][])this.label, (long)y, (Object)l);
                        });
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.outdegree = d;
                    return this.last;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void finalize() throws Throwable {
                    try {
                        for (InputBitStream ibs : this.batchIbs) {
                            if (ibs == null) continue;
                            ibs.close();
                        }
                        for (InputBitStream ibs : this.labelInputBitStream) {
                            if (ibs == null) continue;
                            ibs.close();
                        }
                    }
                    finally {
                        super.finalize();
                    }
                }

                @Override
                public ArcLabelledNodeIterator.LabelledArcIterator successors() {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    return new ArcLabelledNodeIterator.LabelledArcIterator(){
                        long last = -1L;

                        @Override
                        public Label label() {
                            return (Label)BigArrays.get((Object[][])InternalArcLabelledNodeIterator.this.label, (long)this.last);
                        }

                        @Override
                        public long nextLong() {
                            if (this.last + 1L == InternalArcLabelledNodeIterator.this.outdegree) {
                                return -1L;
                            }
                            return BigArrays.get((long[][])InternalArcLabelledNodeIterator.this.successor, (long)(++this.last));
                        }

                        @Override
                        public long skip(long k) {
                            long toSkip = Math.min(k, InternalArcLabelledNodeIterator.this.outdegree - this.last - 1L);
                            this.last += toSkip;
                            return toSkip;
                        }
                    };
                }

                @Override
                public ArcLabelledNodeIterator copy(long upperBound) {
                    try {
                        if (this.last == -1L) {
                            return new InternalArcLabelledNodeIterator(upperBound);
                        }
                        return new InternalArcLabelledNodeIterator(upperBound, this.batchIbs, this.labelInputBitStream, (long[])this.refArray.clone(), (long[])this.prevTarget.clone(), (int[])this.inputStreamLength.clone(), this.last, this.outdegree, BigArrays.copy((long[][])this.successor, (long)0L, (long)this.outdegree), (Label[][])BigArrays.copy((Object[][])this.label, (long)0L, (long)this.outdegree));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
    }

    public static ArcLabelledImmutableGraph union(ArcLabelledImmutableGraph g0, ArcLabelledImmutableGraph g1, LabelMergeStrategy labelMergeStrategy) {
        return new UnionArcLabelledImmutableGraph(g0, g1, labelMergeStrategy == null ? Labels.KEEP_FIRST_MERGE_STRATEGY : labelMergeStrategy);
    }

    public static ImmutableGraph union(ImmutableGraph g0, ImmutableGraph g1) {
        return g0 instanceof ArcLabelledImmutableGraph && g1 instanceof ArcLabelledImmutableGraph ? Transform.union((ArcLabelledImmutableGraph)g0, (ArcLabelledImmutableGraph)g1, null) : new UnionImmutableGraph(g0, g1);
    }

    public static ImmutableGraph compose(ImmutableGraph g0, ImmutableGraph g1) {
        return new ComposedGraph(g0, g1);
    }

    public static ArcLabelledImmutableGraph compose(final ArcLabelledImmutableGraph g0, final ArcLabelledImmutableGraph g1, final LabelSemiring strategy) {
        if (g0.prototype().getClass() != g1.prototype().getClass()) {
            throw new IllegalArgumentException("The two graphs have different label classes (" + g0.prototype().getClass().getSimpleName() + ", " + g1.prototype().getClass().getSimpleName() + ")");
        }
        return new ArcLabelledImmutableSequentialGraph(){

            @Override
            public Label prototype() {
                return g0.prototype();
            }

            @Override
            public long numNodes() {
                return Math.max(g0.numNodes(), g1.numNodes());
            }

            @Override
            public boolean hasCopiableIterators() {
                return g0.hasCopiableIterators() && g1.hasCopiableIterators();
            }

            @Override
            public ArcLabelledNodeIterator nodeIterator() {
                return new InternalArcLabelledNodeIterator(Long.MAX_VALUE);
            }

            class InternalArcLabelledNodeIterator
            extends ArcLabelledNodeIterator {
                private final long upperBound;
                private long nextNode;
                private long[] succ = LongArrays.EMPTY_ARRAY;
                private Label[] label = Label.EMPTY_LABEL_ARRAY;
                private int maxOutDegree;
                private int smallCount;
                private Long2ObjectOpenHashMap<Label> successors = new Long2ObjectOpenHashMap(16, 0.5f);
                private int outdegree = -1;
                private final ArcLabelledNodeIterator it0;

                public InternalArcLabelledNodeIterator(long upperBond) {
                    this.successors.defaultReturnValue((Object)strategy.zero());
                    this.it0 = g0.nodeIterator();
                    this.upperBound = upperBond;
                }

                public long nextLong() {
                    this.outdegree = -1;
                    ++this.nextNode;
                    return this.it0.nextLong();
                }

                public boolean hasNext() {
                    return this.nextNode < this.upperBound && this.it0.hasNext();
                }

                @Override
                public long outdegree() {
                    if (this.outdegree < 0) {
                        this.successorBigArray();
                    }
                    return this.outdegree;
                }

                private void ensureCache() {
                    if (this.outdegree < 0) {
                        long longD = this.it0.outdegree();
                        if (longD > Integer.MAX_VALUE) {
                            throw new IllegalArgumentException("This big implementation requires outdegrees to be less than 2^31");
                        }
                        int d = (int)longD;
                        ArcLabelledNodeIterator.LabelledArcIterator s = this.it0.successors();
                        if (this.successors.size() < this.maxOutDegree / 2 && this.smallCount++ > 100) {
                            this.smallCount = 0;
                            this.maxOutDegree = 0;
                            this.successors = new Long2ObjectOpenHashMap(16, 0.5f);
                            this.successors.defaultReturnValue((Object)strategy.zero());
                        } else {
                            this.successors.clear();
                        }
                        for (long i = 0L; i < (long)d; ++i) {
                            long x;
                            ArcLabelledNodeIterator.LabelledArcIterator s1 = g1.successors(s.nextLong());
                            while ((x = s1.nextLong()) >= 0L) {
                                this.successors.put(x, (Object)strategy.add(strategy.multiply(s.label(), s1.label()), (Label)this.successors.get(x)));
                            }
                        }
                        this.outdegree = this.successors.size();
                        this.succ = LongArrays.ensureCapacity((long[])this.succ, (int)this.outdegree, (int)0);
                        this.label = (Label[])ObjectArrays.ensureCapacity((Object[])this.label, (int)this.outdegree, (int)0);
                        this.successors.keySet().toArray(this.succ);
                        LongArrays.quickSort((long[])this.succ, (int)0, (int)this.outdegree);
                        int i = this.outdegree;
                        while (i-- != 0) {
                            this.label[i] = (Label)this.successors.get(this.succ[i]);
                        }
                        if (this.outdegree > this.maxOutDegree) {
                            this.maxOutDegree = this.outdegree;
                        }
                    }
                }

                @Override
                public long[][] successorBigArray() {
                    this.ensureCache();
                    return BigArrays.wrap((long[])this.succ);
                }

                @Override
                public Label[][] labelBigArray() {
                    this.ensureCache();
                    return (Label[][])BigArrays.wrap((Object[])this.label);
                }

                @Override
                public ArcLabelledNodeIterator.LabelledArcIterator successors() {
                    this.ensureCache();
                    return new ArcLabelledNodeIterator.LabelledArcIterator(){
                        int i = -1;

                        @Override
                        public Label label() {
                            return InternalArcLabelledNodeIterator.this.label[this.i];
                        }

                        @Override
                        public long nextLong() {
                            return this.i < InternalArcLabelledNodeIterator.this.outdegree - 1 ? InternalArcLabelledNodeIterator.this.succ[++this.i] : -1L;
                        }

                        @Override
                        public long skip(long n) {
                            int incr = (int)Math.min(n, (long)(InternalArcLabelledNodeIterator.this.outdegree - this.i - 1));
                            this.i += incr;
                            return incr;
                        }
                    };
                }
            }
        };
    }

    public static long[][] grayCodePermutation(ImmutableGraph g) {
        long n = g.numNodes();
        long[][] perm = LongBigArrays.newBigArray((long)n);
        long i = n;
        while (i-- != 0L) {
            BigArrays.set((long[][])perm, (long)i, (long)i);
        }
        LongComparator grayComparator = (x, y) -> {
            LazyLongIterator i1 = g.successors(x);
            LazyLongIterator j = g.successors(y);
            boolean parity = false;
            while (true) {
                long a = i1.nextLong();
                long b = j.nextLong();
                if (a == -1L && b == -1L) {
                    return 0;
                }
                if (a == -1L) {
                    return parity ? 1 : -1;
                }
                if (b == -1L) {
                    return parity ? -1 : 1;
                }
                if (a != b) {
                    return parity ^ a < b ? 1 : -1;
                }
                parity = !parity;
            }
        };
        LongBigArrays.quickSort((long[][])perm, (long)0L, (long)n, (LongComparator)grayComparator);
        return Util.invertPermutationInPlace((long[][])perm);
    }

    public static long[][] randomPermutation(ImmutableGraph g, long seed) {
        return LongBigArrays.shuffle((long[][])Util.identity((long)g.numNodes()), (Random)new XoRoShiRo128PlusRandom(seed));
    }

    public static long[][] lexicographicalPermutation(ImmutableGraph g) {
        long n = g.numNodes();
        long[][] perm = Util.identity((long)n);
        LongComparator lexicographicalComparator = (x, y) -> {
            long b;
            long a;
            LazyLongIterator i = g.successors(x);
            LazyLongIterator j = g.successors(y);
            do {
                a = i.nextLong();
                b = j.nextLong();
                if (a == -1L && b == -1L) {
                    return 0;
                }
                if (a == -1L) {
                    return -1;
                }
                if (b != -1L) continue;
                return 1;
            } while (a == b);
            long t = b - a;
            return t == 0L ? 0 : (t < 0L ? -1 : 1);
        };
        LongBigArrays.quickSort((long[][])perm, (long)0L, (long)n, (LongComparator)lexicographicalComparator);
        return Util.invertPermutationInPlace((long[][])perm);
    }

    private static boolean ensureNumArgs(String[] param, int n) {
        if (n >= 0 && param.length != n || n < 0 && param.length < -n) {
            System.err.println("Wrong number (" + param.length + ") of arguments.");
            return false;
        }
        return true;
    }

    private static ImmutableGraph load(Class<?> graphClass, String baseName, boolean offline, ProgressLogger pl) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        ImmutableGraph graph = null;
        graph = graphClass != null ? (offline ? (ImmutableGraph)graphClass.getMethod("loadOffline", CharSequence.class, ProgressLogger.class).invoke(null, baseName, pl) : (ImmutableGraph)graphClass.getMethod("load", CharSequence.class).invoke(null, baseName)) : (offline ? ImmutableGraph.loadOffline(baseName) : ImmutableGraph.load(baseName, pl));
        return graph;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws IOException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, JSAPException {
        long n;
        ImmutableGraph result;
        Class sourceGraphClass = null;
        Class destGraphClass = BVGraph.class;
        Field[] field = Transform.class.getDeclaredFields();
        ArrayList<String> filterList = new ArrayList<String>();
        ArrayList<String> labelledFilterList = new ArrayList<String>();
        for (Field f : field) {
            if (ArcFilter.class.isAssignableFrom(f.getType())) {
                filterList.add(f.getName());
            }
            if (!LabelledArcFilter.class.isAssignableFrom(f.getType())) continue;
            labelledFilterList.add(f.getName());
        }
        SimpleJSAP jsap = new SimpleJSAP(Transform.class.getName(), "Transforms one or more graphs. All transformations require, after the name,\nsome parameters specified below:\n\nidentity                  sourceBasename destBasename\nmapOffline                sourceBasename destBasename map [batchSize] [tempDir] [cutoff]\ntransposeOffline          sourceBasename destBasename [batchSize] [tempDir]\nsymmetrizeOffline         sourceBasename destBasename [batchSize] [tempDir]\nsimplify                  sourceBasename transposeBasename destBasename\nsimplifyOffline           sourceBasename destBasename [batchSize] [tempDir]\nunion                     source1Basename source2Basename destBasename [strategy]\ncompose                   source1Basename source2Basename destBasename [semiring]\ngray                      sourceBasename destBasename [batchSize] [tempDir]\ngrayPerm                  sourceBasename dest\nlex                       sourceBasename destBasename [batchSize] [tempDir]\nlexPerm                   sourceBasename dest\nrandom                    sourceBasename destBasename [seed] [batchSize] [tempDir]\narcfilter                 sourceBasename destBasename arcFilter (available filters: " + filterList + ")\nlarcfilter                sourceBasename destBasename arcFilter (available filters: " + labelledFilterList + ")\n\nPlease consult the Javadoc documentation for more information on each transform.", new Parameter[]{new FlaggedOption("sourceGraphClass", (StringParser)GraphClassParser.getParser(), JSAP.NO_DEFAULT, false, 's', "source-graph-class", "Forces a Java class to load the source graph."), new FlaggedOption("destGraphClass", (StringParser)GraphClassParser.getParser(), BVGraph.class.getName(), false, 'd', "dest-graph-class", "Forces a Java class to store the destination graph."), new FlaggedOption("destArcLabelledGraphClass", (StringParser)GraphClassParser.getParser(), BitStreamArcLabelledImmutableGraph.class.getName(), false, 'L', "dest-arc-labelled-graph-class", "Forces a Java class to store the labels of the destination graph."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new Switch("offline", 'o', "offline", "Use the offline load method to reduce memory consumption (disables multi-threaded compression)."), new Switch("ascii", 'a', "ascii", "Maps are in ASCII form (one integer per line)."), new UnflaggedOption("transform", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The transformation to be applied."), new UnflaggedOption("param", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, true, "The remaining parameters.")});
        JSAPResult jsapResult = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        sourceGraphClass = jsapResult.getClass("sourceGraphClass");
        destGraphClass = jsapResult.getClass("destGraphClass");
        boolean ascii = jsapResult.getBoolean("ascii");
        boolean offline = jsapResult.getBoolean("offline");
        String transform = jsapResult.getString("transform");
        String[] param = jsapResult.getStringArray("param");
        String[] source = null;
        String dest = null;
        String map = null;
        ArcFilter arcFilter = null;
        LabelledArcFilter labelledArcFilter = null;
        LabelSemiring labelSemiring = null;
        LabelMergeStrategy labelMergeStrategy = null;
        int batchSize = 1000000;
        long cutoff = -1L;
        long seed = 0L;
        File tempDir = null;
        if (!Transform.ensureNumArgs(param, -2)) {
            return;
        }
        if (transform.equals("identity") || transform.equals("grayPerm") || transform.equals("lexPerm")) {
            source = new String[]{param[0]};
            dest = param[1];
            if (!Transform.ensureNumArgs(param, 2)) {
                return;
            }
        } else if (transform.equals("mapOffline")) {
            if (!Transform.ensureNumArgs(param, -3)) {
                return;
            }
            source = new String[]{param[0]};
            dest = param[1];
            map = param[2];
            if (param.length >= 4) {
                batchSize = (Integer)JSAP.INTSIZE_PARSER.parse(param[3]);
                if (param.length >= 5) {
                    tempDir = new File(param[4]);
                    if (param.length == 6) {
                        cutoff = Long.parseLong(param[5]);
                    } else if (!Transform.ensureNumArgs(param, 5)) {
                        return;
                    }
                } else if (!Transform.ensureNumArgs(param, 4)) {
                    return;
                }
            } else if (!Transform.ensureNumArgs(param, 3)) {
                return;
            }
        } else if (transform.equals("random")) {
            if (!Transform.ensureNumArgs(param, -2)) {
                return;
            }
            source = new String[]{param[0]};
            dest = param[1];
            if (param.length >= 3) {
                seed = Long.parseLong(param[2]);
                if (param.length >= 4) {
                    batchSize = (Integer)JSAP.INTSIZE_PARSER.parse(param[3]);
                    if (param.length == 5) {
                        tempDir = new File(param[4]);
                    } else if (!Transform.ensureNumArgs(param, 4)) {
                        return;
                    }
                } else if (!Transform.ensureNumArgs(param, 3)) {
                    return;
                }
            } else if (!Transform.ensureNumArgs(param, 2)) {
                return;
            }
        } else if (transform.equals("arcfilter")) {
            if (!Transform.ensureNumArgs(param, 3)) return;
            try {
                arcFilter = (ArcFilter)Transform.class.getField(param[2]).get(null);
            }
            catch (NoSuchFieldException e) {
                arcFilter = (ArcFilter)ObjectParser.fromSpec((String)param[2], ArcFilter.class, (String[])GraphClassParser.PACKAGE);
            }
            source = new String[]{param[0], null};
            dest = param[1];
        } else if (transform.equals("larcfilter")) {
            if (!Transform.ensureNumArgs(param, 3)) return;
            try {
                labelledArcFilter = (LabelledArcFilter)Transform.class.getField(param[2]).get(null);
            }
            catch (NoSuchFieldException e) {
                labelledArcFilter = (LabelledArcFilter)ObjectParser.fromSpec((String)param[2], LabelledArcFilter.class, (String[])GraphClassParser.PACKAGE);
            }
            source = new String[]{param[0], null};
            dest = param[1];
        } else if (transform.equals("union")) {
            if (!Transform.ensureNumArgs(param, -3)) {
                return;
            }
            source = new String[]{param[0], param[1]};
            dest = param[2];
            if (param.length == 4) {
                labelMergeStrategy = (LabelMergeStrategy)ObjectParser.fromSpec((String)param[3], LabelMergeStrategy.class, (String[])GraphClassParser.PACKAGE);
            } else if (!Transform.ensureNumArgs(param, 3)) {
                return;
            }
        } else if (transform.equals("compose")) {
            if (!Transform.ensureNumArgs(param, -3)) {
                return;
            }
            source = new String[]{param[0], param[1]};
            dest = param[2];
            if (param.length == 4) {
                labelSemiring = (LabelSemiring)ObjectParser.fromSpec((String)param[3], LabelSemiring.class, (String[])GraphClassParser.PACKAGE);
            } else if (!Transform.ensureNumArgs(param, 3)) {
                return;
            }
        } else if (transform.equals("simplify")) {
            if (!Transform.ensureNumArgs(param, 3)) {
                return;
            }
            source = new String[]{param[0], param[1]};
            dest = param[2];
        } else if (transform.equals("transposeOffline") || transform.equals("symmetrizeOffline") || transform.equals("simplifyOffline") || transform.equals("removeDangling") || transform.equals("gray") || transform.equals("lex")) {
            if (!Transform.ensureNumArgs(param, -2)) {
                return;
            }
            source = new String[]{param[0]};
            dest = param[1];
            if (param.length >= 3) {
                batchSize = (Integer)JSAP.INTSIZE_PARSER.parse(param[2]);
                if (param.length == 4) {
                    tempDir = new File(param[3]);
                } else if (!Transform.ensureNumArgs(param, 3)) {
                    return;
                }
            } else if (!Transform.ensureNumArgs(param, 2)) {
                return;
            }
        } else {
            System.err.println("Unknown transform: " + transform);
            return;
        }
        ProgressLogger pl = new ProgressLogger(LOGGER, jsapResult.getLong("logInterval"), TimeUnit.MILLISECONDS);
        ImmutableGraph[] graph = new ImmutableGraph[source.length];
        Class destLabelledGraphClass = jsapResult.getClass("destArcLabelledGraphClass");
        if (!ArcLabelledImmutableGraph.class.isAssignableFrom(destLabelledGraphClass)) {
            throw new IllegalArgumentException("The arc-labelled destination class " + destLabelledGraphClass.getName() + " is not an instance of ArcLabelledImmutableGraph");
        }
        for (int i = 0; i < source.length; ++i) {
            graph[i] = source[i] == null ? null : Transform.load(sourceGraphClass, source[i], offline && (i != 1 || !transform.equals("compose")), pl);
        }
        boolean graph0IsLabelled = graph[0] instanceof ArcLabelledImmutableGraph;
        ArcLabelledImmutableGraph graph0Labelled = graph0IsLabelled ? (ArcLabelledImmutableGraph)graph[0] : null;
        boolean graph1IsLabelled = graph.length > 1 && graph[1] instanceof ArcLabelledImmutableGraph;
        String notForLabelled = "This transformation will just apply to the unlabelled graph; label information will be absent";
        if (transform.equals("identity")) {
            result = graph[0];
        } else if (transform.equals("mapOffline")) {
            if (graph0IsLabelled) {
                LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
            }
            pl.start((CharSequence)"Reading map...");
            n = graph[0].numNodes();
            long[][] f = LongBigArrays.newBigArray((long)n);
            long loaded = ascii ? TextIO.loadLongs((CharSequence)map, (long[][])f) : BinIO.loadLongs((CharSequence)map, (long[][])f);
            if (n != loaded) {
                throw new IllegalArgumentException("The source graph has " + n + " nodes, but the permutation contains " + loaded + " longs");
            }
            if (cutoff != -1L) {
                int i = f.length;
                while (i-- != 0) {
                    long[] t = f[i];
                    int d = t.length;
                    while (d-- != 0) {
                        if (t[d] < cutoff) continue;
                        t[d] = -1L;
                    }
                }
            }
            pl.count = n;
            pl.done();
            result = Transform.mapOffline(graph[0], f, batchSize, tempDir, pl);
            LOGGER.info("Transform computation completed.");
        } else if (transform.equals("arcfilter")) {
            if (graph0IsLabelled && !(arcFilter instanceof LabelledArcFilter)) {
                LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
                result = Transform.filterArcs(graph[0], arcFilter, pl);
            } else {
                result = Transform.filterArcs(graph[0], arcFilter, pl);
            }
        } else if (transform.equals("larcfilter")) {
            if (!graph0IsLabelled) {
                throw new IllegalArgumentException("Filtering on labelled arcs requires a labelled graph");
            }
            result = Transform.filterArcs(graph0Labelled, labelledArcFilter, pl);
        } else if (transform.equals("symmetrizeOffline")) {
            if (graph0IsLabelled) {
                LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
            }
            result = Transform.symmetrizeOffline(graph[0], batchSize, tempDir, pl);
        } else if (transform.equals("simplifyOffline")) {
            if (graph0IsLabelled) {
                LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
            }
            result = Transform.simplifyOffline(graph[0], batchSize, tempDir, pl);
        } else if (transform.equals("removeDangling")) {
            if (graph0IsLabelled) {
                LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
            }
            n = graph[0].numNodes();
            LOGGER.info("Finding dangling nodes...");
            long[][] f = LongBigArrays.newBigArray((long)n);
            NodeIterator nodeIterator = graph[0].nodeIterator();
            int c = 0;
            for (long i = 0L; i < n; ++i) {
                nodeIterator.nextLong();
                BigArrays.set((long[][])f, (long)i, (long)(nodeIterator.outdegree() != 0L ? (long)c++ : -1L));
            }
            result = Transform.mapOffline(graph[0], f, batchSize, tempDir, pl);
        } else if (transform.equals("transposeOffline")) {
            result = graph0IsLabelled ? Transform.transposeOffline(graph0Labelled, batchSize, tempDir, pl) : Transform.transposeOffline(graph[0], batchSize, tempDir, pl);
        } else if (transform.equals("union")) {
            if (graph0IsLabelled && graph1IsLabelled) {
                if (labelMergeStrategy == null) {
                    throw new IllegalArgumentException("Uniting labelled graphs requires a merge strategy");
                }
                result = Transform.union(graph0Labelled, (ArcLabelledImmutableGraph)graph[1], labelMergeStrategy);
            } else {
                if (graph0IsLabelled || graph1IsLabelled) {
                    LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
                }
                result = Transform.union(graph[0], graph[1]);
            }
        } else if (transform.equals("compose")) {
            if (graph0IsLabelled && graph1IsLabelled) {
                if (labelSemiring == null) {
                    throw new IllegalArgumentException("Composing labelled graphs requires a composition strategy");
                }
                result = Transform.compose(graph0Labelled, (ArcLabelledImmutableGraph)graph[1], labelSemiring);
            } else {
                if (graph0IsLabelled || graph1IsLabelled) {
                    LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
                }
                result = Transform.compose(graph[0], graph[1]);
            }
        } else if (transform.equals("simplify")) {
            if (graph0IsLabelled || graph1IsLabelled) {
                LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
            }
            result = Transform.simplify(graph[0], graph[1]);
        } else if (transform.equals("gray")) {
            if (graph0IsLabelled) {
                LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
            }
            result = Transform.mapOffline(graph[0], Transform.grayCodePermutation(graph[0]), batchSize, tempDir, pl);
        } else {
            if (transform.equals("grayPerm")) {
                if (graph0IsLabelled) {
                    LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
                }
                BinIO.storeLongs((long[][])Transform.grayCodePermutation(graph[0]), (CharSequence)param[1]);
                return;
            }
            if (transform.equals("lex")) {
                if (graph0IsLabelled) {
                    LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
                }
                result = Transform.mapOffline(graph[0], Transform.lexicographicalPermutation(graph[0]), batchSize, tempDir, pl);
            } else {
                if (transform.equals("lexPerm")) {
                    if (graph0IsLabelled) {
                        LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
                    }
                    BinIO.storeLongs((long[][])Transform.lexicographicalPermutation(graph[0]), (CharSequence)param[1]);
                    return;
                }
                if (transform.equals("random")) {
                    if (graph0IsLabelled) {
                        LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
                    }
                    result = Transform.mapOffline(graph[0], Transform.randomPermutation(graph[0], seed), batchSize, tempDir, pl);
                } else {
                    result = null;
                }
            }
        }
        if (result instanceof ArcLabelledImmutableGraph) {
            LOGGER.info("The result is a labelled graph (class: " + destLabelledGraphClass.getName() + ")");
            File destFile = new File(dest);
            String underlyingName = (destFile.isAbsolute() ? dest : destFile.getName()) + "-underlying";
            destLabelledGraphClass.getMethod("store", ArcLabelledImmutableGraph.class, CharSequence.class, CharSequence.class, ProgressLogger.class).invoke(null, result, dest, underlyingName, pl);
            ImmutableGraph.store(destGraphClass, result, dest + "-underlying", pl);
            return;
        } else {
            ImmutableGraph.store(destGraphClass, result, dest, pl);
        }
    }

    public static interface ArcFilter {
        public boolean accept(long var1, long var3);
    }

    public static interface LabelledArcFilter {
        public boolean accept(long var1, long var3, Label var5);
    }

    private static final class FilteredImmutableGraph
    extends ImmutableGraph {
        private final ArcFilter filter;
        private final ImmutableGraph graph;
        private long[][] succ;
        private long currentNode = -1L;

        private FilteredImmutableGraph(ArcFilter filter, ImmutableGraph graph) {
            this.filter = filter;
            this.graph = graph;
        }

        @Override
        public long numNodes() {
            return this.graph.numNodes();
        }

        @Override
        public FilteredImmutableGraph copy() {
            return new FilteredImmutableGraph(this.filter, this.graph.copy());
        }

        @Override
        public boolean randomAccess() {
            return this.graph.randomAccess();
        }

        @Override
        public boolean hasCopiableIterators() {
            return this.graph.hasCopiableIterators();
        }

        @Override
        public LazyLongIterator successors(final long x) {
            return new AbstractLazyLongIterator(){
                private final LazyLongIterator succ;
                {
                    this.succ = graph.successors(x);
                }

                @Override
                public long nextLong() {
                    long t;
                    while ((t = this.succ.nextLong()) != -1L) {
                        if (!filter.accept(x, t)) continue;
                        return t;
                    }
                    return -1L;
                }
            };
        }

        @Override
        public long[][] successorBigArray(long x) {
            if (this.currentNode != x) {
                this.succ = LazyLongIterators.unwrap(this.successors(x));
                this.currentNode = x;
            }
            return this.succ;
        }

        @Override
        public long outdegree(long x) {
            if (this.currentNode != x) {
                this.succ = this.successorBigArray(x);
                this.currentNode = x;
            }
            return BigArrays.length((long[][])this.succ);
        }

        @Override
        public NodeIterator nodeIterator() {
            return new FilteredImmutableGraphNodeIterator(this.graph.nodeIterator());
        }

        @Override
        public NodeIterator nodeIterator(long from) {
            return new FilteredImmutableGraphNodeIterator(this.graph.nodeIterator(from), from, -1L, LongBigArrays.EMPTY_BIG_ARRAY);
        }

        private final class FilteredImmutableGraphNodeIterator
        extends NodeIterator {
            private final NodeIterator nodeIterator;
            private final long nextNode;
            private long outdegree;
            private long[][] succ;

            public FilteredImmutableGraphNodeIterator(NodeIterator nodeIterator) {
                this(nodeIterator, 0L, -1L, LongBigArrays.EMPTY_BIG_ARRAY);
            }

            public FilteredImmutableGraphNodeIterator(NodeIterator nodeIterator, long nextNode, long outdegree, long[][] succ) {
                this.nodeIterator = nodeIterator;
                this.nextNode = nextNode;
                this.outdegree = outdegree;
                this.succ = succ;
            }

            @Override
            public long outdegree() {
                if (this.outdegree == -1L) {
                    throw new IllegalStateException();
                }
                return this.outdegree;
            }

            public long nextLong() {
                long currNode = this.nodeIterator.nextLong();
                long oldOutdegree = this.nodeIterator.outdegree();
                LazyLongIterator oldSucc = this.nodeIterator.successors();
                this.succ = BigArrays.ensureCapacity((long[][])this.succ, (long)oldOutdegree, (long)0L);
                this.outdegree = 0L;
                for (long i = 0L; i < oldOutdegree; ++i) {
                    long s = oldSucc.nextLong();
                    if (!FilteredImmutableGraph.this.filter.accept(currNode, s)) continue;
                    BigArrays.set((long[][])this.succ, (long)this.outdegree++, (long)s);
                }
                return currNode;
            }

            @Override
            public long[][] successorBigArray() {
                if (this.outdegree == -1L) {
                    throw new IllegalStateException();
                }
                return this.succ;
            }

            public boolean hasNext() {
                return this.nodeIterator.hasNext();
            }

            @Override
            public NodeIterator copy(long upperBound) {
                return new FilteredImmutableGraphNodeIterator(this.nodeIterator.copy(upperBound), this.nextNode, this.outdegree, BigArrays.copy((long[][])this.succ, (long)0L, (long)Math.max(0L, this.outdegree)));
            }
        }
    }

    private static final class FilteredArcLabelledImmutableGraph
    extends ArcLabelledImmutableGraph {
        private final LabelledArcFilter filter;
        private final ArcLabelledImmutableGraph graph;
        private long[][] succ;
        private Label[][] label;
        private long cachedNode = -1L;

        private FilteredArcLabelledImmutableGraph(LabelledArcFilter filter, ArcLabelledImmutableGraph graph) {
            this.filter = filter;
            this.graph = graph;
        }

        @Override
        public long numNodes() {
            return this.graph.numNodes();
        }

        @Override
        public ArcLabelledImmutableGraph copy() {
            return new FilteredArcLabelledImmutableGraph(this.filter, this.graph.copy());
        }

        @Override
        public boolean randomAccess() {
            return this.graph.randomAccess();
        }

        @Override
        public Label prototype() {
            return this.graph.prototype();
        }

        private void fillCache(long x) {
            if (x == this.cachedNode) {
                return;
            }
            this.cachedNode = x;
            this.succ = LazyLongIterators.unwrap(this.successors(x));
            this.label = super.labelBigArray(x);
        }

        @Override
        public ArcLabelledNodeIterator.LabelledArcIterator successors(long x) {
            return new FilteredLabelledArcIterator(x, this.graph.successors(x));
        }

        @Override
        public long[][] successorBigArray(long x) {
            this.fillCache(x);
            return this.succ;
        }

        @Override
        public Label[][] labelBigArray(long x) {
            this.fillCache(x);
            return this.label;
        }

        @Override
        public long outdegree(long x) {
            this.fillCache(x);
            return BigArrays.length((long[][])this.succ);
        }

        @Override
        public ArcLabelledNodeIterator nodeIterator() {
            return new FilteredArcLabelledNodeIterator(Long.MAX_VALUE);
        }

        private final class FilteredLabelledArcIterator
        extends AbstractLazyLongIterator
        implements ArcLabelledNodeIterator.LabelledArcIterator {
            private final long x;
            private final ArcLabelledNodeIterator.LabelledArcIterator successors;

            private FilteredLabelledArcIterator(long x, ArcLabelledNodeIterator.LabelledArcIterator successors) {
                this.x = x;
                this.successors = successors;
            }

            @Override
            public long nextLong() {
                long t;
                while ((t = this.successors.nextLong()) != -1L) {
                    if (!FilteredArcLabelledImmutableGraph.this.filter.accept(this.x, t, this.successors.label())) continue;
                    return t;
                }
                return -1L;
            }

            @Override
            public Label label() {
                return this.successors.label();
            }
        }

        private final class FilteredArcLabelledNodeIterator
        extends ArcLabelledNodeIterator {
            private final ArcLabelledNodeIterator nodeIterator;
            private final long upperBound;
            private long currNode;
            private long outdegree;

            public FilteredArcLabelledNodeIterator(long upperBound) {
                this(upperBound, filteredArcLabelledImmutableGraph.graph.nodeIterator(), -1L, -1L);
            }

            public FilteredArcLabelledNodeIterator(long upperBound, ArcLabelledNodeIterator nodeIterator, long currNode, long outdegree) {
                this.upperBound = upperBound;
                this.nodeIterator = nodeIterator;
                this.currNode = currNode;
                this.outdegree = outdegree;
            }

            @Override
            public long outdegree() {
                if (this.currNode == -1L) {
                    throw new IllegalStateException();
                }
                if (this.outdegree == -1L) {
                    long d = 0L;
                    ArcLabelledNodeIterator.LabelledArcIterator successors = this.successors();
                    while (successors.nextLong() != -1L) {
                        ++d;
                    }
                    this.outdegree = d;
                }
                return this.outdegree;
            }

            public long nextLong() {
                this.outdegree = -1L;
                this.currNode = this.nodeIterator.nextLong();
                return this.currNode;
            }

            public boolean hasNext() {
                return this.currNode + 1L < this.upperBound && this.nodeIterator.hasNext();
            }

            @Override
            public ArcLabelledNodeIterator.LabelledArcIterator successors() {
                return new FilteredLabelledArcIterator(this.currNode, this.nodeIterator.successors());
            }

            @Override
            public ArcLabelledNodeIterator copy(long upperBound) {
                return new FilteredArcLabelledNodeIterator(upperBound, this.nodeIterator.copy(upperBound), this.currNode, this.outdegree);
            }
        }
    }

    private static final class NoLoops
    implements ArcFilter,
    LabelledArcFilter {
        private NoLoops() {
        }

        @Override
        public boolean accept(long i, long j) {
            return i != j;
        }

        @Override
        public boolean accept(long i, long j, Label label) {
            return i != j;
        }
    }

    public static final class BatchGraph
    extends ImmutableSequentialGraph {
        private final ObjectArrayList<File> batches;
        private final long n;
        private final long numArcs;

        public BatchGraph(long n, long m, ObjectArrayList<File> batches) {
            this.batches = batches;
            this.n = n;
            this.numArcs = m;
        }

        @Override
        public long numNodes() {
            return this.n;
        }

        @Override
        public long numArcs() {
            if (this.numArcs == -1L) {
                throw new UnsupportedOperationException();
            }
            return this.numArcs;
        }

        @Override
        public boolean hasCopiableIterators() {
            return true;
        }

        @Override
        public BatchGraph copy() {
            return this;
        }

        @Override
        public NodeIterator nodeIterator() {
            try {
                return new BatchGraphNodeIterator(this.n, this.batches, this.n);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected void finalize() throws Throwable {
            try {
                for (File f : this.batches) {
                    f.delete();
                }
            }
            finally {
                super.finalize();
            }
        }

        private final class BatchGraphNodeIterator
        extends NodeIterator {
            private static final int STD_BUFFER_SIZE = 131072;
            private final LongHeapSemiIndirectPriorityQueue queue;
            private final long[] refArray;
            private final InputBitStream[] batchIbs;
            private final int[] inputStreamLength;
            private final long hasNextLimit;
            private final long[] prevTarget;
            private long last;
            private long outdegree;
            private long numPairs;
            private long[][] successor = LongBigArrays.EMPTY_BIG_ARRAY;
            private final ObjectArrayList<File> batches;
            private final long n;

            private BatchGraphNodeIterator(long n, ObjectArrayList<File> batches, long upperBound) throws IOException {
                this(n, batches, upperBound, null, null, null, null, -1L, -1L, LongBigArrays.EMPTY_BIG_ARRAY);
            }

            private BatchGraphNodeIterator(long n, ObjectArrayList<File> batches, long upperBound, InputBitStream[] baseIbs, long[] refArray, long[] prevTarget, int[] inputStreamLength, long last, long outdegree, long[][] successor) throws IOException {
                this.n = n;
                this.batches = batches;
                this.hasNextLimit = Math.min(n, upperBound) - 1L;
                this.last = last;
                this.outdegree = outdegree;
                this.successor = successor;
                this.batchIbs = new InputBitStream[batches.size()];
                if (refArray == null) {
                    this.refArray = new long[batches.size()];
                    this.prevTarget = new long[batches.size()];
                    this.inputStreamLength = new int[batches.size()];
                    java.util.Arrays.fill(this.prevTarget, -1L);
                    this.queue = new LongHeapSemiIndirectPriorityQueue(this.refArray);
                    for (int i = 0; i < batches.size(); ++i) {
                        this.batchIbs[i] = new InputBitStream((File)batches.get(i), 131072);
                        this.inputStreamLength[i] = this.batchIbs[i].readDelta();
                        this.refArray[i] = this.batchIbs[i].readLongDelta();
                        this.queue.enqueue(i);
                    }
                } else {
                    this.refArray = refArray;
                    this.prevTarget = prevTarget;
                    this.inputStreamLength = inputStreamLength;
                    this.queue = new LongHeapSemiIndirectPriorityQueue(refArray);
                    for (int i = 0; i < refArray.length; ++i) {
                        if (baseIbs[i] == null) continue;
                        this.batchIbs[i] = new InputBitStream((File)batches.get(i), 131072);
                        this.batchIbs[i].position(baseIbs[i].position());
                        this.queue.enqueue(i);
                    }
                }
            }

            @Override
            public NodeIterator copy(long upperBound) {
                try {
                    if (this.last == -1L) {
                        return new BatchGraphNodeIterator(this.n, this.batches, upperBound);
                    }
                    return new BatchGraphNodeIterator(this.n, this.batches, upperBound, this.batchIbs, (long[])this.refArray.clone(), (long[])this.prevTarget.clone(), (int[])this.inputStreamLength.clone(), this.last, this.outdegree(), BigArrays.copy((long[][])this.successor, (long)0L, (long)this.outdegree()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }

            @Override
            public long outdegree() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                if (this.outdegree == -1L) {
                    this.successorBigArray();
                }
                return this.outdegree;
            }

            public boolean hasNext() {
                return this.last < this.hasNextLimit;
            }

            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.last;
                long d = 0L;
                this.outdegree = -1L;
                try {
                    int i;
                    while (!this.queue.isEmpty() && this.refArray[i = this.queue.first()] == this.last) {
                        this.successor = BigArrays.grow((long[][])this.successor, (long)(d + 1L));
                        int n = i;
                        long l = this.prevTarget[n] + (this.batchIbs[i].readLongDelta() + 1L);
                        this.prevTarget[n] = l;
                        BigArrays.set((long[][])this.successor, (long)d, (long)l);
                        int n2 = i;
                        this.inputStreamLength[n2] = this.inputStreamLength[n2] - 1;
                        if (this.inputStreamLength[n2] == 0) {
                            this.queue.dequeue();
                            this.batchIbs[i].close();
                            this.batchIbs[i] = null;
                        } else {
                            long sourceDelta = this.batchIbs[i].readLongDelta();
                            if (sourceDelta != 0L) {
                                int n3 = i;
                                this.refArray[n3] = this.refArray[n3] + sourceDelta;
                                this.prevTarget[i] = -1L;
                                this.queue.changed();
                            }
                        }
                        ++d;
                    }
                    this.numPairs = d;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return this.last;
            }

            @Override
            public long[][] successorBigArray() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                if (this.outdegree == -1L) {
                    long numPairs = this.numPairs;
                    LongBigArrays.quickSort((long[][])this.successor, (long)0L, (long)numPairs);
                    if (numPairs != 0L) {
                        long p = 0L;
                        long pSuccessor = BigArrays.get((long[][])this.successor, (long)p);
                        for (long j = 1L; j < numPairs; ++j) {
                            long s = BigArrays.get((long[][])this.successor, (long)j);
                            if (pSuccessor == s) continue;
                            BigArrays.set((long[][])this.successor, (long)(++p), (long)s);
                            pSuccessor = s;
                        }
                        this.outdegree = p + 1L;
                    } else {
                        this.outdegree = 0L;
                    }
                }
                return this.successor;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() throws Throwable {
                try {
                    for (InputBitStream ibs : this.batchIbs) {
                        if (ibs == null) continue;
                        ibs.close();
                    }
                }
                finally {
                    super.finalize();
                }
            }
        }
    }

    private static final class ComposedGraph
    extends ImmutableSequentialGraph {
        private final ImmutableGraph g0;
        private final ImmutableGraph g1;

        private ComposedGraph(ImmutableGraph g0, ImmutableGraph g1) {
            this.g0 = g0;
            this.g1 = g1;
        }

        @Override
        public long numNodes() {
            return Math.max(this.g0.numNodes(), this.g1.numNodes());
        }

        @Override
        public ImmutableSequentialGraph copy() {
            return new ComposedGraph(this.g0, this.g1.copy());
        }

        @Override
        public boolean hasCopiableIterators() {
            return true;
        }

        @Override
        public NodeIterator nodeIterator() {
            return new ComposedGraphNodeIterator(Long.MAX_VALUE);
        }

        private final class ComposedGraphNodeIterator
        extends NodeIterator {
            private final NodeIterator it0;
            private final long upperBound;
            private long[][] succ;
            private final LongOpenHashSet successors;
            private long outdegree;
            private long nextNode;

            public ComposedGraphNodeIterator(long upperBound) {
                this(upperBound, composedGraph.g0.nodeIterator(), LongBigArrays.EMPTY_BIG_ARRAY, new LongOpenHashSet(16, 0.5f), -1L, 0L);
            }

            public ComposedGraphNodeIterator(long upperBound, NodeIterator it, long[][] succ, LongOpenHashSet successors, long outdegree, long nextNode) {
                this.it0 = it;
                this.upperBound = upperBound;
                this.succ = succ;
                this.successors = successors;
                this.outdegree = outdegree;
                this.nextNode = nextNode;
            }

            public long nextLong() {
                this.outdegree = -1L;
                ++this.nextNode;
                return this.it0.nextLong();
            }

            public boolean hasNext() {
                return this.nextNode < this.upperBound && this.it0.hasNext();
            }

            @Override
            public long outdegree() {
                if (this.outdegree < 0L) {
                    this.successorBigArray();
                }
                return this.outdegree;
            }

            @Override
            public long[][] successorBigArray() {
                if (this.outdegree < 0L) {
                    long d = this.it0.outdegree();
                    long[][] s = this.it0.successorBigArray();
                    this.successors.clear();
                    for (long i = 0L; i < d; ++i) {
                        long x;
                        LazyLongIterator s1 = ComposedGraph.this.g1.successors(BigArrays.get((long[][])s, (long)i));
                        while ((x = s1.nextLong()) >= 0L) {
                            this.successors.add(x);
                        }
                    }
                    this.outdegree = this.successors.size();
                    this.succ = BigArrays.ensureCapacity((long[][])this.succ, (long)this.outdegree, (long)0L);
                    this.succ = LongBigArrays.newBigArray((long)this.outdegree);
                    LongIterator iterator = this.successors.iterator();
                    for (long i = 0L; i < this.outdegree; ++i) {
                        BigArrays.set((long[][])this.succ, (long)i, (long)iterator.nextLong());
                    }
                    LongBigArrays.quickSort((long[][])this.succ, (long)0L, (long)this.outdegree);
                }
                return this.succ;
            }

            @Override
            public NodeIterator copy(long upperBound) {
                return new ComposedGraphNodeIterator(upperBound, this.it0.copy(Long.MAX_VALUE), BigArrays.copy((long[][])this.succ, (long)0L, (long)this.outdegree), new LongOpenHashSet((LongCollection)this.successors), this.outdegree, this.nextNode);
            }
        }
    }

    public static final class LowerBound
    implements LabelledArcFilter {
        private final int lowerBound;

        public LowerBound(int lowerBound) {
            this.lowerBound = lowerBound;
        }

        public LowerBound(String lowerBound) {
            this(Integer.parseInt(lowerBound));
        }

        @Override
        public boolean accept(long i, long j, Label label) {
            return label.getInt() >= this.lowerBound;
        }
    }

    public static final class NodeClassFilter
    implements ArcFilter,
    LabelledArcFilter {
        private final boolean keepOnlySame;
        private final long[][] nodeClass;

        public NodeClassFilter(String classFile, boolean keepOnlySame) {
            try {
                this.nodeClass = BinIO.loadLongsBig((CharSequence)classFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.keepOnlySame = keepOnlySame;
        }

        public NodeClassFilter(String classFile, String keepOnlySame) {
            this(classFile, Boolean.parseBoolean(keepOnlySame));
        }

        @Override
        public boolean accept(long i, long j) {
            return this.keepOnlySame == (BigArrays.get((long[][])this.nodeClass, (long)i) == BigArrays.get((long[][])this.nodeClass, (long)j));
        }

        @Override
        public boolean accept(long i, long j, Label label) {
            return this.keepOnlySame == (BigArrays.get((long[][])this.nodeClass, (long)i) == BigArrays.get((long[][])this.nodeClass, (long)j));
        }
    }
}

