/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph.labelling;

import it.unimi.dsi.big.webgraph.labelling.AbstractIntLabel;
import it.unimi.dsi.big.webgraph.labelling.Label;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import java.io.IOException;

public class FixedWidthIntLabel
extends AbstractIntLabel {
    protected final int width;

    public FixedWidthIntLabel(String key, int width, int value) {
        super(key, value);
        if (width < 0 || width > 31) {
            throw new IllegalArgumentException("Width out of range: " + width);
        }
        if (value < 0 || (long)value >= 1L << width) {
            throw new IllegalArgumentException("Value out of range: " + Integer.toString(value));
        }
        this.width = width;
    }

    public FixedWidthIntLabel(String key, int width) {
        this(key, width, 0);
    }

    public FixedWidthIntLabel(String ... arg) {
        this(arg[0], Integer.parseInt(arg[1]));
    }

    @Override
    public Label copy() {
        return new FixedWidthIntLabel(this.key, this.width, this.value);
    }

    @Override
    public int fromBitStream(InputBitStream inputBitStream, long sourceUnused) throws IOException {
        this.value = inputBitStream.readInt(this.width);
        return this.width;
    }

    @Override
    public int toBitStream(OutputBitStream outputBitStream, long sourceUnused) throws IOException {
        return outputBitStream.writeInt(this.value, this.width);
    }

    @Override
    public int fixedWidth() {
        return this.width;
    }

    @Override
    public String toString() {
        return this.key + ":" + this.value + " (width:" + this.width + ")";
    }

    @Override
    public String toSpec() {
        return this.getClass().getName() + "(" + this.key + "," + this.width + ")";
    }
}

