/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph.labelling;

import it.unimi.dsi.big.webgraph.labelling.AbstractLongListLabel;
import it.unimi.dsi.big.webgraph.labelling.Label;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import java.io.IOException;
import java.util.Arrays;

public class FixedWidthLongListLabel
extends AbstractLongListLabel {
    private final int width;

    public FixedWidthLongListLabel(String key, int width, long[] value) {
        super(key, value);
        if (width < 0 || width > 63) {
            throw new IllegalArgumentException("Width out of range: " + width);
        }
        int i = value.length;
        while (i-- != 0) {
            if (value[i] >= 0L && value[i] < 1L << width) continue;
            throw new IllegalArgumentException("Value out of range: " + Long.toString(value[i]));
        }
        this.width = width;
    }

    public FixedWidthLongListLabel(String key, int width) {
        this(key, width, LongArrays.EMPTY_ARRAY);
    }

    public FixedWidthLongListLabel(String ... arg) {
        this(arg[0], Integer.parseInt(arg[1]));
    }

    @Override
    public Label copy() {
        return new FixedWidthLongListLabel(this.key, this.width, (long[])this.value.clone());
    }

    @Override
    public int fromBitStream(InputBitStream inputBitStream, long sourceUnused) throws IOException {
        long readBits = inputBitStream.readBits();
        this.value = new long[inputBitStream.readGamma()];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = inputBitStream.readLong(this.width);
        }
        return (int)(inputBitStream.readBits() - readBits);
    }

    @Override
    public int toBitStream(OutputBitStream outputBitStream, long sourceUnused) throws IOException {
        int bits = outputBitStream.writeGamma(this.value.length);
        for (int i = 0; i < this.value.length; ++i) {
            bits += outputBitStream.writeLong(this.value[i], this.width);
        }
        return bits;
    }

    @Override
    public int fixedWidth() {
        return -1;
    }

    @Override
    public String toString() {
        return this.key + ":" + Arrays.toString(this.value) + " (width:" + this.width + ")";
    }

    @Override
    public String toSpec() {
        return this.getClass().getName() + "(" + this.key + "," + this.width + ")";
    }
}

