/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.GraphClassParser;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.Transform;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Check {
    private static final Logger LOGGER = LoggerFactory.getLogger(Check.class);

    private Check() {
    }

    public static boolean symmetry(ImmutableGraph graph) {
        return Check.symmetry(graph, null);
    }

    public static boolean symmetry(ImmutableGraph graph, ProgressLogger pl) {
        return graph.equals(Transform.transpose(graph, pl));
    }

    public static boolean symmetryOffline(ImmutableGraph graph, int batchSize) throws IOException {
        return Check.symmetryOffline(graph, batchSize, null);
    }

    public static boolean symmetryOffline(ImmutableGraph graph, int batchSize, File tempDir) throws IOException {
        return Check.symmetryOffline(graph, batchSize, tempDir, null);
    }

    public static boolean symmetryOffline(ImmutableGraph graph, int batchSize, File tempDir, ProgressLogger pl) throws IOException {
        return graph.equals(Transform.transposeOffline(graph, batchSize, tempDir, pl));
    }

    public static void main(String[] args) throws IOException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, JSAPException {
        Class graphClass = null;
        boolean offline = false;
        SimpleJSAP jsap = new SimpleJSAP(Check.class.getName(), "Checks properties of a graph. All checks require, after the name,\nsome parameters specified below:\n\nsymmetry             sourceBasename\nsymmetryOffline      sourceBasename [batchSize] [tempDir]\n\nPlease consult the Javadoc documentation for more information on each check.", new Parameter[]{new FlaggedOption("graphClass", (StringParser)GraphClassParser.getParser(), JSAP.NO_DEFAULT, false, 'g', "graph-class", "Forces a Java class to load the graph."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new Switch("offline", 'o', "offline", "Use the offline load method to reduce memory consumption."), new Switch("sequential", 'S', "sequential", "Equivalent to offline."), new UnflaggedOption("check", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The check."), new UnflaggedOption("param", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, true, "The remaining parameters.")});
        JSAPResult jsapResult = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        graphClass = jsapResult.getClass("graphClass");
        offline = jsapResult.getBoolean("offline") || jsapResult.getBoolean("sequential");
        String check = jsapResult.getString("check");
        String[] param = jsapResult.getStringArray("param");
        String[] source = null;
        int batchSize = 1000000;
        File tempDir = null;
        if (!Transform.ensureNumArgs(param, -1)) {
            return;
        }
        if (check.equals("symmetry")) {
            if (!Transform.ensureNumArgs(param, 1)) {
                return;
            }
            source = new String[]{param[0]};
        } else if (check.equals("symmetryOffline")) {
            source = new String[]{param[0]};
            if (param.length >= 2) {
                batchSize = (Integer)JSAP.INTSIZE_PARSER.parse(param[1]);
                if (param.length == 3) {
                    tempDir = new File(param[2]);
                } else if (!Transform.ensureNumArgs(param, 2)) {
                    return;
                }
            } else if (!Transform.ensureNumArgs(param, 1)) {
                return;
            }
        } else {
            System.err.println("Unknown check: " + check);
            return;
        }
        ProgressLogger pl = new ProgressLogger(LOGGER, jsapResult.getLong("logInterval"), TimeUnit.MILLISECONDS);
        ImmutableGraph[] graph = new ImmutableGraph[source.length];
        for (int i = 0; i < source.length; ++i) {
            graph[i] = source[i] == null ? null : Transform.load(graphClass, source[i], offline, pl);
        }
        if (check.equals("symmetry")) {
            System.out.println(Check.symmetry(graph[0], pl));
        } else if (check.equals("symmetryOffline")) {
            System.out.println(Check.symmetryOffline(graph[0], batchSize, tempDir, pl));
        }
    }
}

