/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.algo;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.ArrayListMutableGraph;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometricCentralities {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeometricCentralities.class);
    public static final double DEFAULT_ALPHA = 0.5;
    private final ImmutableGraph graph;
    public final double[] harmonic;
    public final double[] closeness;
    public final double[] lin;
    public final double[] exponential;
    public double alpha;
    public final long[] reachable;
    private final ProgressLogger pl;
    private final int numberOfThreads;
    protected final AtomicInteger nextNode;
    protected volatile boolean stop;

    public GeometricCentralities(ImmutableGraph graph, int requestedThreads, ProgressLogger pl) {
        this.pl = pl;
        this.graph = graph;
        this.harmonic = new double[graph.numNodes()];
        this.closeness = new double[graph.numNodes()];
        this.reachable = new long[graph.numNodes()];
        this.exponential = new double[graph.numNodes()];
        this.alpha = 0.5;
        this.lin = new double[graph.numNodes()];
        this.nextNode = new AtomicInteger();
        this.numberOfThreads = requestedThreads != 0 ? requestedThreads : Runtime.getRuntime().availableProcessors();
    }

    public GeometricCentralities(ImmutableGraph graph, ProgressLogger pl) {
        this(graph, 0, pl);
    }

    public GeometricCentralities(ImmutableGraph graph, int requestedThreads) {
        this(graph, 1, null);
    }

    public GeometricCentralities(ImmutableGraph graph) {
        this(graph, 0);
    }

    public void compute() throws InterruptedException {
        IterationThread[] thread = new IterationThread[this.numberOfThreads];
        for (int i = 0; i < thread.length; ++i) {
            thread[i] = new IterationThread();
        }
        if (this.pl != null) {
            this.pl.start((CharSequence)"Starting visits...");
            this.pl.expectedUpdates = this.graph.numNodes();
            this.pl.itemsName = "nodes";
        }
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(executorService);
        int i = thread.length;
        while (i-- != 0) {
            executorCompletionService.submit(thread[i]);
        }
        try {
            i = thread.length;
            while (i-- != 0) {
                executorCompletionService.take().get();
            }
        }
        catch (ExecutionException e) {
            this.stop = true;
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause.getMessage(), cause);
        }
        finally {
            executorService.shutdown();
        }
        if (this.pl != null) {
            this.pl.done();
        }
    }

    public static void main(String[] arg) throws IOException, JSAPException, InterruptedException {
        ImmutableGraph graph;
        SimpleJSAP jsap = new SimpleJSAP(GeometricCentralities.class.getName(), "Computes positive centralities of a graph using multiple parallel breadth-first visits.\n\nPlease note that to compute negative centralities on directed graphs (which is usually what you want) you have to compute positive centralities on the transpose.", new Parameter[]{new Switch("expand", 'e', "expand", "Expand the graph to increase speed (no compression)."), new Switch("mapped", 'm', "mapped", "Use loadMapped() to load the graph."), new FlaggedOption("threads", (StringParser)JSAP.INTSIZE_PARSER, "0", false, 'T', "threads", "The number of threads to be used. If 0, the number will be estimated automatically."), new UnflaggedOption("graphBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the graph."), new UnflaggedOption("closenessFilename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename where closeness centrality scores (doubles in binary form) will be stored."), new UnflaggedOption("linFilename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename where Lin's centrality scores (doubles in binary form) will be stored."), new UnflaggedOption("harmonicFilename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename where harmonic centrality scores (doubles in binary form) will be stored."), new UnflaggedOption("exponentialFilename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename where exponential centrality scores (doubles in binary form) will be stored."), new UnflaggedOption("reachableFilename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename where the number of reachable nodes (longs in binary form) will be stored.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        boolean mapped = jsapResult.getBoolean("mapped", false);
        String graphBasename = jsapResult.getString("graphBasename");
        int threads = jsapResult.getInt("threads");
        ProgressLogger progressLogger = new ProgressLogger(LOGGER, "nodes");
        progressLogger.displayFreeMemory = true;
        progressLogger.displayLocalSpeed = true;
        ImmutableGraph immutableGraph = graph = mapped ? ImmutableGraph.loadMapped(graphBasename, progressLogger) : ImmutableGraph.load(graphBasename, progressLogger);
        if (jsapResult.userSpecified("expand")) {
            graph = new ArrayListMutableGraph(graph).immutableView();
        }
        GeometricCentralities centralities = new GeometricCentralities(graph, threads, progressLogger);
        centralities.compute();
        BinIO.storeDoubles((double[])centralities.closeness, (CharSequence)jsapResult.getString("closenessFilename"));
        BinIO.storeDoubles((double[])centralities.lin, (CharSequence)jsapResult.getString("linFilename"));
        BinIO.storeDoubles((double[])centralities.harmonic, (CharSequence)jsapResult.getString("harmonicFilename"));
        BinIO.storeDoubles((double[])centralities.exponential, (CharSequence)jsapResult.getString("exponentialFilename"));
        BinIO.storeLongs((long[])centralities.reachable, (CharSequence)jsapResult.getString("reachableFilename"));
    }

    private final class IterationThread
    implements Callable<Void> {
        private final IntArrayFIFOQueue queue;
        private final int[] distance;

        private IterationThread() {
            this.distance = new int[GeometricCentralities.this.graph.numNodes()];
            this.queue = new IntArrayFIFOQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            int[] distance = this.distance;
            IntArrayFIFOQueue queue = this.queue;
            ImmutableGraph graph = GeometricCentralities.this.graph.copy();
            double base = GeometricCentralities.this.alpha;
            while (true) {
                int curr = GeometricCentralities.this.nextNode.getAndIncrement();
                if (GeometricCentralities.this.stop || curr >= graph.numNodes()) {
                    return null;
                }
                queue.clear();
                queue.enqueue(curr);
                Arrays.fill(distance, -1);
                distance[curr] = 0;
                int reachable = 0;
                while (!queue.isEmpty()) {
                    int s;
                    int node = queue.dequeueInt();
                    ++reachable;
                    int d = distance[node] + 1;
                    double hd = 1.0 / (double)d;
                    double ed = Math.pow(base, d);
                    LazyIntIterator successors = graph.successors(node);
                    while ((s = successors.nextInt()) != -1) {
                        if (distance[s] != -1) continue;
                        queue.enqueue(s);
                        distance[s] = d;
                        int n = curr;
                        GeometricCentralities.this.closeness[n] = GeometricCentralities.this.closeness[n] + (double)d;
                        int n2 = curr;
                        GeometricCentralities.this.harmonic[n2] = GeometricCentralities.this.harmonic[n2] + hd;
                        int n3 = curr;
                        GeometricCentralities.this.exponential[n3] = GeometricCentralities.this.exponential[n3] + ed;
                    }
                }
                if (GeometricCentralities.this.pl != null) {
                    ProgressLogger progressLogger = GeometricCentralities.this.pl;
                    synchronized (progressLogger) {
                        GeometricCentralities.this.pl.update();
                    }
                }
                if (GeometricCentralities.this.closeness[curr] == 0.0) {
                    GeometricCentralities.this.lin[curr] = 1.0;
                } else {
                    GeometricCentralities.this.closeness[curr] = 1.0 / GeometricCentralities.this.closeness[curr];
                    GeometricCentralities.this.lin[curr] = (double)reachable * (double)reachable * GeometricCentralities.this.closeness[curr];
                }
                GeometricCentralities.this.reachable[curr] = reachable;
            }
        }
    }
}

