/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.algo;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.lang.EnumStringParser;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.ArrayListMutableGraph;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import it.unimi.dsi.webgraph.Transform;
import it.unimi.dsi.webgraph.algo.ParallelBreadthFirstVisit;
import it.unimi.dsi.webgraph.algo.StronglyConnectedComponents;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SumSweepDirectedDiameterRadius {
    private static final boolean DEBUG = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(SumSweepDirectedDiameterRadius.class);
    private final ImmutableGraph graph;
    private final ImmutableGraph revgraph;
    private final int nn;
    private final ProgressLogger pl;
    private final OutputLevel output;
    private final int[] eccF;
    private final int[] eccB;
    private final boolean[] toCompleteF;
    private final boolean[] toCompleteB;
    private final boolean[] accRadial;
    private final int[] queue;
    private final int[] dist;
    private int dL;
    private int rU;
    private int dV;
    private int rV;
    private int iter;
    protected int[] lF;
    protected int[] uF;
    protected int[] lB;
    protected int[] uB;
    private int iterR;
    private int iterD;
    private int iterAllF;
    private int iterAll;
    private final StronglyConnectedComponents scc;
    private final int[][] sccGraph;
    private final int[][] startBridges;
    private final int[][] endBridges;
    private final int[] totDistF;
    private final int[] totDistB;

    public static int argMax(double[] vec) {
        double max = -1.7976931348623157E308;
        int argMax = -1;
        for (int i = 0; i < vec.length; ++i) {
            if (!(vec[i] > max)) continue;
            argMax = i;
            max = vec[i];
        }
        return argMax;
    }

    public static int argMax(int[] vec) {
        int max = Integer.MIN_VALUE;
        int argMax = -1;
        for (int i = 0; i < vec.length; ++i) {
            if (vec[i] <= max) continue;
            argMax = i;
            max = vec[i];
        }
        return argMax;
    }

    public static int argMax(int[] vec, int[] tieBreak, boolean[] acc) {
        int max = Integer.MIN_VALUE;
        int maxTieBreak = Integer.MIN_VALUE;
        int argMax = -1;
        for (int i = 0; i < vec.length; ++i) {
            if (!acc[i] || vec[i] <= max && (vec[i] != max || tieBreak[i] <= maxTieBreak)) continue;
            argMax = i;
            max = vec[i];
            maxTieBreak = tieBreak[i];
        }
        return argMax;
    }

    public static int argMin(int[] vec, int[] tieBreak, boolean[] acc) {
        int min = Integer.MAX_VALUE;
        int minTieBreak = Integer.MAX_VALUE;
        int argMin = -1;
        for (int i = 0; i < vec.length; ++i) {
            if (!acc[i] || vec[i] >= min && (vec[i] != min || tieBreak[i] >= minTieBreak)) continue;
            argMin = i;
            min = vec[i];
            minTieBreak = tieBreak[i];
        }
        return argMin;
    }

    public SumSweepDirectedDiameterRadius(ImmutableGraph graph, OutputLevel output, boolean[] accRadial, ProgressLogger pl) {
        this.pl = pl;
        this.graph = graph;
        this.revgraph = Transform.transpose(graph);
        this.nn = graph.numNodes();
        this.eccF = new int[this.nn];
        this.eccB = new int[this.nn];
        this.totDistF = new int[this.nn];
        this.totDistB = new int[this.nn];
        this.lF = new int[this.nn];
        this.lB = new int[this.nn];
        this.uF = new int[this.nn];
        this.uB = new int[this.nn];
        this.toCompleteF = new boolean[this.nn];
        this.toCompleteB = new boolean[this.nn];
        this.queue = new int[this.nn];
        this.dist = new int[this.nn];
        this.scc = StronglyConnectedComponents.compute(graph, false, null);
        this.startBridges = new int[this.scc.numberOfComponents][];
        this.endBridges = new int[this.scc.numberOfComponents][];
        this.sccGraph = new int[this.scc.numberOfComponents][];
        Arrays.fill(this.eccF, -1);
        Arrays.fill(this.eccB, -1);
        Arrays.fill(this.uF, this.nn + 1);
        Arrays.fill(this.uB, this.nn + 1);
        Arrays.fill(this.toCompleteF, true);
        Arrays.fill(this.toCompleteB, true);
        this.dL = 0;
        this.rU = Integer.MAX_VALUE;
        this.output = output;
        this.iterR = -1;
        this.iterD = -1;
        this.iterAllF = -1;
        this.iterAll = -1;
        if (accRadial == null) {
            this.accRadial = new boolean[this.nn];
            this.computeAccRadial();
        } else {
            if (accRadial.length != this.nn) {
                throw new IllegalArgumentException("The size of the array of acceptable vertices must be equal to the number of nodes in the graph.");
            }
            this.accRadial = accRadial;
        }
        this.findEdgesThroughSCC();
    }

    public int getRadius() {
        if (this.iterR == -1) {
            throw new UnsupportedOperationException("The radius has not beencomputed, yet. Please, run the compute method withthe correct output.");
        }
        return this.rU;
    }

    public int getDiameter() {
        if (this.iterD == -1) {
            throw new UnsupportedOperationException("The diameter has not beencomputed, yet. Please, run the compute method withthe correct output.");
        }
        return this.dL;
    }

    public int getRadialVertex() {
        if (this.iterR == -1) {
            throw new UnsupportedOperationException("The radius has not beencomputed, yet. Please, run the compute method withthe correct output.");
        }
        return this.rV;
    }

    public int getDiametralVertex() {
        if (this.iterD == -1) {
            throw new UnsupportedOperationException("The radius has not beencomputed, yet. Please, run the compute method withthe correct output.");
        }
        return this.dV;
    }

    public int getEccentricity(int v, boolean forward) {
        int ecc;
        int n = ecc = forward ? this.eccF[v] : this.eccB[v];
        if (ecc == -1) {
            throw new UnsupportedOperationException("The eccentricity of v has not beencomputed, yet. Please, use the compute method withthe correct output.");
        }
        return ecc;
    }

    public int getRadiusIterations() {
        if (this.iterR == -1) {
            throw new UnsupportedOperationException("The radius has not been computed, yet. Please, run the compute method with the correct output.");
        }
        return this.iterR;
    }

    public int getDiameterIterations() {
        if (this.iterD == -1) {
            throw new UnsupportedOperationException("The diameter has not been computed, yet. Please, run the compute method with the correct output.");
        }
        return this.iterD;
    }

    public int getAllForwardIterations() {
        if (this.iterAllF == -1) {
            throw new UnsupportedOperationException("All forward eccentricities have not been  computed, yet. Please, run the compute method with the correct output.");
        }
        return this.iterAllF;
    }

    public int getAllIterations() {
        if (this.iterAll == -1) {
            throw new UnsupportedOperationException("All eccentricities have not been  computed, yet. Please, run the compute method with the correct output.");
        }
        return this.iterAll;
    }

    private int[] findBestPivot() {
        int[] lF = this.lF;
        int[] lB = this.lB;
        int[] totDistF = this.totDistF;
        int[] totDistB = this.totDistB;
        int nn = this.nn;
        boolean[] toCompleteF = this.toCompleteF;
        boolean[] toCompleteB = this.toCompleteB;
        int[] pivot = new int[this.scc.numberOfComponents];
        Arrays.fill(pivot, -1);
        int[] sccs = this.scc.component;
        for (int v = nn - 1; v >= 0; --v) {
            long best;
            int p = pivot[sccs[v]];
            if (p == -1) {
                pivot[sccs[v]] = v;
                continue;
            }
            long current = (long)lF[v] + (long)lB[v] + (long)((toCompleteF[v] ? 0 : 1) * nn) + (long)((toCompleteB[v] ? 0 : 1) * nn);
            if (current >= (best = (long)lF[p] + (long)lB[p] + (long)((toCompleteF[p] ? 0 : 1) * nn) + (long)((toCompleteB[p] ? 0 : 1) * nn)) && (current != best || totDistF[v] + totDistB[v] > totDistF[p] + totDistB[p])) continue;
            pivot[sccs[v]] = v;
        }
        return pivot;
    }

    private void computeAccRadial() {
        if (this.nn == 0) {
            return;
        }
        boolean[] accRadial = this.accRadial;
        int[] sccs = this.scc.component;
        int[] sccSizes = this.scc.computeSizes();
        int maxSizeSCC = SumSweepDirectedDiameterRadius.argMax(sccSizes);
        int v = 0;
        v = this.nn;
        while (v-- > 0 && sccs[v] != maxSizeSCC) {
        }
        ParallelBreadthFirstVisit bfs = new ParallelBreadthFirstVisit(this.revgraph, 0, false, null);
        bfs.visit(v);
        int i = this.nn;
        while (i-- > 0) {
            accRadial[i] = bfs.marker.get(i) >= 0;
        }
    }

    private void stepSumSweep(int start, boolean forward) {
        int eccStart;
        int v;
        boolean[] toCompleteOther;
        boolean[] toComplete;
        int[] eccOther;
        int[] ecc;
        ImmutableGraph g;
        int[] totDistOther;
        int[] uOther;
        int[] u;
        int[] lOther;
        int[] l;
        if (start == -1) {
            return;
        }
        int[] queue = this.queue;
        int[] dist = this.dist;
        int startQ = 0;
        int endQ = 0;
        Arrays.fill(dist, -1);
        if (forward) {
            l = this.lF;
            lOther = this.lB;
            u = this.uF;
            uOther = this.uB;
            totDistOther = this.totDistB;
            g = this.graph;
            ecc = this.eccF;
            eccOther = this.eccB;
            toComplete = this.toCompleteF;
            toCompleteOther = this.toCompleteB;
        } else {
            l = this.lB;
            lOther = this.lF;
            u = this.uB;
            uOther = this.uF;
            totDistOther = this.totDistF;
            g = this.revgraph;
            ecc = this.eccB;
            eccOther = this.eccF;
            toComplete = this.toCompleteB;
            toCompleteOther = this.toCompleteF;
        }
        queue[endQ++] = start;
        dist[start] = 0;
        while (startQ < endQ) {
            int w;
            v = queue[startQ++];
            LazyIntIterator iter = g.successors(v);
            while ((w = iter.nextInt()) != -1) {
                if (dist[w] != -1) continue;
                dist[w] = dist[v] + 1;
                queue[endQ++] = w;
            }
        }
        l[start] = eccStart = dist[queue[endQ - 1]];
        u[start] = eccStart;
        ecc[start] = eccStart;
        toComplete[start] = false;
        if (this.dL < eccStart) {
            this.dL = eccStart;
            this.dV = start;
        }
        if (forward && this.accRadial[start] && this.rU > eccStart) {
            this.rU = eccStart;
            this.rV = start;
        }
        for (v = this.nn - 1; v >= 0; --v) {
            if (dist[v] == -1) continue;
            int n = v;
            totDistOther[n] = totDistOther[n] + dist[v];
            if (!toCompleteOther[v] || lOther[v] >= dist[v]) continue;
            lOther[v] = dist[v];
            if (lOther[v] != uOther[v]) continue;
            toCompleteOther[v] = false;
            eccOther[v] = lOther[v];
            if (forward || !this.accRadial[v] || eccOther[v] >= this.rU) continue;
            this.rU = eccOther[v];
            this.rV = v;
        }
        ++this.iter;
        if (this.pl != null) {
            this.pl.update();
        }
    }

    public void sumSweepHeuristic(int start, int iter) {
        LOGGER.debug("Performing initial SumSweep visit from " + start + ".");
        this.stepSumSweep(start, true);
        for (int i = 2; i < iter; ++i) {
            int v;
            if (i % 2 == 0) {
                v = SumSweepDirectedDiameterRadius.argMax(this.totDistB, this.lB, this.toCompleteB);
                LOGGER.debug("Performing initial SumSweep visit from " + v + ".");
                this.stepSumSweep(v, false);
                continue;
            }
            v = SumSweepDirectedDiameterRadius.argMax(this.totDistF, this.lF, this.toCompleteF);
            LOGGER.debug("Performing initial SumSweep visit from " + v + ".");
            this.stepSumSweep(v, true);
        }
    }

    private void findEdgesThroughSCC() {
        int[] sccs = this.scc.component;
        int nscc = this.scc.numberOfComponents;
        int[] bestStart = new int[nscc];
        int[] bestEnd = new int[nscc];
        ImmutableGraph graph = this.graph;
        ImmutableGraph revgraph = this.revgraph;
        int[][] sccGraph = this.sccGraph;
        int[][] startBridges = this.startBridges;
        int[][] endBridges = this.endBridges;
        IntArrayList childComponents = new IntArrayList();
        Arrays.fill(bestStart, -1);
        Arrays.fill(bestEnd, -1);
        IntArrayList[] vertInSCC = new IntArrayList[nscc];
        int i = vertInSCC.length;
        while (i-- > 0) {
            vertInSCC[i] = new IntArrayList();
        }
        for (int v = 0; v < this.nn; ++v) {
            vertInSCC[sccs[v]].add(v);
        }
        for (int c = 0; c < nscc; ++c) {
            int cw;
            IntArrayList component = vertInSCC[c];
            childComponents = new IntArrayList();
            IntListIterator intListIterator = component.iterator();
            while (intListIterator.hasNext()) {
                int w;
                int v = (Integer)intListIterator.next();
                LazyIntIterator iter = graph.successors(v);
                while ((w = iter.nextInt()) != -1) {
                    cw = sccs[w];
                    if (sccs[v] == sccs[w]) continue;
                    if (bestStart[cw] == -1) {
                        bestStart[cw] = v;
                        bestEnd[cw] = w;
                        childComponents.add(cw);
                        continue;
                    }
                    if (graph.outdegree(v) + revgraph.outdegree(w) <= graph.outdegree(bestEnd[cw]) + revgraph.outdegree(bestStart[cw])) continue;
                    bestStart[cw] = v;
                    bestEnd[cw] = w;
                }
            }
            int nSons = childComponents.size();
            sccGraph[c] = new int[nSons];
            startBridges[c] = new int[nSons];
            endBridges[c] = new int[nSons];
            for (int i2 = 0; i2 < nSons; ++i2) {
                sccGraph[c][i2] = cw = childComponents.getInt(i2);
                startBridges[c][i2] = bestStart[cw];
                endBridges[c][i2] = bestEnd[cw];
                bestStart[cw] = -1;
            }
        }
    }

    private int[][] computeDistPivot(int[] pivot, boolean forward) {
        int nn = this.nn;
        int[] scc = this.scc.component;
        int[] eccPivot = new int[this.scc.numberOfComponents];
        int[] queue = this.queue;
        int[] distPivot = new int[nn];
        Arrays.fill(distPivot, -1);
        ImmutableGraph g = forward ? this.graph : this.revgraph;
        for (int p : pivot) {
            int startQ = 0;
            int endQ = 0;
            queue[endQ++] = p;
            distPivot[p] = 0;
            while (startQ < endQ) {
                int w;
                int v = queue[startQ++];
                LazyIntIterator iter = g.successors(v);
                while ((w = iter.nextInt()) != -1) {
                    if (scc[w] != scc[p] || distPivot[w] != -1) continue;
                    distPivot[w] = distPivot[v] + 1;
                    eccPivot[scc[p]] = distPivot[w];
                    queue[endQ++] = w;
                }
            }
        }
        return new int[][]{distPivot, eccPivot};
    }

    private void allCCUpperBound(int[] pivot) {
        int end;
        int start;
        int nextC;
        int i;
        int c;
        int[][] distEccF = this.computeDistPivot(pivot, true);
        int[][] distEccB = this.computeDistPivot(pivot, false);
        int[] distPivotF = distEccF[0];
        int[] eccPivotF = distEccF[1];
        int[] distPivotB = distEccB[0];
        int[] eccPivotB = distEccB[1];
        int[][] sccGraph = this.sccGraph;
        int[][] startBridges = this.startBridges;
        int[][] endBridges = this.endBridges;
        int[] uF = this.uF;
        int[] uB = this.uB;
        int[] lF = this.lF;
        int[] lB = this.lB;
        int[] eccF = this.eccF;
        int[] eccB = this.eccB;
        int[] sccs = this.scc.component;
        boolean[] accRadial = this.accRadial;
        boolean[] toCompleteB = this.toCompleteB;
        boolean[] toCompleteF = this.toCompleteF;
        int nscc = this.scc.numberOfComponents;
        block0: for (c = 0; c < nscc; ++c) {
            int p = pivot[c];
            for (i = 0; i < sccGraph[c].length; ++i) {
                nextC = sccGraph[c][i];
                start = startBridges[c][i];
                end = endBridges[c][i];
                eccPivotF[c] = Math.max(eccPivotF[c], distPivotF[start] + 1 + distPivotB[end] + eccPivotF[nextC]);
                if (eccPivotF[c] < uF[p]) continue;
                eccPivotF[c] = uF[p];
                continue block0;
            }
        }
        c = nscc;
        while (c-- > 0) {
            for (i = 0; i < sccGraph[c].length; ++i) {
                nextC = sccGraph[c][i];
                start = startBridges[c][i];
                end = endBridges[c][i];
                eccPivotB[nextC] = Math.max(eccPivotB[nextC], distPivotF[start] + 1 + distPivotB[end] + eccPivotB[c]);
                if (eccPivotB[nextC] < uB[pivot[nextC]]) continue;
                eccPivotB[nextC] = uB[pivot[nextC]];
            }
        }
        for (int v = 0; v < this.nn; ++v) {
            uF[v] = Math.min(uF[v], distPivotB[v] + eccPivotF[sccs[v]]);
            if (uF[v] == lF[v]) {
                toCompleteF[v] = false;
                eccF[v] = uF[v];
                if (accRadial[v] && uF[v] < this.rU) {
                    this.rU = uF[v];
                    this.rV = v;
                }
            }
            uB[v] = Math.min(uB[v], distPivotF[v] + eccPivotB[sccs[v]]);
            if (uB[v] != lB[v]) continue;
            toCompleteB[v] = false;
            eccB[v] = uB[v];
        }
        this.iter += 3;
    }

    private int findMissingNodes() {
        int missingR = 0;
        int missingDF = 0;
        int missingDB = 0;
        int missingAllF = 0;
        int missingAllB = 0;
        boolean[] toCompleteF = this.toCompleteF;
        boolean[] toCompleteB = this.toCompleteB;
        boolean[] accRadial = this.accRadial;
        int[] uF = this.uF;
        int[] uB = this.uB;
        int[] lF = this.lF;
        int dL = this.dL;
        int rU = this.rU;
        int v = this.nn;
        while (v-- > 0) {
            if (toCompleteF[v]) {
                ++missingAllF;
                if (uF[v] > dL) {
                    ++missingDF;
                }
                if (accRadial[v] && lF[v] < rU) {
                    ++missingR;
                }
            }
            if (!toCompleteB[v]) continue;
            ++missingAllB;
            if (uB[v] <= dL) continue;
            ++missingDB;
        }
        if (missingR == 0 && this.iterR == -1) {
            this.iterR = this.iter;
        }
        if ((missingDF == 0 || missingDB == 0) && this.iterD == -1) {
            this.iterD = this.iter;
        }
        if (missingAllF == 0 && this.iterAllF == -1) {
            this.iterAllF = this.iter;
        }
        if (missingAllF == 0 && missingAllB == 0) {
            this.iterAll = this.iter;
        }
        switch (this.output) {
            case RADIUS: {
                return missingR;
            }
            case DIAMETER: {
                return Math.min(missingDF, missingDB);
            }
            case RADIUS_DIAMETER: {
                return missingR + Math.min(missingDF, missingDB);
            }
            case ALL_FORWARD: {
                return missingAllF;
            }
        }
        return missingAllF + missingAllB;
    }

    public void compute() {
        int missingNodes;
        if (this.pl != null) {
            this.pl.start((CharSequence)"Starting visits...");
            this.pl.itemsName = "nodes";
            this.pl.displayLocalSpeed = true;
        }
        int maxDeg = Integer.MIN_VALUE;
        int maxDegVert = -1;
        for (int v = 0; v < this.nn; ++v) {
            if (this.graph.outdegree(v) <= maxDeg) continue;
            maxDeg = this.graph.outdegree(v);
            maxDegVert = v;
        }
        this.sumSweepHeuristic(maxDegVert, 6);
        double[] points = new double[6];
        int oldMissingNodes = missingNodes = this.findMissingNodes();
        Arrays.fill(points, (double)this.graph.numNodes());
        while (missingNodes > 0) {
            int stepToPerform = SumSweepDirectedDiameterRadius.argMax(points);
            switch (stepToPerform) {
                case 0: {
                    LOGGER.debug("Performing AllCCUpperBound.");
                    this.allCCUpperBound(this.findBestPivot());
                    break;
                }
                case 1: {
                    LOGGER.debug("Performing a forward BFS, from a vertex maximizing the upper bound.");
                    this.stepSumSweep(SumSweepDirectedDiameterRadius.argMax(this.uF, this.totDistF, this.toCompleteF), true);
                    break;
                }
                case 2: {
                    LOGGER.debug("Performing a forward BFS, from a vertex minimizing the lower bound.");
                    this.stepSumSweep(SumSweepDirectedDiameterRadius.argMin(this.lF, this.totDistF, this.accRadial), true);
                    break;
                }
                case 3: {
                    LOGGER.debug("Performing a backward BFS, from a vertex maximizing the upper bound.");
                    this.stepSumSweep(SumSweepDirectedDiameterRadius.argMax(this.uB, this.totDistB, this.toCompleteB), false);
                    break;
                }
                case 4: {
                    LOGGER.debug("Performing a backward BFS, from a vertex maximizing the distance sum.");
                    this.stepSumSweep(SumSweepDirectedDiameterRadius.argMax(this.totDistB, this.uB, this.toCompleteB), false);
                    break;
                }
                case 5: {
                    LOGGER.debug("Performing a forward BFS, from a vertex maximizing the distance sum.");
                    this.stepSumSweep(SumSweepDirectedDiameterRadius.argMax(this.totDistF, this.uF, this.toCompleteF), false);
                }
            }
            oldMissingNodes = missingNodes;
            missingNodes = this.findMissingNodes();
            points[stepToPerform] = oldMissingNodes - missingNodes;
            for (int j = 0; j < points.length; ++j) {
                if (j == stepToPerform || !(points[j] >= 0.0)) continue;
                points[j] = points[j] + 2.0 / (double)this.iter;
            }
            LOGGER.debug("    Missing nodes: " + missingNodes + "/" + 2 * this.nn + ".");
        }
        if (this.output == OutputLevel.RADIUS || this.output == OutputLevel.RADIUS_DIAMETER) {
            LOGGER.debug("Radius: " + this.rU + " (" + this.iterR + " iterations).");
        }
        if (this.output == OutputLevel.DIAMETER || this.output == OutputLevel.RADIUS_DIAMETER) {
            LOGGER.debug("Diameter: " + this.dL + " (" + this.iterD + " iterations).");
        }
        if (this.pl != null) {
            this.pl.done();
        }
    }

    public static void main(String[] arg) throws IOException, JSAPException {
        ImmutableGraph graph;
        SimpleJSAP jsap = new SimpleJSAP(SumSweepDirectedDiameterRadius.class.getName(), "Computes the diameter, radius, diameter and radius, or all eccentricities in a graph, using the ExactSumSweep algorithm.", new Parameter[]{new Switch("expand", 'e', "expand", "Expand the graph to increase speed (no compression)."), new Switch("mapped", 'm', "mapped", "Use loadMapped() to load the graph."), new UnflaggedOption("graphBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the graph."), new UnflaggedOption("forwardOutputFilename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "The filename where the resulting forward eccentricities (integers in binary form) are stored. If not available, the output file is not produced."), new UnflaggedOption("backwardOutputFilename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "The filename where the resulting backward eccentricities (integers in binary form) are stored. If not available, the output file is not produced."), new FlaggedOption("level", (StringParser)EnumStringParser.getParser(OutputLevel.class), OutputLevel.ALL.name(), true, 'l', "level", Arrays.toString((Object[])OutputLevel.values()))});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        boolean mapped = jsapResult.getBoolean("mapped", false);
        String graphBasename = jsapResult.getString("graphBasename");
        ProgressLogger progressLogger = new ProgressLogger(LOGGER, "nodes");
        OutputLevel level = Enum.valueOf(OutputLevel.class, jsapResult.getObject("level").toString().toUpperCase());
        String forwardOutputFilename = jsapResult.getString("forwardOutputFilename");
        String backwardOutputFilename = jsapResult.getString("backwardOutputFilename");
        progressLogger.displayFreeMemory = true;
        progressLogger.displayLocalSpeed = true;
        ImmutableGraph immutableGraph = graph = mapped ? ImmutableGraph.loadMapped(graphBasename, progressLogger) : ImmutableGraph.load(graphBasename, progressLogger);
        if (jsapResult.userSpecified("expand")) {
            graph = new ArrayListMutableGraph(graph).immutableView();
        }
        SumSweepDirectedDiameterRadius ss = new SumSweepDirectedDiameterRadius(graph, level, null, progressLogger);
        ss.compute();
        if (level != OutputLevel.DIAMETER) {
            System.out.println("Radius: " + ss.rU + " (" + ss.iterR + " iterations).");
        }
        if (level != OutputLevel.RADIUS) {
            System.out.println("Diameter: " + ss.dL + " (" + ss.iterD + " iterations).");
        }
        if (forwardOutputFilename != null && (level == OutputLevel.ALL || level == OutputLevel.ALL_FORWARD)) {
            BinIO.storeInts((int[])ss.eccF, (CharSequence)forwardOutputFilename);
        }
        if (backwardOutputFilename != null && level == OutputLevel.ALL) {
            BinIO.storeInts((int[])ss.eccB, (CharSequence)backwardOutputFilename);
        }
    }

    public static enum OutputLevel {
        RADIUS,
        DIAMETER,
        RADIUS_DIAMETER,
        ALL_FORWARD,
        ALL;

    }
}

