/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.algo;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntHeapPriorityQueue;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.lang.EnumStringParser;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.ArrayListMutableGraph;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import it.unimi.dsi.webgraph.algo.StronglyConnectedComponents;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopKGeometricCentrality {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopKGeometricCentrality.class);
    private static final boolean DEBUG = false;
    private final ImmutableGraph graph;
    private final int nn;
    private final ProgressLogger pl;
    private final int k;
    private final int threads;
    private final Centrality centralityType;
    private final double alpha;
    private final int[] reachL;
    private final int[] reachU;
    private final int[] degs;
    private final int[] sortedVertDeg;
    private int finishedVisits;
    private int currentV;
    private double kth;
    private long neVis;
    public final double[] centrality;
    public int[] topK;
    private final IntHeapPriorityQueue topKQueue;

    public static TopKGeometricCentrality newLinCentrality(ImmutableGraph g, int k, int threads) throws IllegalArgumentException {
        return new TopKGeometricCentrality(g, k, Centrality.LIN, threads, 0.5, new ProgressLogger());
    }

    public static TopKGeometricCentrality newHarmonicCentrality(ImmutableGraph g, int k, int threads) {
        return new TopKGeometricCentrality(g, k, Centrality.HARMONIC, threads, 0.5, new ProgressLogger());
    }

    public static TopKGeometricCentrality newExponentialCentrality(ImmutableGraph g, int k, double alpha, int threads) {
        return new TopKGeometricCentrality(g, k, Centrality.EXPONENTIAL, threads, alpha, new ProgressLogger());
    }

    public TopKGeometricCentrality(ImmutableGraph g, int k, Centrality centralityType, int threads, double alpha, ProgressLogger pl) {
        this.alpha = alpha;
        this.centralityType = centralityType;
        this.neVis = 0L;
        this.finishedVisits = 0;
        this.kth = 0.0;
        this.pl = pl;
        this.graph = g;
        this.nn = this.graph.numNodes();
        this.k = Math.min(k, this.nn);
        this.centrality = new double[this.nn];
        this.topKQueue = new IntHeapPriorityQueue((x, y) -> (int)Math.signum(this.centrality[x] - this.centrality[y]));
        this.reachL = new int[this.nn];
        this.reachU = new int[this.nn];
        if (centralityType == Centrality.EXPONENTIAL && (alpha <= 0.0 || alpha >= 1.0)) {
            throw new IllegalArgumentException("The value alpha must be strictly between 0 and 1.");
        }
        if (k <= 0) {
            throw new IllegalArgumentException("k must be positive.");
        }
        if (threads < 0) {
            throw new IllegalArgumentException("The number of threads must not be negative.");
        }
        this.threads = threads == 0 ? Runtime.getRuntime().availableProcessors() : threads;
        LOGGER.debug("Nodes: " + this.nn);
        LOGGER.debug("Arcs: " + this.graph.numArcs());
        this.computeReach();
        this.degs = new int[this.nn];
        for (int v = 0; v < this.nn; ++v) {
            this.degs[v] = this.graph.outdegree(v);
        }
        this.sortedVertDeg = TopKGeometricCentrality.countingSort(this.degs);
        this.currentV = this.nn - 1;
    }

    private static int[] countingSort(int[] values) {
        int i;
        int[] sorted = new int[values.length];
        int[] numValues = new int[values.length + 1];
        for (int i2 : values) {
            int n = i2 + 1;
            numValues[n] = numValues[n] + 1;
        }
        for (i = 1; i < numValues.length; ++i) {
            int n = i;
            numValues[n] = numValues[n] + numValues[i - 1];
        }
        i = 0;
        while (i < values.length) {
            int n = values[i];
            int n2 = numValues[n];
            numValues[n] = n2 + 1;
            sorted[n2] = i++;
        }
        return sorted;
    }

    private void computeReach() {
        int vComp;
        int xComp;
        IntListIterator intListIterator;
        int wComp;
        int i;
        StronglyConnectedComponents scc = StronglyConnectedComponents.compute(this.graph, false, this.pl);
        int nscc = scc.numberOfComponents;
        int[] sortedVerts = new int[this.nn];
        int maxSCC = 0;
        int[] sccSizes = new int[nscc];
        boolean[] visited = new boolean[nscc];
        boolean[] reachMaxSCC = new boolean[nscc];
        long[] lReachSCC = new long[nscc];
        long[] uReachSCC = new long[nscc];
        long[] uReachSCCWithoutMax = new long[nscc];
        LOGGER.debug("There are " + nscc + " strongly connected components.");
        IntArrayList[] sccGraph = new IntArrayList[nscc];
        for (i = 0; i < nscc; ++i) {
            sccGraph[i] = new IntArrayList();
        }
        sortedVerts = TopKGeometricCentrality.countingSort(scc.component);
        i = 0;
        int v = sortedVerts[i++];
        for (int contSCC = 0; contSCC < nscc; ++contSCC) {
            while (scc.component[v] == contSCC) {
                int w;
                int n = contSCC;
                sccSizes[n] = sccSizes[n] + 1;
                LazyIntIterator iter = this.graph.successors(v);
                while ((w = iter.nextInt()) != -1) {
                    wComp = scc.component[w];
                    if (visited[wComp] || contSCC == wComp) continue;
                    visited[wComp] = true;
                    sccGraph[contSCC].add(wComp);
                }
                if (i >= this.nn) break;
                v = sortedVerts[i++];
            }
            IntListIterator intListIterator2 = sccGraph[contSCC].iterator();
            while (intListIterator2.hasNext()) {
                int xComp2 = (Integer)intListIterator2.next();
                visited[xComp2] = false;
            }
            if (sccSizes[contSCC] <= sccSizes[maxSCC]) continue;
            maxSCC = contSCC;
        }
        int[] queue = new int[nscc];
        int startQ = 0;
        int endQ = 0;
        queue[endQ++] = maxSCC;
        visited[maxSCC] = true;
        while (startQ < endQ) {
            wComp = queue[startQ++];
            int n = maxSCC;
            lReachSCC[n] = lReachSCC[n] + (long)sccSizes[wComp];
            intListIterator = sccGraph[wComp].iterator();
            while (intListIterator.hasNext()) {
                xComp = (Integer)intListIterator.next();
                if (visited[xComp]) continue;
                visited[xComp] = true;
                queue[endQ++] = xComp;
            }
        }
        uReachSCC[maxSCC] = lReachSCC[maxSCC];
        reachMaxSCC[maxSCC] = true;
        for (vComp = 0; vComp < nscc; ++vComp) {
            if (vComp == maxSCC) continue;
            intListIterator = sccGraph[vComp].iterator();
            while (intListIterator.hasNext()) {
                xComp = (Integer)intListIterator.next();
                lReachSCC[vComp] = Math.max(lReachSCC[vComp], lReachSCC[xComp]);
                if (!visited[xComp]) {
                    int n = vComp;
                    uReachSCCWithoutMax[n] = uReachSCCWithoutMax[n] + uReachSCCWithoutMax[xComp];
                }
                int n = vComp;
                uReachSCC[n] = uReachSCC[n] + uReachSCC[xComp];
                uReachSCC[vComp] = Math.min(uReachSCC[vComp], (long)this.nn);
                reachMaxSCC[vComp] = reachMaxSCC[vComp] || reachMaxSCC[xComp];
            }
            int n = vComp;
            lReachSCC[n] = lReachSCC[n] + (long)sccSizes[vComp];
            int n2 = vComp;
            uReachSCC[n2] = uReachSCC[n2] + (long)sccSizes[vComp];
            if (!visited[vComp]) {
                int n3 = vComp;
                uReachSCCWithoutMax[n3] = uReachSCCWithoutMax[n3] + (long)sccSizes[vComp];
            }
            if (reachMaxSCC[vComp]) {
                uReachSCC[vComp] = uReachSCC[maxSCC] + uReachSCCWithoutMax[vComp];
            }
            uReachSCC[vComp] = Math.min(uReachSCC[vComp], (long)this.nn);
        }
        for (v = 0; v < this.nn; ++v) {
            vComp = scc.component[v];
            this.reachL[v] = (int)Math.min(lReachSCC[vComp], (long)this.nn);
            this.reachU[v] = (int)Math.min(uReachSCC[vComp], (long)this.nn);
        }
    }

    void checkReachLU() {
        int[] queue = new int[this.nn];
        for (int v = 0; v < this.nn; ++v) {
            int startQ = 0;
            int endQ = 0;
            boolean[] visited = new boolean[this.nn];
            visited[v] = true;
            queue[endQ++] = v;
            while (startQ < endQ) {
                int y;
                int x = queue[startQ++];
                LazyIntIterator iter = this.graph.successors(x);
                while ((y = iter.nextInt()) != -1) {
                    if (visited[y]) continue;
                    visited[y] = true;
                    queue[endQ++] = y;
                }
            }
            assert (this.reachL[v] <= startQ);
            assert (this.reachU[v] >= startQ);
        }
    }

    private synchronized int nextVert() {
        if (this.currentV >= 0) {
            return this.sortedVertDeg[this.currentV--];
        }
        return -1;
    }

    private synchronized void endBFS(int v, double centrality, int neVis) {
        this.neVis += (long)neVis;
        if (this.pl != null) {
            this.pl.update();
        }
        this.centrality[v] = centrality;
        if (centrality >= 0.0) {
            this.topKQueue.enqueue(v);
            if (this.topKQueue.size() > this.k) {
                this.topKQueue.dequeueInt();
            }
            if (this.topKQueue.size() == this.k) {
                this.kth = this.centrality[this.topKQueue.firstInt()];
            }
        }
    }

    public void compute() {
        int i;
        if (this.pl != null) {
            this.pl.start((CharSequence)"Starting visits...");
            this.pl.itemsName = "nodes";
            this.pl.displayLocalSpeed = true;
        }
        GeometricCentralityThread[] threads = new GeometricCentralityThread[this.threads];
        for (i = 0; i < this.threads; ++i) {
            threads[i] = new GeometricCentralityThread();
            threads[i].start();
        }
        for (i = 0; i < this.threads; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.topK = new int[this.topKQueue.size()];
        for (i = this.topKQueue.size() - 1; i >= 0; --i) {
            this.topK[i] = this.topKQueue.dequeueInt();
        }
        if (this.pl != null) {
            this.pl.done();
        }
    }

    public static void main(String[] args) throws JSAPException, IOException {
        SimpleJSAP jsap = new SimpleJSAP(TopKGeometricCentrality.class.getName(), "Computes top-k central vertices according to different positive geometric centrality measures. Outputs a file with extension .nodes containing the top k nodes (most central nodes first), and a file with extension .values containing the corresponding centralities.\nPlease note that to compute negative centralities on directed graphs (which is usually what you want) you have to compute positive centralities on the transpose.", new Parameter[]{new Switch("expand", 'e', "expand", "Expand the graph to increase speed (no compression)."), new Switch("text", 't', "text", "If true, a human-readable text file is produced, otherwise two binary files containing nodes and centralities."), new FlaggedOption("k", (StringParser)JSAP.INTSIZE_PARSER, "1", false, 'k', "k", "The number of vertices to be output"), new FlaggedOption("centrality", (StringParser)EnumStringParser.getParser(Centrality.class, (boolean)true), Centrality.HARMONIC.name(), true, 'c', "centrality", Arrays.toString((Object[])Centrality.values())), new FlaggedOption("threads", (StringParser)JSAP.INTSIZE_PARSER, "0", false, 'T', "threads", "The number of threads to be used. If 0, the number will be estimated automatically."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new FlaggedOption("alpha", (StringParser)JSAP.DOUBLE_PARSER, "0.5", false, 'a', "alpha", "The value of alpha for exponential centrality (ignored, otherwise)."), new UnflaggedOption("graphBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the graph."), new UnflaggedOption("outputBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The output basename.")});
        JSAPResult jsapResult = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        String basename = jsapResult.getString("graphBasename");
        int k = jsapResult.getInt("k");
        String outputBasename = jsapResult.getString("outputBasename");
        Centrality centrality = Enum.valueOf(Centrality.class, jsapResult.getObject("centrality").toString().toUpperCase());
        int threads = jsapResult.getInt("threads");
        long logInterval = jsapResult.getLong("logInterval");
        double alpha = jsapResult.getDouble("alpha");
        if (centrality == Centrality.EXPONENTIAL && (alpha <= 0.0 || alpha >= 1.0)) {
            throw new IllegalArgumentException("The value alpha must be strictly between 0 and 1.");
        }
        if (threads == 0) {
            threads = Runtime.getRuntime().availableProcessors();
        }
        ImmutableGraph g = ImmutableGraph.load(basename);
        if (jsapResult.userSpecified("expand")) {
            g = new ArrayListMutableGraph(g).immutableView();
        }
        ProgressLogger pl = new ProgressLogger(LOGGER, logInterval, TimeUnit.MILLISECONDS, "nodes");
        TopKGeometricCentrality c = new TopKGeometricCentrality(g, k, centrality, threads, alpha, pl);
        c.compute();
        if (jsapResult.getBoolean("text")) {
            PrintStream outputNodes = new PrintStream(outputBasename + ".nodes");
            PrintStream outputValues = new PrintStream(outputBasename + ".values");
            for (int v : c.topK) {
                outputNodes.println(v);
                outputValues.println(c.centrality[v]);
            }
            outputNodes.close();
            outputValues.close();
        } else {
            DataOutputStream outputNodes = new DataOutputStream(new FileOutputStream(outputBasename + ".nodes"));
            DataOutputStream outputValues = new DataOutputStream(new FileOutputStream(outputBasename + ".values"));
            for (int v : c.topK) {
                outputNodes.writeInt(v);
                outputValues.writeDouble(c.centrality[v]);
            }
            outputNodes.close();
            outputValues.close();
        }
        LOGGER.info("\nFinal improvement: " + (double)c.nn * (double)c.graph.numArcs() / (double)c.neVis);
    }

    public static enum Centrality {
        LIN,
        HARMONIC,
        EXPONENTIAL;

    }

    private class GeometricCentralityThread
    extends Thread {
        private final int nn;
        private final Centrality centralityType;
        private final int[] dist;
        private final int[] queue;
        private final ImmutableGraph graph;
        private int neVis;
        private int nnVis;

        GeometricCentralityThread() {
            this.nn = TopKGeometricCentrality.this.nn;
            this.centralityType = TopKGeometricCentrality.this.centralityType;
            this.graph = TopKGeometricCentrality.this.graph.copy();
            this.dist = new int[this.nn];
            this.queue = new int[this.nn];
            Arrays.fill(this.dist, -1);
        }

        private double BFSCut(int v) {
            if (this.graph.outdegree(v) == 0) {
                if (this.centralityType == Centrality.LIN) {
                    return 1.0;
                }
                return 0.0;
            }
            int startQ = 0;
            int d = -1;
            int gamma = this.graph.outdegree(v);
            double sumDist = 0.0;
            double tildefL = 0.0;
            double tildefU = 0.0;
            double reachL = TopKGeometricCentrality.this.reachL[v];
            double reachU = TopKGeometricCentrality.this.reachU[v];
            int[] queue = this.queue;
            int[] dist = this.dist;
            int[] degs = TopKGeometricCentrality.this.degs;
            Centrality centrality = this.centralityType;
            double kth = TopKGeometricCentrality.this.kth;
            double alpha = TopKGeometricCentrality.this.alpha;
            for (int i = 0; i < this.nnVis; ++i) {
                dist[queue[i]] = -1;
            }
            this.nnVis = 0;
            dist[v] = 0;
            queue[this.nnVis++] = v;
            while (startQ < this.nnVis) {
                int y;
                int x = queue[startQ++];
                LazyIntIterator iter = this.graph.successors(x);
                if (dist[x] > d) {
                    ++d;
                    if (centrality == Centrality.LIN) {
                        tildefL = (sumDist - (double)gamma + (double)(d + 2) * (reachL - (double)this.nnVis)) / (reachL * reachL);
                        tildefU = (sumDist - (double)gamma + (double)(d + 2) * (reachU - (double)this.nnVis)) / (reachU * reachU);
                        if (kth > 0.0 && tildefL >= 1.0 / kth && tildefU >= 1.0 / kth) {
                            return -1.0;
                        }
                    } else if (centrality == Centrality.HARMONIC ? (tildefL = sumDist + (double)gamma / (double)(d + 1) + (reachU - (double)gamma - (double)this.nnVis) / (double)(d + 2)) <= kth : (tildefL = sumDist + (double)gamma * Math.pow(alpha, d + 1) + (reachU - (double)gamma - (double)this.nnVis) * Math.pow(alpha, d + 2)) <= kth) {
                        return -1.0;
                    }
                    gamma = 0;
                }
                while ((y = iter.nextInt()) != -1) {
                    ++this.neVis;
                    if (dist[y] == -1) {
                        dist[y] = dist[x] + 1;
                        sumDist = centrality == Centrality.LIN ? (sumDist += (double)dist[y]) : (centrality == Centrality.HARMONIC ? (sumDist += 1.0 / (double)dist[y]) : (sumDist += Math.pow(alpha, dist[y])));
                        queue[this.nnVis++] = y;
                        gamma += degs[y];
                        continue;
                    }
                    if (centrality == Centrality.LIN) {
                        tildefL += 1.0 / (reachL * reachL);
                        tildefU += 1.0 / (reachU * reachU);
                        if (!(kth > 0.0) || !(tildefL >= 1.0 / kth) || !(tildefU >= 1.0 / kth)) continue;
                        return -1.0;
                    }
                    if (!(centrality == Centrality.HARMONIC ? (tildefL += 1.0 / (double)(d + 2) - 1.0 / (double)(d + 1)) <= kth : (tildefL += Math.pow(alpha, d + 2) - Math.pow(alpha, d + 1)) <= kth)) continue;
                    return -1.0;
                }
            }
            if (centrality == Centrality.LIN) {
                return (double)this.nnVis * (double)this.nnVis / sumDist;
            }
            return sumDist;
        }

        @Override
        public void run() {
            int v = TopKGeometricCentrality.this.nextVert();
            while (v != -1) {
                this.neVis = 0;
                double centrality = this.BFSCut(v);
                TopKGeometricCentrality.this.endBFS(v, centrality, this.neVis);
                v = TopKGeometricCentrality.this.nextVert();
            }
        }
    }
}

