/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.examples;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.ImmutableSequentialGraph;
import it.unimi.dsi.webgraph.NodeIterator;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.NoSuchElementException;

public class IntegerListImmutableGraph
extends ImmutableSequentialGraph {
    private final String filename;
    private final int numNodes;

    private IntegerListImmutableGraph(CharSequence filename) throws IOException {
        this.filename = filename.toString();
        DataInputStream dis = new DataInputStream(new FileInputStream(this.filename));
        this.numNodes = dis.readInt();
        dis.close();
    }

    @Override
    public int numNodes() {
        return this.numNodes;
    }

    @Override
    public NodeIterator nodeIterator() {
        try {
            return new NodeIterator(){
                final int n;
                final DataInputStream dis;
                int curr;
                int outdegree;
                int[] successorsArray;
                {
                    this.n = IntegerListImmutableGraph.this.numNodes();
                    this.dis = new DataInputStream(new FileInputStream(IntegerListImmutableGraph.this.filename));
                    this.curr = -1;
                    this.successorsArray = IntArrays.EMPTY_ARRAY;
                    try {
                        this.dis.readInt();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public int nextInt() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        this.outdegree = this.dis.readInt();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return ++this.curr;
                }

                public boolean hasNext() {
                    return this.curr < this.n - 1;
                }

                @Override
                public int[] successorArray() {
                    if (this.curr == -1) {
                        throw new IllegalStateException();
                    }
                    this.successorsArray = IntArrays.ensureCapacity((int[])this.successorsArray, (int)this.outdegree, (int)0);
                    try {
                        for (int i = 0; i < this.outdegree; ++i) {
                            this.successorsArray[i] = this.dis.readInt();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return this.successorsArray;
                }

                @Override
                public int outdegree() {
                    if (this.curr == -1) {
                        throw new IllegalStateException();
                    }
                    return this.outdegree;
                }

                protected void finalize() throws Throwable {
                    try {
                        this.dis.close();
                    }
                    finally {
                        super.finalize();
                    }
                }

                @Override
                public NodeIterator copy(int upperBound) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static ImmutableGraph load(CharSequence basename, ProgressLogger pl) {
        throw new UnsupportedOperationException("Graphs may be loaded offline only");
    }

    public static ImmutableGraph load(CharSequence basename) {
        return IntegerListImmutableGraph.load(basename, null);
    }

    @Deprecated
    public static ImmutableGraph loadSequential(CharSequence basename, ProgressLogger pl) {
        return IntegerListImmutableGraph.load(basename, pl);
    }

    @Deprecated
    public static ImmutableGraph loadSequential(CharSequence basename) {
        return IntegerListImmutableGraph.load(basename, null);
    }

    public static ImmutableGraph loadOffline(CharSequence basename, ProgressLogger pl) throws IOException {
        return new IntegerListImmutableGraph(basename);
    }

    public static ImmutableGraph loadOffline(CharSequence basename) throws IOException {
        return IntegerListImmutableGraph.loadOffline(basename, null);
    }
}

