/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.examples;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.io.TextIO;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.GraphClassParser;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.NodeIterator;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;

public class OutdegreeStats {
    private OutdegreeStats() {
    }

    public static void main(String[] arg) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, JSAPException, IOException {
        SimpleJSAP jsap = new SimpleJSAP(OutdegreeStats.class.getName(), "Prints on standard error the maximum, minimum and average degree of a graph, and outputs on standard output the numerosity of each outdegree value (first line is the number of nodes with outdegree 0).", new Parameter[]{new FlaggedOption("graphClass", (StringParser)GraphClassParser.getParser(), null, false, 'g', "graph-class", "Forces a Java class for the source graph."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the graph.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        Class graphClass = jsapResult.getClass("graphClass");
        String basename = jsapResult.getString("basename");
        ProgressLogger pl = new ProgressLogger();
        pl.logInterval = jsapResult.getLong("logInterval");
        ImmutableGraph graph = graphClass != null ? (ImmutableGraph)graphClass.getMethod("loadOffline", CharSequence.class).invoke(null, basename) : ImmutableGraph.loadOffline(basename, pl);
        NodeIterator nodeIterator = graph.nodeIterator();
        int[] count = IntArrays.EMPTY_ARRAY;
        int maxd = 0;
        int maxNode = 0;
        int mind = Integer.MAX_VALUE;
        int minNode = 0;
        long totd = 0L;
        pl.expectedUpdates = graph.numNodes();
        pl.start((CharSequence)"Scanning...");
        int i = graph.numNodes();
        while (i-- != 0) {
            int curr = nodeIterator.nextInt();
            int d = nodeIterator.outdegree();
            if (d < mind) {
                mind = d;
                minNode = curr;
            }
            if (d > maxd) {
                maxd = d;
                maxNode = curr;
            }
            totd += (long)d;
            if (d >= count.length) {
                count = IntArrays.grow((int[])count, (int)(d + 1));
            }
            int n = d;
            count[n] = count[n] + 1;
            pl.lightUpdate();
        }
        pl.done();
        System.err.println("The minimum outdegree is " + mind + ", attained by node " + minNode);
        System.err.println("The maximum outdegree is " + maxd + ", attained by node " + maxNode);
        System.err.println("The average outdegree is " + (double)totd / (double)graph.numNodes());
        TextIO.storeInts((int[])count, (int)0, (int)(maxd + 1), (PrintStream)System.out);
    }
}

