/*
 * Copyright 2012, 2020 International Business Machines Corp.
 * 
 * See the NOTICE file distributed with this work for additional information
 * regarding copyright ownership. Licensed under the Apache License, 
 * Version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

package jakarta.batch.runtime;
/**
  * 
  * The Metric interface defines job metrics recorded by
  * the batch runtime.
  *
  */
public interface Metric {
	/**
	 *  The enum defining the specification-defined metric types.
	 */
	public enum MetricType {READ_COUNT, WRITE_COUNT, COMMIT_COUNT, 
	       ROLLBACK_COUNT, READ_SKIP_COUNT, PROCESS_SKIP_COUNT, FILTER_COUNT, 
	       WRITE_SKIP_COUNT}
	/**
	 * The getName method returns the metric type. 
	 * @return metric type.
	 */
	public MetricType getType(); 
	/**
	 * The getValue method returns the metric value.
	 * @return metric value.
	 */
	public long getValue();
}
