/*
 * Decompiled with CFR 0.152.
 */
package arjuna.JavaSim.Statistics;

import arjuna.JavaSim.Statistics.Mean;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class Variance
extends Mean {
    private double _sqr;

    public Variance() {
        this.reset();
    }

    public void setValue(double value) throws IllegalArgumentException {
        this._sqr += value * value;
        super.setValue(value);
    }

    public void reset() {
        this._sqr = 0.0;
        super.reset();
    }

    public double variance() {
        if (this._Number > 1) {
            return (this._sqr - this._Sum * this._Sum / (double)this._Number) / (double)(this._Number - 1);
        }
        return 0.0;
    }

    public double stdDev() {
        if (this._Number == 0 || this.variance() <= 0.0) {
            return 0.0;
        }
        return Math.sqrt(this.variance());
    }

    public double confidence(double value) {
        System.out.println("Variance::confidence not implemented yet.");
        return 0.0;
    }

    public void print() {
        System.out.println("Variance          : " + this.variance());
        System.out.println("Standard Deviation: " + this.stdDev());
        super.print();
    }

    public boolean saveState(String fileName) throws IOException {
        FileOutputStream f = new FileOutputStream(fileName);
        DataOutputStream oFile = new DataOutputStream(f);
        boolean res = this.saveState(oFile);
        f.close();
        return res;
    }

    public boolean saveState(DataOutputStream oFile) throws IOException {
        oFile.writeDouble(this._sqr);
        return super.saveState(oFile);
    }

    public boolean restoreState(String fileName) throws FileNotFoundException, IOException {
        FileInputStream f = new FileInputStream(fileName);
        DataInputStream iFile = new DataInputStream(f);
        boolean res = this.restoreState(iFile);
        f.close();
        return res;
    }

    public boolean restoreState(DataInputStream iFile) throws IOException {
        this._sqr = iFile.readDouble();
        return super.restoreState(iFile);
    }
}

