/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.spi.I18NHelper;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateInterrogation;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class JDOHelper {
    private static final I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");
    private static JDOImplHelper implHelper = (JDOImplHelper)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return JDOImplHelper.getInstance();
        }
    });
    static JDOImplHelper.StateInterrogationObjectReturn getPersistenceManager = new JDOImplHelper.StateInterrogationObjectReturn(){

        public Object get(Object pc, StateInterrogation si) {
            return si.getPersistenceManager(pc);
        }
    };
    static JDOImplHelper.StateInterrogationObjectReturn getObjectId = new JDOImplHelper.StateInterrogationObjectReturn(){

        public Object get(Object pc, StateInterrogation si) {
            return si.getObjectId(pc);
        }
    };
    static JDOImplHelper.StateInterrogationObjectReturn getTransactionalObjectId = new JDOImplHelper.StateInterrogationObjectReturn(){

        public Object get(Object pc, StateInterrogation si) {
            return si.getTransactionalObjectId(pc);
        }
    };
    static JDOImplHelper.StateInterrogationObjectReturn getVersion = new JDOImplHelper.StateInterrogationObjectReturn(){

        public Object get(Object pc, StateInterrogation si) {
            return si.getVersion(pc);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isPersistent = new JDOImplHelper.StateInterrogationBooleanReturn(){

        public Boolean is(Object pc, StateInterrogation si) {
            return si.isPersistent(pc);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isTransactional = new JDOImplHelper.StateInterrogationBooleanReturn(){

        public Boolean is(Object pc, StateInterrogation si) {
            return si.isTransactional(pc);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isDirty = new JDOImplHelper.StateInterrogationBooleanReturn(){

        public Boolean is(Object pc, StateInterrogation si) {
            return si.isDirty(pc);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isNew = new JDOImplHelper.StateInterrogationBooleanReturn(){

        public Boolean is(Object pc, StateInterrogation si) {
            return si.isNew(pc);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isDeleted = new JDOImplHelper.StateInterrogationBooleanReturn(){

        public Boolean is(Object pc, StateInterrogation si) {
            return si.isDeleted(pc);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isDetached = new JDOImplHelper.StateInterrogationBooleanReturn(){

        public Boolean is(Object pc, StateInterrogation si) {
            return si.isDetached(pc);
        }
    };
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$javax$jdo$PersistenceManagerFactory;

    public static PersistenceManager getPersistenceManager(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoGetPersistenceManager();
        }
        return (PersistenceManager)implHelper.nonBinaryCompatibleGet(pc, getPersistenceManager);
    }

    public static void makeDirty(Object pc, String fieldName) {
        if (pc instanceof PersistenceCapable) {
            ((PersistenceCapable)pc).jdoMakeDirty(fieldName);
        } else {
            implHelper.nonBinaryCompatibleMakeDirty(pc, fieldName);
        }
    }

    public static Object getObjectId(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoGetObjectId();
        }
        return implHelper.nonBinaryCompatibleGet(pc, getObjectId);
    }

    public static Collection getObjectIds(Collection pcs) {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator it = pcs.iterator();
        while (it.hasNext()) {
            result.add(JDOHelper.getObjectId(it.next()));
        }
        return result;
    }

    public static Object[] getObjectIds(Object[] pcs) {
        Object[] result = new Object[pcs.length];
        for (int i = 0; i < pcs.length; ++i) {
            result[i] = JDOHelper.getObjectId(pcs[i]);
        }
        return result;
    }

    public static Object getTransactionalObjectId(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoGetTransactionalObjectId();
        }
        return implHelper.nonBinaryCompatibleGet(pc, getTransactionalObjectId);
    }

    public static Object getVersion(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoGetVersion();
        }
        return implHelper.nonBinaryCompatibleGet(pc, getVersion);
    }

    public static boolean isDirty(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoIsDirty();
        }
        return implHelper.nonBinaryCompatibleIs(pc, isDirty);
    }

    public static boolean isTransactional(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoIsTransactional();
        }
        return implHelper.nonBinaryCompatibleIs(pc, isTransactional);
    }

    public static boolean isPersistent(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoIsPersistent();
        }
        return implHelper.nonBinaryCompatibleIs(pc, isPersistent);
    }

    public static boolean isNew(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoIsNew();
        }
        return implHelper.nonBinaryCompatibleIs(pc, isNew);
    }

    public static boolean isDeleted(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoIsDeleted();
        }
        return implHelper.nonBinaryCompatibleIs(pc, isDeleted);
    }

    public static boolean isDetached(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoIsDetached();
        }
        return implHelper.nonBinaryCompatibleIs(pc, isDetached);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Map props) {
        ClassLoader cl = JDOHelper.getContextClassLoader();
        return JDOHelper.getPersistenceManagerFactory(props, cl);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Map props, ClassLoader cl) {
        String pmfClassName = (String)props.get("javax.jdo.PersistenceManagerFactoryClass");
        if (pmfClassName == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNoClassNameProperty"));
        }
        try {
            Class<?> pmfClass = cl.loadClass(pmfClassName);
            Method pmfMethod = pmfClass.getMethod("getPersistenceManagerFactory", class$java$util$Map == null ? (class$java$util$Map = JDOHelper.class$("java.util.Map")) : class$java$util$Map);
            return (PersistenceManagerFactory)pmfMethod.invoke(null, props);
        }
        catch (ClassNotFoundException cnfe) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFClassNotFound", pmfClassName), cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFIllegalAccess", pmfClassName), iae);
        }
        catch (NoSuchMethodException nsme) {
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFNoSuchMethod"), nsme);
        }
        catch (InvocationTargetException ite) {
            Throwable nested = ite.getTargetException();
            if (nested instanceof JDOException) {
                throw (JDOException)nested;
            }
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFUnexpectedException"), ite);
        }
        catch (NullPointerException e) {
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFNullPointerException", pmfClassName), e);
        }
        catch (ClassCastException e) {
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFClassCastException", pmfClassName), e);
        }
        catch (Exception e) {
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFUnexpectedException"), e);
        }
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String propsResource) {
        return JDOHelper.getPersistenceManagerFactory(propsResource, JDOHelper.getContextClassLoader());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String propsResource, ClassLoader loader) {
        return JDOHelper.getPersistenceManagerFactory(propsResource, loader, loader);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String propsResource, ClassLoader propsLoader, ClassLoader pmfLoader) {
        if (propsResource == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullResource"));
        }
        if (propsLoader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullPropsLoader"));
        }
        if (pmfLoader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullPMFLoader"));
        }
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = propsLoader.getResourceAsStream(propsResource);
            if (in == null) {
                throw new JDOFatalUserException(msg.msg("EXC_GetPMFNoResource", propsResource, propsLoader));
            }
            props.load(in);
        }
        catch (IOException ioe) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFIOExceptionRsrc", propsResource), ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
        return JDOHelper.getPersistenceManagerFactory(props, pmfLoader);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(File propsFile) {
        return JDOHelper.getPersistenceManagerFactory(propsFile, JDOHelper.getContextClassLoader());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(File propsFile, ClassLoader loader) {
        if (propsFile == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullFile"));
        }
        if (loader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullLoader"));
        }
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(propsFile);
            props.load(in);
        }
        catch (FileNotFoundException fnfe) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNoFile", propsFile, loader), fnfe);
        }
        catch (IOException ioe) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFIOExceptionFile", propsFile), ioe);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ioe) {}
            }
        }
        return JDOHelper.getPersistenceManagerFactory(props, loader);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String jndiLocation, Context context) {
        return JDOHelper.getPersistenceManagerFactory(jndiLocation, context, JDOHelper.getContextClassLoader());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String jndiLocation, Context context, ClassLoader loader) {
        if (jndiLocation == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullJndiLoc"));
        }
        if (loader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullLoader"));
        }
        try {
            if (context == null) {
                context = new InitialContext();
            }
            Object o = context.lookup(jndiLocation);
            return (PersistenceManagerFactory)PortableRemoteObject.narrow((Object)o, (Class)(class$javax$jdo$PersistenceManagerFactory == null ? (class$javax$jdo$PersistenceManagerFactory = JDOHelper.class$("javax.jdo.PersistenceManagerFactory")) : class$javax$jdo$PersistenceManagerFactory));
        }
        catch (NamingException ne) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNamingException", jndiLocation, loader), ne);
        }
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(InputStream stream) {
        return JDOHelper.getPersistenceManagerFactory(stream, JDOHelper.getContextClassLoader());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(InputStream stream, ClassLoader loader) {
        if (stream == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullStream"));
        }
        if (loader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullLoader"));
        }
        Properties props = new Properties();
        try {
            props.load(stream);
        }
        catch (IOException ioe) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFIOExceptionStream"), ioe);
        }
        return JDOHelper.getPersistenceManagerFactory(props, loader);
    }

    private static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

